/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DeletePagesFinder {
    private Set draftBlogPostComparableItemSet;
    private Set draftPageComparableItemSet;
    private Set destinationBlogPostComparableItemSet;
    private Set destinationPageComparableItemSet;

    public DeletePagesFinder(List<BlogPost> allSourceBlogPosts, List<Page> allSourcePages, List<BlogPost> allDestinationBlogPosts, List<Page> allDestinationPages) {
        this.draftBlogPostComparableItemSet = this.transformListIntoBlogPostComparableItemList(allSourceBlogPosts);
        this.draftPageComparableItemSet = this.transformListIntoPageComparableItemList(allSourcePages);
        this.destinationBlogPostComparableItemSet = this.transformListIntoBlogPostComparableItemList(allDestinationBlogPosts);
        this.destinationPageComparableItemSet = this.transformListIntoPageComparableItemList(allDestinationPages);
    }

    private Set transformListIntoPageComparableItemList(List<Page> pageList) {
        if (pageList == null) {
            return new HashSet();
        }
        return PageComparableItem.pageArrayToPageComparableItemSet(pageList);
    }

    private Set transformListIntoBlogPostComparableItemList(List<BlogPost> blogPostList) {
        if (blogPostList == null) {
            return new HashSet();
        }
        return BlogPostComparableItem.blogPostArrayToBlogPostComparableItemSet(blogPostList);
    }

    public List<AbstractPage> findDeletablePages(boolean copyBlogPosts, boolean copyPages) {
        ArrayList<AbstractPage> deleteablePagesList = new ArrayList<AbstractPage>();
        if (copyBlogPosts) {
            deleteablePagesList.addAll(this.findDeleteableBlogPosts());
        }
        if (copyPages) {
            deleteablePagesList.addAll(this.findDeleteablePages());
        }
        return deleteablePagesList;
    }

    private List findDeleteablePages() {
        Set pagesSet = this.findDeleteableAbstractPages(this.draftPageComparableItemSet, this.destinationPageComparableItemSet);
        ArrayList<Page> abstractPagesList = new ArrayList<Page>();
        for (PageComparableItem pageItem : pagesSet) {
            abstractPagesList.add(pageItem.getPage());
        }
        return abstractPagesList;
    }

    private List findDeleteableBlogPosts() {
        Set blogPostsSet = this.findDeleteableAbstractPages(this.draftBlogPostComparableItemSet, this.destinationBlogPostComparableItemSet);
        ArrayList<BlogPost> abstractPagesList = new ArrayList<BlogPost>();
        for (BlogPostComparableItem blogItem : blogPostsSet) {
            abstractPagesList.add(blogItem.getBlogPost());
        }
        return abstractPagesList;
    }

    private Set findDeleteableAbstractPages(Set targetAbstractPageSet, Set destinationAbstractPageSet) {
        HashSet targetSpace = new HashSet();
        targetSpace.addAll(targetAbstractPageSet);
        HashSet destinationSpace = new HashSet();
        destinationSpace.addAll(destinationAbstractPageSet);
        destinationSpace.removeAll(targetSpace);
        return destinationSpace;
    }

    private static class PageComparableItem {
        private Page page;

        public PageComparableItem(Page page) {
            this.page = page;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PageComparableItem)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            PageComparableItem rhs = (PageComparableItem)obj;
            return this.page.getTitle().equals(rhs.getPage().getTitle());
        }

        public int hashCode() {
            return new HashCodeBuilder(19, 37).append((Object)this.page.getTitle()).toHashCode();
        }

        public static Set pageArrayToPageComparableItemSet(List pagesList) {
            HashSet<PageComparableItem> pagesSet = new HashSet<PageComparableItem>();
            for (Page page : pagesList) {
                pagesSet.add(new PageComparableItem(page));
            }
            return pagesSet;
        }

        public Page getPage() {
            return this.page;
        }
    }

    private static class BlogPostComparableItem {
        private BlogPost blogPost;

        public BlogPostComparableItem(BlogPost blogPost) {
            this.blogPost = blogPost;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BlogPostComparableItem)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            BlogPostComparableItem rhs = (BlogPostComparableItem)obj;
            return this.blogPost.getTitle().equals(rhs.getBlogPost().getTitle()) && this.blogPost.getCreationDate().equals(rhs.getBlogPost().getCreationDate());
        }

        public int hashCode() {
            return new HashCodeBuilder(11, 81).append((Object)this.blogPost.getTitle()).append((Object)this.blogPost.getCreationDate()).toHashCode();
        }

        public static Set blogPostArrayToBlogPostComparableItemSet(List blogPostList) {
            HashSet<BlogPostComparableItem> blogPostSet = new HashSet<BlogPostComparableItem>();
            for (BlogPost blogPost : blogPostList) {
                blogPostSet.add(new BlogPostComparableItem(blogPost));
            }
            return blogPostSet;
        }

        public BlogPost getBlogPost() {
            return this.blogPost;
        }
    }
}

