/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.InputStreamAttachmentResource;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import com.comalatech.confluence.publishing.AbstractPageService;
import com.comalatech.confluence.publishing.DeletePagesFinder;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import com.comalatech.confluence.publishing.InternalPublishingManager;
import com.comalatech.confluence.publishing.LabelPublisher;
import com.comalatech.confluence.publishing.ManifestManager;
import com.comalatech.confluence.publishing.PagePublisher;
import com.comalatech.confluence.publishing.PublishingUserException;
import com.comalatech.confluence.publishing.SpacePublisher;
import com.comalatech.confluence.publishing.api.event.PageUpdatedPublishedEvent;
import com.comalatech.confluence.publishing.event.PageUpdatedPublishedEventImpl;
import com.comalatech.confluence.publishing.model.AbstractPageChange;
import com.comalatech.confluence.publishing.model.EntityChange;
import com.comalatech.confluence.publishing.model.EntityChangeSet;
import com.comalatech.confluence.publishing.model.PageChangeSet;
import com.comalatech.confluence.publishing.model.PublishManifest;
import com.comalatech.confluence.publishing.model.PublishingOption;
import com.comalatech.confluence.publishing.model.SpaceChangeSet;
import com.comalatech.confluence.publishing.utils.ValueException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultSpacePublisher
implements SpacePublisher,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultSpacePublisher.class);
    private final PageManager pageManager;
    private final ConfluenceIndexer indexer;
    private final ManifestManager manifestManager;
    private final LabelPublisher labelPublisher;
    private final SpaceManager spaceManager;
    private final AbstractPageService abstractPageService;
    private final InternalPublishingConfigurationManager publishingConfigurationManager;
    private final LabelManager labelManager;
    private final InternalPublishingManager publishingManager;
    private final AttachmentManager attachmentManager;
    private final FileUploadManager fileUploadManager;
    private final EventPublisher eventPublisher;
    private final PermissionManager permissionManager;
    private PagePublisher pagePublisher;
    private ApplicationContext context;
    private static final int MAX_PAGES_TO_DELETE = 10;

    public DefaultSpacePublisher(PageManager pageManager, ConfluenceIndexer indexer, ManifestManager manifestManager, LabelPublisher labelPublisher, SpaceManager spaceManager, AbstractPageService abstractPageService, InternalPublishingConfigurationManager publishingConfigurationManager, LabelManager labelManager, InternalPublishingManager publishingManager, AttachmentManager attachmentManager, FileUploadManager fileUploadManager, EventPublisher eventPublisher, PermissionManager permissionManager) {
        this.pageManager = pageManager;
        this.indexer = indexer;
        this.manifestManager = manifestManager;
        this.labelPublisher = labelPublisher;
        this.spaceManager = spaceManager;
        this.abstractPageService = abstractPageService;
        this.publishingConfigurationManager = publishingConfigurationManager;
        this.labelManager = labelManager;
        this.publishingManager = publishingManager;
        this.attachmentManager = attachmentManager;
        this.fileUploadManager = fileUploadManager;
        this.eventPublisher = eventPublisher;
        this.permissionManager = permissionManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.pagePublisher = (PagePublisher)this.context.getBean("pagePublisher", PagePublisher.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public SpaceChangeSet createSpaceChangeSet(Space sourceSpace, Space destinationSpace, ProgressMeter progress, int maxEntitiesInBatch, Map<PublishingOption, Boolean> spacePublishingOptions, Set<Long> copyManifest, Comparator<AbstractPage> pageComparator) throws ValueException {
        SpaceChangeSet spaceChangeSet = new SpaceChangeSet(sourceSpace.getKey(), destinationSpace.getKey(), maxEntitiesInBatch, spacePublishingOptions);
        ArrayList allSourceAbstractPages = new ArrayList();
        List<Object> allSourceBlogPosts = new ArrayList();
        if (spacePublishingOptions.get((Object)PublishingOption.PUBLISHBLOGPOSTS).booleanValue()) {
            allSourceBlogPosts = this.getPermissionCheckedBlogs(sourceSpace);
            allSourceAbstractPages.addAll(allSourceBlogPosts);
        }
        ArrayList<Page> allSourcePages = new ArrayList();
        if (spacePublishingOptions.get((Object)PublishingOption.PUBLISHPAGES).booleanValue()) {
            allSourcePages = this.getPermissionCheckedPages(sourceSpace);
            allSourceAbstractPages.addAll(allSourcePages);
        }
        if (pageComparator != null) {
            allSourceAbstractPages.sort(pageComparator);
        }
        progress.setStatus(String.format("{\"status\":\"%s\"}", ConfluenceActionSupport.getTextStatic((String)"publishing.space-publishing.progress.checkingdeletedpages", (Object[])new Object[]{destinationSpace.getName()})));
        this.checkPagesToDeleteOrOutOfSync(sourceSpace, destinationSpace, spaceChangeSet, allSourceBlogPosts, allSourcePages, spacePublishingOptions);
        progress.setStatus(String.format("{\"status\":\"%s\"}", ConfluenceActionSupport.getTextStatic((String)"publishing.space-publishing.progress.creatingchangeset")));
        ArrayList<AbstractPageChange> additions = new ArrayList<AbstractPageChange>();
        ArrayList<AbstractPageChange> updates = new ArrayList<AbstractPageChange>();
        ArrayList<AbstractPageChange> labelUpdates = new ArrayList<AbstractPageChange>();
        ArrayList<AbstractPageChange> restorationUpdates = new ArrayList<AbstractPageChange>();
        ArrayList<AbstractPageChange> propertiesUpdates = spacePublishingOptions.get((Object)PublishingOption.COPYPROPERTIES) != false ? new ArrayList<AbstractPageChange>() : null;
        ArrayList<AbstractPageChange> awpUnpublishable = spacePublishingOptions.get((Object)PublishingOption.PUBLISH_AWP_FINAL_STATE) != false ? new ArrayList<AbstractPageChange>() : null;
        ArrayList<AbstractPageChange> restrictionsUpdates = spacePublishingOptions.get((Object)PublishingOption.COPY_RESTRICTIONS) != false ? new ArrayList<AbstractPageChange>() : null;
        int count = 0;
        for (AbstractPage page : allSourceAbstractPages) {
            if (!(page instanceof BlogPost) && ((Page)page).getParent() != null) continue;
            count = this.createChangeSet(page, destinationSpace, additions, updates, labelUpdates, propertiesUpdates, restrictionsUpdates, awpUnpublishable, restorationUpdates, count, spacePublishingOptions, copyManifest);
        }
        if (spacePublishingOptions.get((Object)PublishingOption.PUBLISHBLOGPOSTS).booleanValue() || spacePublishingOptions.get((Object)PublishingOption.PUBLISHPAGES).booleanValue()) {
            spaceChangeSet.getPageAdditions().setChanges(additions);
            spaceChangeSet.getRestorationUpdates().setChanges(restorationUpdates);
            spaceChangeSet.getPageUpdates().setChanges(updates);
            if (spacePublishingOptions.get((Object)PublishingOption.COPYPROPERTIES).booleanValue()) {
                spaceChangeSet.getPropertiesUpdates().setChanges(propertiesUpdates);
            }
        }
        if (spacePublishingOptions.get((Object)PublishingOption.COPYLABELS).booleanValue()) {
            spaceChangeSet.getLabelUpdates().setChanges(labelUpdates);
        }
        if (spacePublishingOptions.get((Object)PublishingOption.COPY_RESTRICTIONS).booleanValue()) {
            spaceChangeSet.getRestrictionsUpdates().setChanges(restrictionsUpdates);
        }
        if (spacePublishingOptions.get((Object)PublishingOption.PUBLISH_AWP_FINAL_STATE).booleanValue()) {
            spaceChangeSet.getAwpNonPublishable().setChanges(awpUnpublishable);
        }
        return spaceChangeSet;
    }

    private void checkPagesToDeleteOrOutOfSync(Space sourceSpace, Space destinationSpace, SpaceChangeSet spaceChangeSet, List allSourceBlogPosts, List<Page> allSourcePages, Map<PublishingOption, Boolean> spacePublishingOptions) throws ValueException {
        List<AbstractPageChange> pagesAddedInDestination = this.getPagesToDeleteOrOutOfSync(sourceSpace, destinationSpace, allSourceBlogPosts, allSourcePages, spacePublishingOptions);
        if (spacePublishingOptions.get((Object)PublishingOption.DELETEINDESTINATION).booleanValue()) {
            spaceChangeSet.getPageDeletions().setChanges(pagesAddedInDestination);
        } else {
            spaceChangeSet.getOutOfSyncPages().setChanges(pagesAddedInDestination);
        }
    }

    @Override
    public List<AbstractPageChange> getPagesToDeleteOrOutOfSync(Space sourceSpace, Space destinationSpace, List allSourceBlogPosts, List<Page> allSourcePages, Map<PublishingOption, Boolean> spacePublishingOptions) throws ValueException {
        ArrayList<AbstractPageChange> pagesAddedInDestination = new ArrayList<AbstractPageChange>();
        int unsyncPages = 0;
        DeletePagesFinder deletePageFinder = new DeletePagesFinder(allSourceBlogPosts, allSourcePages, this.getPermissionCheckedBlogs(destinationSpace), this.getPermissionCheckedPages(destinationSpace));
        List<AbstractPage> deletablePages = deletePageFinder.findDeletablePages(spacePublishingOptions.get((Object)PublishingOption.PUBLISHBLOGPOSTS), spacePublishingOptions.get((Object)PublishingOption.PUBLISHPAGES));
        for (AbstractPage deletablePage : deletablePages) {
            PublishManifest manifest = this.manifestManager.getManifest((ContentEntityObject)deletablePage);
            if (manifest != null && this.pageManager.getAbstractPage(manifest.getSourceId()) != null && !this.pageManager.getAbstractPage(manifest.getSourceId()).isDeleted() && manifest.getSourceSpaceKey() != null && manifest.getSourceSpaceKey().equals(sourceSpace.getKey())) continue;
            pagesAddedInDestination.add(AbstractPageChange.create(deletablePage, deletablePage.getId(), 2, spacePublishingOptions, null));
            ++unsyncPages;
        }
        if (spacePublishingOptions.get((Object)PublishingOption.DELETEINDESTINATION).booleanValue() && unsyncPages > 10) {
            PublishingUserException publishingUserException = new PublishingUserException("publishing.space-publishing.error.too-different", destinationSpace.getName(), sourceSpace.getName());
            throw new ValueException(publishingUserException, pagesAddedInDestination);
        }
        return pagesAddedInDestination;
    }

    private Attachment getLogo(Space space) {
        return this.attachmentManager.getAttachment((ContentEntityObject)space.getDescription(), space.getKey());
    }

    @Override
    public boolean publish(SpaceChangeSet notTruncatedspaceChangeSet, ProgressMeter progress, Date publishDate, Set<Long> copyManifest) throws Exception {
        Page homePageSource;
        ArrayList<AbstractPage> changedPages = new ArrayList<AbstractPage>();
        boolean truncated = false;
        SpaceChangeSet spaceChangeSet = notTruncatedspaceChangeSet;
        if (spaceChangeSet.getNumberOfEntities() > notTruncatedspaceChangeSet.getMaxEntitiesInBatch()) {
            spaceChangeSet = notTruncatedspaceChangeSet.getBatchChangesSet();
            truncated = true;
        }
        int count = 0;
        count = this.publishPageChangeSet(spaceChangeSet, spaceChangeSet.getPageDeletions(), progress, count, "publishing.space-publishing.progress.deletingpages", changedPages, publishDate, copyManifest);
        count = this.publishPageChangeSet(spaceChangeSet, spaceChangeSet.getRestorationUpdates(), progress, count, "publishing.space-publishing.progress.restoringpages", changedPages, publishDate, copyManifest);
        count = this.publishPageChangeSet(spaceChangeSet, spaceChangeSet.getPageAdditions(), progress, count, "publishing.space-publishing.progress.addingnewpages", changedPages, publishDate, copyManifest);
        count = this.publishPageChangeSet(spaceChangeSet, spaceChangeSet.getPageUpdates(), progress, count, "publishing.space-publishing.progress.updatingpages", changedPages, publishDate, copyManifest);
        count = this.publishPageChangeSet(spaceChangeSet, spaceChangeSet.getLabelUpdates(), progress, count, "publishing.space-publishing.progress.updatinglabels", changedPages, publishDate, copyManifest);
        count = this.publishPageChangeSet(spaceChangeSet, spaceChangeSet.getRestrictionsUpdates(), progress, count, "publishing.space-publishing.progress.updatingrestrictions", changedPages, publishDate, copyManifest);
        this.publishPageChangeSet(spaceChangeSet, spaceChangeSet.getPropertiesUpdates(), progress, count, "publishing.space-publishing.progress.updatingproperties", changedPages, publishDate, copyManifest);
        this.publishPageUpdatedPublishingEvents(spaceChangeSet);
        Space sourceSpace = this.spaceManager.getSpace(spaceChangeSet.getSourceSpaceKey());
        Space destinationSpace = this.spaceManager.getSpace(spaceChangeSet.getDestinationSpaceKey());
        if (spaceChangeSet.isOption(PublishingOption.COPY_SPACE)) {
            this.labelPublisher.copyLabels((ContentEntityObject)sourceSpace.getDescription(), (ContentEntityObject)destinationSpace.getDescription(), spaceChangeSet.isOption(PublishingOption.EXACT_LABL_SYNC));
            if (log.isDebugEnabled()) {
                log.debug("AHP - copied space categories/labels");
            }
            this.copySpaceLogo(sourceSpace, destinationSpace);
        }
        if (spaceChangeSet.isOption(PublishingOption.PUBLISHBLOGPOSTS) || this.publishingConfigurationManager.isOption(sourceSpace, PublishingOption.PUBLISHPAGES)) {
            this.sortPages(spaceChangeSet);
        }
        if (spaceChangeSet.isOption(PublishingOption.DELETE_SYNC_LABL_ON_SOURCE)) {
            String synclabel = this.publishingConfigurationManager.getPublishingLabel();
            this.removeLabelFromAllEntries(synclabel, sourceSpace);
            if (log.isDebugEnabled()) {
                log.debug("AHP - removed sync label");
            }
        }
        if ((homePageSource = sourceSpace.getHomePage()) != null) {
            String homeTitleSource = homePageSource.getTitle();
            Page homePageDestination = this.pageManager.getPage(spaceChangeSet.getDestinationSpaceKey(), homeTitleSource);
            if (homePageDestination != null) {
                destinationSpace.setHomePage(homePageDestination);
            }
        }
        progress.setStatus(String.format("{\"status\":\"%s\"}", ConfluenceActionSupport.getTextStatic((String)"publishing.space-publishing.progress.reindexing")));
        for (AbstractPage page : changedPages) {
            this.indexer.reIndex((Searchable)page);
        }
        return !truncated;
    }

    private void copySpaceLogo(Space sourceSpace, Space destinationSpace) throws IOException {
        Attachment srcSpaceLogo = this.getLogo(sourceSpace);
        Attachment destSpaceLogo = this.getLogo(destinationSpace);
        if (srcSpaceLogo != null) {
            InputStreamAttachmentResource attachmentResource = new InputStreamAttachmentResource(this.attachmentManager.getAttachmentData(srcSpaceLogo), destinationSpace.getKey(), srcSpaceLogo.getMediaType(), srcSpaceLogo.getFileSize());
            this.fileUploadManager.storeResource((AttachmentResource)attachmentResource, (ContentEntityObject)destinationSpace.getDescription());
            if (log.isDebugEnabled()) {
                log.debug("AHP - copied space logo to " + destinationSpace.getKey());
            }
        } else if (destSpaceLogo != null) {
            this.attachmentManager.removeAttachmentFromServer(destSpaceLogo);
            if (log.isDebugEnabled()) {
                log.debug("AHP - removed space logo from " + destinationSpace.getKey());
            }
        }
    }

    private void removeLabelFromAllEntries(String label, Space space) {
        List pages = this.pageManager.getPages(space, true);
        this.removeLabel(label, pages);
        List blogposts = this.pageManager.getBlogPosts(space, true);
        this.removeLabel(label, blogposts);
    }

    private void removeLabel(String labelName, List<? extends AbstractPage> abstractPages) {
        for (AbstractPage abstractPage : abstractPages) {
            List labels = abstractPage.getLabels();
            if (labels == null) continue;
            for (Label label : labels) {
                if (label.getNamespace().equals((Object)Namespace.PERSONAL) || !label.getName().equals(labelName)) continue;
                this.labelManager.removeLabel((Labelable)abstractPage, label);
            }
        }
    }

    private void sortPages(SpaceChangeSet spaceChangeSet) {
        Space sourceSpace = this.spaceManager.getSpace(spaceChangeSet.getSourceSpaceKey());
        Space destinationSpace = this.spaceManager.getSpace(spaceChangeSet.getDestinationSpaceKey());
        List pages = this.pageManager.getTopLevelPages(sourceSpace);
        for (Page sourcePage : pages) {
            Page destPage = this.pageManager.getPage(destinationSpace.getKey(), sourcePage.getTitle());
            if (destPage == null) continue;
            this.sortChildren(sourcePage, destPage, destinationSpace);
        }
    }

    private void sortChildren(Page sourcePage, Page destPage, Space destinationSpace) {
        List sourceChildren = sourcePage.getSortedChildren();
        ArrayList<Page> destChildren = new ArrayList<Page>();
        ArrayList<Long> childIds = new ArrayList<Long>();
        for (Page sourceChild : sourceChildren) {
            Page destChild = this.pageManager.getPage(destinationSpace.getKey(), sourceChild.getTitle());
            if (destChild == null) continue;
            destChildren.add(destChild);
            childIds.add(destChild.getId());
            this.sortChildren(sourceChild, destChild, destinationSpace);
        }
        destPage.setChildren(destChildren);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Parent %s:%s set children %s with order %s", destPage.getTitle(), destPage.getId(), destChildren, childIds));
        }
        this.pageManager.setChildPageOrder(destPage, childIds);
    }

    private int publishPageChangeSet(SpaceChangeSet spaceChangeSet, EntityChangeSet changeSet, ProgressMeter progress, int count, String statusKey, List<AbstractPage> changedPages, Date publishDate, Set<Long> spaceCopyManifest) throws Exception {
        progress.setStatus(String.format("{\"status\":\"%s\"}", ConfluenceActionSupport.getTextStatic((String)statusKey)));
        List<EntityChange> changes = changeSet.getChanges();
        for (EntityChange change : changes) {
            ++count;
            AbstractPageChange pageChange = (AbstractPageChange)change;
            AbstractPage page = this.pagePublisher.publish(pageChange, spaceChangeSet.getSourceSpaceKey(), spaceChangeSet.getDestinationSpaceKey(), publishDate);
            if (change.isDelete() || page == null) continue;
            changedPages.add(page);
            if (!spaceChangeSet.isCopySpace()) continue;
            spaceCopyManifest.add(pageChange.getEntity(spaceChangeSet.getSourceSpaceKey()).getId());
        }
        return count;
    }

    private void publishPageUpdatedPublishingEvents(SpaceChangeSet spaceChangeSet) {
        LinkedList<EntityChange> updatesList = new LinkedList<EntityChange>(spaceChangeSet.getPageUpdates().getChanges());
        updatesList.addAll(spaceChangeSet.getLabelUpdates().getChanges());
        updatesList.addAll(spaceChangeSet.getRestrictionsUpdates().getChanges());
        updatesList.addAll(spaceChangeSet.getPropertiesUpdates().getChanges());
        HashMap<Long, PageUpdatedPublishedEventImpl> pageUpdatedEventsMap = new HashMap<Long, PageUpdatedPublishedEventImpl>();
        for (EntityChange change : updatesList) {
            AbstractPageChange pageChange = (AbstractPageChange)change;
            AbstractPage pageSource = (AbstractPage)pageChange.getEntity(spaceChangeSet.getSourceSpaceKey());
            if (pageUpdatedEventsMap.containsKey(pageSource.getId()) || !this.pagePublisher.isPageUpdatedEventReleasedWith(pageChange)) continue;
            AbstractPage destination = (AbstractPage)pageChange.getDestEntity();
            pageUpdatedEventsMap.put(pageSource.getId(), new PageUpdatedPublishedEventImpl(destination, pageSource, (User)AuthenticatedUserThreadLocal.get()));
        }
        for (PageUpdatedPublishedEvent anEvent : pageUpdatedEventsMap.values()) {
            this.eventPublisher.publish((Object)anEvent);
        }
    }

    private int createChangeSet(AbstractPage abstractPage, Space destinationSpace, List<AbstractPageChange> additions, List<AbstractPageChange> updates, List<AbstractPageChange> labelUpdates, List<AbstractPageChange> propertiesUpdates, List<AbstractPageChange> restrictionsUpdates, List<AbstractPageChange> awpUnpublishable, List<AbstractPageChange> restorationUpdates, int count, Map<PublishingOption, Boolean> spacePublishingOptions, Set<Long> spaceCopyManifest) {
        if (this.hasCorrectLabel(abstractPage, spacePublishingOptions)) {
            AbstractPage destinationPage = this.loadDestinationPage(destinationSpace.getKey(), abstractPage);
            PageChangeSet pageChangeSet = this.pagePublisher.createChangeSet(abstractPage, destinationPage, spacePublishingOptions);
            for (AbstractPageChange change : pageChangeSet.getPageChanges()) {
                if (change.isAdd()) {
                    additions.add(change);
                    ++count;
                    continue;
                }
                if (change.isUpdateLabels()) {
                    labelUpdates.add(change);
                    ++count;
                    continue;
                }
                if (change.isUpdateProperties() && propertiesUpdates != null) {
                    propertiesUpdates.add(change);
                    ++count;
                    continue;
                }
                if (change.isUpdateRestrictions() && restrictionsUpdates != null) {
                    restrictionsUpdates.add(change);
                    ++count;
                    continue;
                }
                if (change.isUnpublishableAWP() && awpUnpublishable != null) {
                    awpUnpublishable.add(change);
                    continue;
                }
                if (change.isUpdate() || change.isUpdateAttachments()) {
                    long pageId = change.getEntity(abstractPage.getSpaceKey()).getId();
                    if (spacePublishingOptions.get((Object)PublishingOption.COPY_SPACE).booleanValue() && spaceCopyManifest.contains(pageId)) continue;
                    updates.add(change);
                    ++count;
                    continue;
                }
                if (!change.isRestore()) continue;
                restorationUpdates.add(change);
                ++count;
            }
        }
        if (abstractPage instanceof Page) {
            Page page = (Page)abstractPage;
            for (Page child : page.getChildren()) {
                if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)child)) continue;
                count = this.createChangeSet((AbstractPage)child, destinationSpace, additions, updates, labelUpdates, propertiesUpdates, restrictionsUpdates, awpUnpublishable, restorationUpdates, count, spacePublishingOptions, spaceCopyManifest);
            }
        }
        return count;
    }

    @Override
    public boolean hasCorrectLabel(AbstractPage abstractPage, Map<PublishingOption, Boolean> spacePublishingOptions) {
        if (spacePublishingOptions.get((Object)PublishingOption.SYNC_LABEL_IGNORE).booleanValue()) {
            return true;
        }
        if (abstractPage instanceof BlogPost && spacePublishingOptions.get((Object)PublishingOption.SYNC_LABEL_IGNORE_ON_BLOGPOSTS).booleanValue()) {
            return true;
        }
        String labelName = this.publishingConfigurationManager.getPublishingLabel();
        if (labelName == null || labelName.trim().length() == 0) {
            return true;
        }
        boolean isExclusiveSyncLabel = spacePublishingOptions.get((Object)PublishingOption.EXCLUSIVE_SYNC_LABEL);
        List labels = abstractPage.getLabels();
        if (labels != null) {
            for (Label l : labels) {
                if (!l.getName().equals(labelName)) continue;
                return !isExclusiveSyncLabel;
            }
        }
        if (!isExclusiveSyncLabel && abstractPage instanceof Page && spacePublishingOptions.get((Object)PublishingOption.SYNC_LABEL_CASCADE_MODE_ENABLED).booleanValue()) {
            Page p = (Page)abstractPage;
            List ancestors = p.getAncestors();
            for (Page page : ancestors) {
                if (!this.hasCorrectLabel((AbstractPage)page, spacePublishingOptions)) continue;
                return true;
            }
        }
        return isExclusiveSyncLabel;
    }

    public AbstractPage loadDestinationPage(String destinationSpace, AbstractPage source) {
        long publishedPageId = this.publishingManager.getPublishedPageId(source, destinationSpace);
        if (publishedPageId != 0L) {
            return this.pageManager.getAbstractPage(publishedPageId);
        }
        return this.abstractPageService.loadByTypeAndSpace(source, destinationSpace);
    }

    @Override
    public List<Page> getPermissionCheckedPages(Space space) {
        ArrayList<Page> permissionCheckedPages = new ArrayList<Page>();
        for (Page page : this.pageManager.getPages(space, true)) {
            if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)page)) continue;
            permissionCheckedPages.add(page);
        }
        return permissionCheckedPages;
    }

    @Override
    public List<BlogPost> getPermissionCheckedBlogs(Space space) {
        ArrayList<BlogPost> permissionCheckedBlogPosts = new ArrayList<BlogPost>();
        for (BlogPost blog : this.pageManager.getBlogPosts(space, true)) {
            if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)blog)) continue;
            permissionCheckedBlogPosts.add(blog);
        }
        return permissionCheckedBlogPosts;
    }
}

