/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import com.comalatech.confluence.publishing.PublishingException;
import com.comalatech.confluence.publishing.PublishingUserException;
import com.comalatech.confluence.publishing.api.PublishingConfigurationManager;
import com.comalatech.confluence.publishing.api.model.PublishingSpaceConfiguration;
import com.comalatech.confluence.publishing.model.PublishingOption;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultPublishingConfigurationManager
implements InternalPublishingConfigurationManager,
PublishingConfigurationManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultPublishingConfigurationManager.class);
    private static final int DEFAULT_MAX_BATCH_SIZE = 300;
    private static final int DEFAULT_MAXCOPYBATCHSIZE = 300;
    private static final int MAX_PAGE_CHANGES_WARNING = 1000;
    public static final String PREFIXES_KEY = "com.comalatech.config.content.prefixes";
    public static final String PUBLISHERS_GROUP = "com.comalatech.config.publishing.usergroup";
    public static final String COPIERS_GROUP = "com.comalatech.config.copiers.usergroup";
    public static final String PUBLISHING_SPACES = "com.comalatech.config.publishing.spaces";
    public static final String PUBLISHING_LABEL = "com.comalatech.config.publishing.label";
    public static final String PUBLISHING_PUBLIC_SPACE = "com.comalatech.space-config.publishing.destination";
    public static final String PUBLISHING_SOURCE_SPACE = "com.comalatech.space-config.publishing.source";
    public static final String PUBLISHING_MAX_BATCH_SIZE = "com.comalatech.space-config.publishing.batch-size";
    public static final String PUBLISHING_SINGLE_PAGE = "com.comalatech.space-config.publishing.single-page";
    public static final String PUBLISHING_DRAFT_WATERMARK = "com.comalatech.space-config.publishing.draftwatermark";
    public static final String PUBLISHING_LOZENGE_DISPLAY = "com.comalatech.space-config.publishing.lozengedisplay";
    private static final String DEFAULT_PUBLISHERS_GROUP = "confluence-administrators";
    protected static final String[] DEFAULT_PREFIXES = new String[]{"metadata", "com.communardo"};
    private final BandanaManager bandanaManager;
    private final ConfluenceBandanaContext globalBandanaContext;
    private final GroupManager groupManager;
    private final SpaceManager spaceManager;
    private final PluginAccessor pluginAccessor;
    private String[] cachedPrefixes;

    public DefaultPublishingConfigurationManager(BandanaManager bandanaManager, GroupManager groupManager, SpaceManager spaceManager, PluginAccessor pluginAccessor) {
        this.bandanaManager = bandanaManager;
        this.globalBandanaContext = new ConfluenceBandanaContext();
        this.groupManager = groupManager;
        this.spaceManager = spaceManager;
        this.pluginAccessor = pluginAccessor;
        this.cachedPrefixes = this.getPropertiesPrefixes();
    }

    public void linkSpacesToPublish(String sourceSpaceKey, String destinationSpaceKey, PublishingSpaceConfiguration psc) throws Exception {
        if (sourceSpaceKey.equals(destinationSpaceKey)) {
            throw new PublishingUserException("publishing.space.same");
        }
        Space publicSpace = this.spaceManager.getSpace(destinationSpaceKey);
        String publicSpaceSourceKey = this.getSourceSpaceKey(publicSpace);
        if (publicSpace == null || publicSpaceSourceKey != null && !publicSpaceSourceKey.equals(sourceSpaceKey)) {
            throw new PublishingUserException("publishing.space.invalid", destinationSpaceKey);
        }
        Space sourceSpace = this.spaceManager.getSpace(sourceSpaceKey);
        this.setPublicSpace(sourceSpace, publicSpace);
        this.setOption(sourceSpace, PublishingOption.COPYPROPERTIES, psc.copyPropertiesOpt);
        this.setOption(sourceSpace, PublishingOption.COPYLABELS, psc.copyLabelsOpt);
        this.setOption(sourceSpace, PublishingOption.PUBLISHPAGES, psc.copyPagesOpt);
        this.setOption(sourceSpace, PublishingOption.PUBLISHBLOGPOSTS, psc.copyBlogPostsOpt);
        this.setOption(sourceSpace, PublishingOption.COPYSCAFFOLDDATA, psc.copyScaffoldDataOpt);
        this.setOption(sourceSpace, PublishingOption.COPYVERSIONCOMMENTS, psc.copyVersionUpdateCommentsOpt);
        this.setOption(sourceSpace, PublishingOption.DELETEINDESTINATION, psc.deleteTargetPagesOpt);
        this.setOption(sourceSpace, PublishingOption.IGNORE_MANIFEST, psc.ignoreManifestOpt);
        this.setOption(sourceSpace, PublishingOption.IGNORE_TOPLEVELPAGES, psc.ignoreTopLevelOpt);
        this.setOption(sourceSpace, PublishingOption.OVERRIDE_CONTENT, psc.overrideContentOpt);
        this.setOption(sourceSpace, PublishingOption.SYNC_LABEL_IGNORE, psc.ignoreSyncLabelOpt);
        this.setOption(sourceSpace, PublishingOption.SYNC_LABEL_CASCADE_MODE_ENABLED, psc.includeChildPagesOpt);
        this.setOption(sourceSpace, PublishingOption.SYNC_LABEL_IGNORE_ON_BLOGPOSTS, psc.copyBlogIgnoreSyncLabelOpt);
        this.setOption(sourceSpace, PublishingOption.DELETE_SYNC_LABL_ON_SOURCE, psc.removeSourceSyncLabelOpt);
        this.setOption(sourceSpace, PublishingOption.EXCLUSIVE_SYNC_LABEL, psc.onlySyncPagesWithNoSyncLabelOpt);
        this.setOption(sourceSpace, PublishingOption.EXACT_LABL_SYNC, psc.replaceLabelsExactlyOpt);
        this.setSinglePagePublishing(sourceSpace, psc.singlePagePublishingOpt);
        this.setOption(sourceSpace, PublishingOption.PUBLISH_AWP_FINAL_STATE, psc.copyWorkflowsFinalStateVersionOpt);
        this.setDraftWatermark(sourceSpace, psc.draftWatermarkOpt);
        this.setDisplayPublishingLozenge(sourceSpace, psc.displayStatusLozengeOpt);
        this.setOption(sourceSpace, PublishingOption.USE_PUBLISHING_DATE, psc.replaceModDateWithPubDateOption);
        this.setOption(sourceSpace, PublishingOption.COPY_RESTRICTIONS, psc.copyPageRestrictionsOpt);
        this.setMaxBatchSize(sourceSpace, this.getMaxBatchSize(sourceSpace));
    }

    @Override
    public void setPublicSpace(Space source, Space publicSpace) throws PublishingException {
        Space oldPublicSpace;
        String oldPublicSpaceKey = this.getPublicSpaceKey(source);
        if (oldPublicSpaceKey != null && (oldPublicSpace = this.spaceManager.getSpace(oldPublicSpaceKey)) != null) {
            this.setSourceSpaceKey(oldPublicSpace, null);
        }
        if (publicSpace != null) {
            this.setPublicSpaceKey(source, publicSpace.getKey());
            this.setSourceSpaceKey(publicSpace, source.getKey());
            this.removePublishingLoop(source, publicSpace);
        } else {
            this.setPublicSpaceKey(source, null);
        }
    }

    private void removePublishingLoop(Space source, Space publicSpace) throws PublishingUserException {
        String publicSpaceKey = publicSpace.getKey();
        Space currentSource = source;
        while (publicSpaceKey != null) {
            Space pubSpace = this.spaceManager.getSpace(publicSpaceKey);
            if (pubSpace == null) {
                log.warn("invalid space key " + publicSpaceKey + " will be removed as public space of " + currentSource.getKey());
                this.setPublicSpaceKey(currentSource, null);
            } else if (pubSpace.getKey().equals(source.getKey())) {
                log.warn("removing circular publishing loop back to source space");
                this.setPublicSpaceKey(currentSource, null);
            } else if (currentSource.getKey().equals(publicSpaceKey)) {
                log.warn("space cannot publish to itself");
                this.setPublicSpaceKey(currentSource, null);
            }
            currentSource = pubSpace;
            publicSpaceKey = this.getPublicSpaceKey(currentSource);
        }
    }

    @Override
    public String getPublishersGroup() {
        return this.getGroup(PUBLISHERS_GROUP);
    }

    private String getGroup(String key) {
        String group = this.getValue((BandanaContext)this.globalBandanaContext, key);
        if (!TextUtils.stringSet((String)group)) {
            group = DEFAULT_PUBLISHERS_GROUP;
        }
        return group;
    }

    @Override
    public String getCopiersGroup() {
        return this.getGroup(COPIERS_GROUP);
    }

    @Override
    public String getAllowedGroupName(boolean copy) {
        if (copy) {
            return this.getCopiersGroup();
        }
        return this.getPublishersGroup();
    }

    @Override
    public void setPublishersGroup(String group) throws PublishingException {
        this.setGroup(group, PUBLISHERS_GROUP);
    }

    private void setGroup(String group, String key) throws PublishingUserException {
        try {
            if (this.groupManager.getGroup(group) == null) {
                throw new PublishingUserException("publishing.config.invalid-group", group);
            }
        }
        catch (EntityException e) {
            log.error("error", (Throwable)e);
            throw new PublishingUserException("publishing.config.invalid-group", group);
        }
        this.setValue((BandanaContext)this.globalBandanaContext, key, group);
    }

    @Override
    public void setCopiersGroup(String group) throws PublishingException {
        this.setGroup(group, COPIERS_GROUP);
    }

    @Override
    public String[] getPublishingSpaces() {
        String[] values = this.getCommaSeparatedValues(PUBLISHING_SPACES, "ANY");
        return values;
    }

    @Override
    public String getPublishingSpacesAsString() {
        Object[] spaces = this.getPublishingSpaces();
        return StringUtils.arrayToCommaDelimitedString((Object[])spaces);
    }

    @Override
    public boolean isPublishAnySpace() {
        return this.getPublishingSpacesAsString().equalsIgnoreCase("any");
    }

    @Override
    public void setPublishingSpaces(String commaSeparatedSpaces) throws PublishingUserException {
        if (!TextUtils.stringSet((String)commaSeparatedSpaces)) {
            this.setValue((BandanaContext)this.globalBandanaContext, PUBLISHING_SPACES, "");
            return;
        }
        String[] spaces = this.toStringArray(commaSeparatedSpaces);
        ArrayList matchingSpacekeys = Lists.newArrayList();
        for (int i = 0; i < spaces.length; ++i) {
            String space = spaces[i];
            if (space.equalsIgnoreCase("any")) {
                commaSeparatedSpaces = "ANY";
                matchingSpacekeys.add(space);
                break;
            }
            if (this.spaceManager.getSpace(space) == null) {
                throw new PublishingUserException("publishing.config.invalid-space", space);
            }
            matchingSpacekeys.add(this.spaceManager.getSpace(space).getKey());
        }
        this.setCommaSeparatedValues(PUBLISHING_SPACES, Joiner.on((String)",").join((Iterable)matchingSpacekeys));
    }

    @Override
    public String[] getPropertiesPrefixes() {
        if (this.cachedPrefixes != null && this.cachedPrefixes.length != 0) {
            return this.cachedPrefixes;
        }
        String[] prefixes = this.getCommaSeparatedValues(PREFIXES_KEY, null);
        if (prefixes.length == 0) {
            return DEFAULT_PREFIXES;
        }
        return prefixes;
    }

    @Override
    public String getPropertiesPrefixesAsString() {
        Object[] prefixes = this.getPropertiesPrefixes();
        return StringUtils.arrayToCommaDelimitedString((Object[])prefixes);
    }

    @Override
    public void setPropertiesPrefixes(String commaSeparatedPrefixes) {
        this.setCommaSeparatedValues(PREFIXES_KEY, commaSeparatedPrefixes);
        this.cachedPrefixes = this.toStringArray(commaSeparatedPrefixes);
    }

    @Override
    public String getPublicSpaceKey(Space space) {
        return this.getValue(space, PUBLISHING_PUBLIC_SPACE);
    }

    @Override
    public void setPublicSpaceKey(Space space, String spaceKey) throws PublishingUserException {
        this.setSpaceKey(space, PUBLISHING_PUBLIC_SPACE, spaceKey);
    }

    @Override
    public String getSourceSpaceKey(Space space) {
        return this.getValue(space, PUBLISHING_SOURCE_SPACE);
    }

    @Override
    public void setSourceSpaceKey(Space space, String spaceKey) throws PublishingUserException {
        this.setSpaceKey(space, PUBLISHING_SOURCE_SPACE, spaceKey);
    }

    private void setSpaceKey(Space space, String key, String spaceKey) throws PublishingUserException {
        if (spaceKey == null) {
            this.setValue(space, key, null);
            return;
        }
        if (this.spaceManager.getSpace(spaceKey) == null) {
            throw new PublishingUserException("publishing.config.invalid-space", spaceKey);
        }
        this.setValue(space, key, spaceKey);
    }

    @Override
    public boolean isOption(Space space, PublishingOption option) {
        return this.getFlag(space, option.getKeyName(), option.isChecked());
    }

    @Override
    public void setOption(Space space, PublishingOption option, boolean value) {
        this.setFlag(space, option.getKeyName(), value);
    }

    @Override
    public boolean isSinglePagePublishing(Space space) {
        Object rawObject = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(space), PUBLISHING_SINGLE_PAGE);
        if (rawObject == null) {
            return this.getPublicSpaceKey(space) == null;
        }
        return (Boolean)rawObject;
    }

    @Override
    public void setSinglePagePublishing(Space space, boolean enabled) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(space), PUBLISHING_SINGLE_PAGE, (Object)enabled);
    }

    @Override
    public boolean isDraftWatermark(Space space) {
        Object rawObject = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(space), PUBLISHING_DRAFT_WATERMARK);
        if (rawObject == null) {
            return true;
        }
        return (Boolean)rawObject;
    }

    @Override
    public void setDraftWatermark(Space space, boolean enabled) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(space), PUBLISHING_DRAFT_WATERMARK, (Object)enabled);
    }

    @Override
    public Map<PublishingOption, Boolean> getSpacePublishingOptions(Space space) {
        HashMap<PublishingOption, Boolean> spacePublishingOptions = new HashMap<PublishingOption, Boolean>();
        for (PublishingOption option : PublishingOption.values()) {
            spacePublishingOptions.put(option, this.isOption(space, option));
        }
        return spacePublishingOptions;
    }

    @Override
    public boolean isDisplayPublishingLozenge(Space space) {
        Object rawObject = this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(space), PUBLISHING_LOZENGE_DISPLAY);
        if (rawObject == null) {
            return true;
        }
        return (Boolean)rawObject;
    }

    @Override
    public void setDisplayPublishingLozenge(Space space, boolean enabled) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(space), PUBLISHING_LOZENGE_DISPLAY, (Object)enabled);
    }

    @Override
    public int getMaxCopyBatchSize(Space space) {
        return 300;
    }

    @Override
    public int getMaxBatchSize(Space space) {
        int max = NumberUtils.toInt((String)this.getValue(space, PUBLISHING_MAX_BATCH_SIZE));
        if (max == 0) {
            max = 300;
        }
        return max;
    }

    @Override
    public boolean isLargeAmountOfPageUpdates(int numberOfEntityChanges) {
        return numberOfEntityChanges >= 1000;
    }

    @Override
    public void setMaxBatchSize(Space space, int size) {
        if (size > 0) {
            this.setValue(space, PUBLISHING_MAX_BATCH_SIZE, Integer.toString(size));
        }
    }

    @Override
    public Space getPublicSpace(Space space) {
        String spaceKey = this.getPublicSpaceKey(space);
        if (!TextUtils.stringSet((String)spaceKey)) {
            return null;
        }
        return this.spaceManager.getSpace(spaceKey);
    }

    @Override
    public Space getSourceSpace(Space space) {
        String spaceKey = this.getSourceSpaceKey(space);
        if (!TextUtils.stringSet((String)spaceKey)) {
            return null;
        }
        return this.spaceManager.getSpace(spaceKey);
    }

    private boolean getFlag(Space space, String key, boolean defaultValue) {
        return this.getFlag((BandanaContext)new ConfluenceBandanaContext(space), key, defaultValue);
    }

    private void setFlag(Space space, String key, boolean value) {
        this.setFlag((BandanaContext)new ConfluenceBandanaContext(space), key, value);
    }

    private boolean getFlag(BandanaContext context, String key, boolean defaultValue) {
        String value = this.getValue(context, key);
        if (!TextUtils.stringSet((String)value)) {
            return defaultValue;
        }
        return value.equals(Boolean.TRUE.toString());
    }

    private void setFlag(BandanaContext context, String key, boolean value) {
        String strvalue = value ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        this.setValue(context, key, strvalue);
    }

    private String[] getCommaSeparatedValues(String key, String defaultValue) {
        String rawValues = this.getValue((BandanaContext)this.globalBandanaContext, key, defaultValue);
        if (!TextUtils.stringSet((String)rawValues)) {
            return new String[0];
        }
        return this.toStringArray(rawValues);
    }

    private String[] toStringArray(String rawValues) {
        return rawValues.replaceAll("\\p{Space}", "").trim().split(",");
    }

    private void setCommaSeparatedValues(String key, String strValues) {
        Object[] values = this.toStringArray(strValues);
        Arrays.sort(values);
        strValues = StringUtils.arrayToCommaDelimitedString((Object[])values);
        this.setValue((BandanaContext)this.globalBandanaContext, key, strValues);
    }

    private String getValue(Space space, String key) {
        return this.getValue((BandanaContext)new ConfluenceBandanaContext(space), key);
    }

    private void setValue(Space space, String key, String value) {
        this.setValue((BandanaContext)new ConfluenceBandanaContext(space), key, value);
    }

    private String getValue(BandanaContext context, String key) {
        return this.getValue(context, key, null);
    }

    private String getValue(BandanaContext context, String key, String defaultValue) {
        Object object = this.bandanaManager.getValue(context, key);
        if (object == null && TextUtils.stringSet((String)defaultValue)) {
            return defaultValue;
        }
        return (String)object;
    }

    private void setValue(BandanaContext context, String key, String strValues) {
        this.bandanaManager.setValue(context, key, (Object)strValues);
    }

    @Override
    public void setPublishingLabel(String label) {
        this.setValue((BandanaContext)this.globalBandanaContext, PUBLISHING_LABEL, label);
    }

    @Override
    public String getPublishingLabel() {
        String value = this.getValue((BandanaContext)this.globalBandanaContext, PUBLISHING_LABEL);
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public boolean isScaffoldingAppAvailable() {
        return this.isAppDetected("net.customware.confluence.plugin.scaffolding");
    }

    @Override
    public boolean isComalaDocumentManagementAppAvailable() {
        return this.isAppDetected("com.comalatech.workflow");
    }

    private boolean isAppDetected(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        return plugin != null && plugin.getPluginState().equals((Object)PluginState.ENABLED);
    }
}

