/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing;

import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.core.ConfluencePropertySetManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import com.comalatech.confluence.publishing.PropertiesPublisher;
import com.comalatech.confluence.publishing.utils.JsonContentPropertyHelper;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertiesPublisher
implements PropertiesPublisher {
    private static final Logger log = LoggerFactory.getLogger(DefaultPropertiesPublisher.class);
    private final JsonContentPropertyHelper jsonContentPropertyHelper;
    private final InternalPublishingConfigurationManager publishingConfigurationManager;
    private final ContentPropertyManager contentPropertyManager;
    private final ConfluencePropertySetManager propertySetManager;
    private final PermissionManager permissionManager;

    public DefaultPropertiesPublisher(JsonContentPropertyHelper jsonContentPropertyHelper, InternalPublishingConfigurationManager publishingConfigurationManager, ContentPropertyManager contentPropertyManager, ConfluencePropertySetManager propertySetManager, PermissionManager permissionManager) {
        this.jsonContentPropertyHelper = jsonContentPropertyHelper;
        this.publishingConfigurationManager = publishingConfigurationManager;
        this.contentPropertyManager = contentPropertyManager;
        this.propertySetManager = propertySetManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public void copyProperties(ContentEntityObject source, ContentEntityObject destination) {
        this.copyContentProperties(source, destination);
        this.copyJsonContentProperties(source, destination);
    }

    @Override
    public boolean arePropertiesCopied(ContentEntityObject source, ContentEntityObject destination) {
        if (destination.isCurrent()) {
            boolean contentPropertiesCopied = this.areContentPropertiesCopied(source, destination);
            boolean jsonContentPropertiesCopied = this.areJsonContentPropertiesCopied(source, destination);
            return contentPropertiesCopied && jsonContentPropertiesCopied;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyJsonContentProperties(ContentEntityObject source, ContentEntityObject target) {
        ConfluenceUser previousUser;
        ConfluenceUser user = previousUser = AuthenticatedUserThreadLocal.get();
        if (log.isDebugEnabled()) {
            log.debug("copyJsonContentProperties replacing json content properties of " + target.getTitle() + "(" + target.getId() + "), with properties from  " + source.getTitle() + "(" + source.getId() + "), prefixes: " + Arrays.toString(this.getPropertiesPrefixes()));
        }
        try {
            if (user == null) {
                log.info("Current user Null, Impersonating to last modifier {} of the target {}", (Object)target.getLastModifier(), (Object)target.getId());
                user = target.getLastModifier();
                AuthenticatedUserThreadLocal.set((ConfluenceUser)target.getLastModifier());
            }
            if (this.isPageAccessible(target) && this.hasUserEditPermissionsOverContent(user, target)) {
                Map<String, JsonContentProperty> sourceProperties = this.getJsonContentProperties(source);
                this.jsonContentPropertyHelper.copyJsonPropertiesToTarget(sourceProperties, target);
            } else {
                log.warn("Not possible to copy JSON properties on {}", (Object)target.getId());
            }
        }
        finally {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)previousUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean areJsonContentPropertiesCopied(ContentEntityObject source, ContentEntityObject target) {
        ConfluenceUser previousUser;
        ConfluenceUser user = previousUser = AuthenticatedUserThreadLocal.get();
        try {
            boolean isTargetPageAvailable;
            if (previousUser == null) {
                log.info("Current user Null, Impersonating to last modifier {} of the target {}", (Object)target.getLastModifier(), (Object)target.getId());
                user = target.getLastModifier();
                AuthenticatedUserThreadLocal.set((ConfluenceUser)target.getLastModifier());
            }
            boolean isSourcePageAvailable = this.isPageAccessible(source) && this.hasUserViewPermissionsOverContent(user, source);
            boolean bl = isTargetPageAvailable = this.isPageAccessible(target) && this.hasUserViewPermissionsOverContent(user, target);
            if (!isTargetPageAvailable || !isSourcePageAvailable) {
                log.error("JSON Properties of source('{}' / deleted:{} / current:{} / available:{}) or destination('{}' / deleted:{} / current:{} / available:{}) pages are not accessible by current user ('{}') for lack of permissions or because they are deleted.", new Object[]{source.getId(), source.isDeleted(), source.isCurrent(), isSourcePageAvailable, target.getId(), target.isDeleted(), target.isCurrent(), isTargetPageAvailable, AuthenticatedUserThreadLocal.getUsername()});
                boolean bl2 = true;
                return bl2;
            }
            Map<String, JsonContentProperty> sourceProperties = this.getJsonContentProperties(source);
            Map<String, JsonContentProperty> destinationProperties = this.getJsonContentProperties(target);
            if (log.isDebugEnabled()) {
                log.debug("arePropertiesCopied (source/destination):" + sourceProperties.size() + "/" + destinationProperties.size() + ", prefixes: " + Arrays.toString(this.getPropertiesPrefixes()));
            }
            if (!sourceProperties.keySet().equals(destinationProperties.keySet())) {
                boolean bl3 = false;
                return bl3;
            }
            for (Map.Entry<String, JsonContentProperty> propertyEntry : sourceProperties.entrySet()) {
                JsonContentProperty property = propertyEntry.getValue();
                JsonString destPropValue = destinationProperties.get(property.getKey()).getValue();
                if (property.getValue().equals((Object)destPropValue)) continue;
                boolean bl4 = false;
                return bl4;
            }
            boolean bl5 = true;
            return bl5;
        }
        finally {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)previousUser);
        }
    }

    private void copyContentProperties(ContentEntityObject source, ContentEntityObject destination) {
        PropertySet propertySet = this.propertySetManager.getPropertySet((Object)source);
        for (Object o : propertySet.getKeys()) {
            String key = (String)o;
            if (!this.matchesPrefix(key)) continue;
            int type = propertySet.getType(key);
            if (type == 5) {
                if (log.isDebugEnabled()) {
                    log.debug("Property Set Manager of type STRING copy");
                }
                this.contentPropertyManager.setStringProperty(destination, key, propertySet.getString(key));
                continue;
            }
            if (type == 6) {
                if (log.isDebugEnabled()) {
                    log.debug("Property Set Manager of type TEXT copy");
                }
                this.contentPropertyManager.setTextProperty(destination, key, propertySet.getText(key));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Property Set Manager cannot copy this type: " + type);
        }
    }

    private boolean areContentPropertiesCopied(ContentEntityObject source, ContentEntityObject destination) {
        PropertySet sourcePropertySet = this.propertySetManager.getPropertySet((Object)source);
        PropertySet destPropertySet = this.propertySetManager.getPropertySet((Object)destination);
        for (String key : sourcePropertySet.getKeys()) {
            boolean isNullValueDestination;
            if (!this.matchesPrefix(key)) continue;
            if (!destPropertySet.exists(key)) {
                return false;
            }
            int sourceType = sourcePropertySet.getType(key);
            int destinationType = destPropertySet.getType(key);
            if (sourceType == 5 && destinationType == 5) {
                boolean isDifferentValue = Objects.nonNull(sourcePropertySet.getString(key)) && !sourcePropertySet.getString(key).equals(destPropertySet.getString(key));
                boolean isNullValueSource = Objects.isNull(sourcePropertySet.getString(key)) && Objects.nonNull(destPropertySet.getString(key));
                boolean bl = isNullValueDestination = Objects.isNull(destPropertySet.getString(key)) && Objects.nonNull(sourcePropertySet.getString(key));
                if (!isDifferentValue && !isNullValueSource && !isNullValueDestination) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Property Set Manager of type STRING:'" + key + "' don't match in sourceId/destinationId " + source.getContentId() + "/" + destination.getContentId());
                }
                return false;
            }
            if (sourceType == 6 && destinationType == 6) {
                boolean isDifferentValue = Objects.nonNull(sourcePropertySet.getText(key)) && !sourcePropertySet.getText(key).equals(destPropertySet.getText(key));
                boolean isNullValueSource = Objects.isNull(sourcePropertySet.getText(key)) && Objects.nonNull(destPropertySet.getText(key));
                boolean bl = isNullValueDestination = Objects.isNull(destPropertySet.getText(key)) && Objects.nonNull(sourcePropertySet.getText(key));
                if (!isDifferentValue && !isNullValueSource && !isNullValueDestination) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Property Set Manager of type TEXT:'" + key + "' don't match in sourceId/destinationId " + source.getContentId() + "/" + destination.getContentId());
                }
                return false;
            }
            if (sourceType != destinationType && (sourceType == 5 || sourceType == 6)) {
                String sourceValue = sourceType == 6 ? sourcePropertySet.getText(key) : sourcePropertySet.getString(key);
                String destinationValue = null;
                if (destinationType == 6) {
                    destinationValue = destPropertySet.getText(key);
                } else if (destinationType == 5) {
                    destinationValue = destPropertySet.getString(key);
                }
                if ((sourceValue == null || sourceValue.equals(destinationValue)) && (sourceValue != null || destinationValue == null)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Source Property Set Manager of type " + sourceType + ":'" + key + "' and Destination Property Set Manager of type " + destinationType + " don't match in sourceId/destinationId " + source.getContentId() + "/" + destination.getContentId() + ", values: " + sourceValue + "/" + destinationValue);
                }
                return false;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Property Set Manager cannot check properties of this type: " + sourceType);
        }
        return true;
    }

    private Map<String, JsonContentProperty> getJsonContentProperties(ContentEntityObject ceo) {
        if (log.isDebugEnabled()) {
            log.debug("getJsonContentProperties for " + ceo.getTitle() + "(" + ceo.getId() + "), prefixes:" + Arrays.toString(this.getPropertiesPrefixes()));
        }
        List<JsonContentProperty> results = this.jsonContentPropertyHelper.getListOfJsonContentProperties(ceo);
        HashMap<String, JsonContentProperty> filteredResults = new HashMap<String, JsonContentProperty>();
        for (JsonContentProperty property : results) {
            if (!this.matchesPrefix(property.getKey())) continue;
            filteredResults.put(property.getKey(), property);
        }
        return filteredResults;
    }

    private boolean matchesPrefix(String key) {
        for (String prefix : this.getPropertiesPrefixes()) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isPageAccessible(ContentEntityObject content) {
        if (content.isDeleted()) {
            log.error("page not available (page is deleted: {})", (Object)content.getId());
            return false;
        }
        return true;
    }

    private boolean userHasPermission(ConfluenceUser user, ContentEntityObject content, Permission permission) {
        if (user == null) {
            return false;
        }
        boolean hasPermission = this.permissionManager.hasPermission((User)user, permission, (Object)content);
        if (!hasPermission) {
            log.error("No permissions {} in page '{}'({}) for user '{}'", new Object[]{permission, content.getTitle(), content.getId(), user.getName()});
            return false;
        }
        return true;
    }

    private boolean hasUserEditPermissionsOverContent(ConfluenceUser user, ContentEntityObject content) {
        return this.userHasPermission(user, content, Permission.EDIT);
    }

    private boolean hasUserViewPermissionsOverContent(ConfluenceUser user, ContentEntityObject content) {
        return this.userHasPermission(user, content, Permission.VIEW);
    }

    private String[] getPropertiesPrefixes() {
        return this.publishingConfigurationManager.getPropertiesPrefixes();
    }
}

