/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.publishing.AbstractPageService;
import java.util.Calendar;
import java.util.Date;

public class AbstractPageServiceImpl
implements AbstractPageService {
    private final PageManager pageManager;

    public AbstractPageServiceImpl(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    @Override
    public boolean isPage(AbstractPage page) {
        return page != null && page instanceof Page;
    }

    @Override
    public boolean isBlogPost(AbstractPage page) {
        return page != null && page instanceof BlogPost;
    }

    @Override
    public AbstractPage createNewInstanceOf(AbstractPage abstractPage) {
        if (this.isPage(abstractPage)) {
            return new Page();
        }
        return new BlogPost();
    }

    @Override
    public AbstractPage loadByTypeAndSpace(AbstractPage source, String spaceKey) {
        if (this.isPage(source)) {
            return this.pageManager.getPage(spaceKey, source.getTitle());
        }
        return this.loadBlogPostBySpaceKeyAndTitleAndCreationDate(spaceKey, source.getTitle(), source.getCreationDate());
    }

    @Override
    public AbstractPage loadById(long destinationPageId) {
        return this.pageManager.getAbstractPage(destinationPageId);
    }

    @Override
    public BlogPost loadBlogPostBySpaceKeyAndTitleAndCreationDate(String spaceKey, String title, Date creationDate) {
        Calendar creationDateAsCalendar = this.getCreateDateAsCalendar(creationDate);
        return this.pageManager.getBlogPost(spaceKey, title, creationDateAsCalendar);
    }

    private Calendar getCreateDateAsCalendar(Date creationDate) {
        Calendar creationDateCalendar = Calendar.getInstance();
        creationDateCalendar.setTime(creationDate);
        return creationDateCalendar;
    }
}

