/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.S z";
    static final String DATE_FORMAT_NOTIMEZONE = "yyyy-MM-dd HH:mm:ss.S";
    static final String DATE_FORMAT_2 = "yyyy-MM-dd HH:mm z";
    static final String DATE_FORMAT_2_NOTIMEZONE = "yyyy-MM-dd HH:mm";

    public static Date parseDate(String value) throws ParseException {
        try {
            return DateUtils.getFormatter().parse(value);
        }
        catch (ParseException e) {
            int ix = value.lastIndexOf(" ");
            if (ix > 0 && ix < value.length() - 1) {
                Date date = DateUtils.getFormatterNoTimeZone().parse(value.substring(0, ix));
                if (log.isDebugEnabled()) {
                    log.debug("ignoring timezone " + value.substring(ix));
                }
                return date;
            }
            throw e;
        }
    }

    public static String parseDate(Date date) {
        return DateUtils.getFormatter().format(date);
    }

    public static SimpleDateFormat getFormatter() {
        return new SimpleDateFormat(DATE_FORMAT);
    }

    public static SimpleDateFormat getFormatterNoTimeZone() {
        return new SimpleDateFormat(DATE_FORMAT_NOTIMEZONE);
    }

    public static SimpleDateFormat getFormatter2() {
        return new SimpleDateFormat(DATE_FORMAT_2);
    }

    public static SimpleDateFormat getFormatter2NoTimeZone() {
        return new SimpleDateFormat(DATE_FORMAT_2_NOTIMEZONE);
    }
}

