/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.servlet;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUIServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ClientUIServlet.class);
    private static final String RESOURCE = "resource";
    private static final String UAKEY = "TO BE DEFINED";
    private final TemplateRenderer renderer;
    private String resource;

    public ClientUIServlet(TemplateRenderer renderer) {
        this.renderer = renderer;
    }

    public void init() {
        this.resource = this.getServletConfig().getInitParameter(RESOURCE);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            Map context = MacroUtils.defaultVelocityContext();
            context.put("resp", response);
            context.put("urlMode", UrlMode.AUTO);
            context.put("scope", Collections.singletonList(this.resource));
            context.put("lang", request.getParameter("loc").substring(0, 2));
            HashMap<String, String> cml = new HashMap<String, String>();
            cml.put("cp", request.getContextPath());
            cml.put("plugincp", "/plugins/servlet/publishing/client");
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            cml.put("username", user != null ? user.getName() : "");
            context.put("CML", cml);
            this.renderer.render("templates/client/remote.vm", context, (Writer)response.getWriter());
        }
        catch (Exception e) {
            log.error("Unexpected error while initializing template resources", (Throwable)e);
        }
    }
}

