/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.rest;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import com.comalatech.confluence.publishing.AbstractPageService;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import com.comalatech.confluence.publishing.InternalPublishingManager;
import com.comalatech.confluence.publishing.ManifestManager;
import com.comalatech.confluence.publishing.PagePublisher;
import com.comalatech.confluence.publishing.PublishingUserException;
import com.comalatech.confluence.publishing.SpacePublisher;
import com.comalatech.confluence.publishing.event.PagePublishedActionEvent;
import com.comalatech.confluence.publishing.license.AdhocPublishingLicenseManager;
import com.comalatech.confluence.publishing.model.PublishManifest;
import com.comalatech.confluence.publishing.model.PublishingOption;
import com.comalatech.confluence.publishing.rest.model.DraftPageInfo;
import com.comalatech.confluence.publishing.rest.model.PagePublishingInfo;
import com.comalatech.confluence.publishing.rest.model.PublishSpaceRequest;
import com.comalatech.confluence.publishing.rest.model.PublishSpaceResponse;
import com.comalatech.confluence.publishing.rest.model.PublishedPageInfo;
import com.comalatech.confluence.publishing.rest.model.SpaceInfo;
import com.comalatech.confluence.publishing.space.configuration.model.PublishSpaceData;
import com.comalatech.confluence.publishing.space.configuration.services.PublishingSpaceService;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/publishing")
public class PublishingResources {
    private static final Logger log = LoggerFactory.getLogger(PublishingResources.class);
    public static final String SYNCHRONISED = "synchronised";
    public static final String UNSYNCHRONISED = "unsynchronised";
    public static final String NEW_PAGE = "new";
    private final ManifestManager manifestManager;
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final InternalPublishingManager publishingManager;
    private final InternalPublishingConfigurationManager publishingConfigurationManager;
    private final AbstractPageService abstractPageService;
    private final AdhocPublishingLicenseManager licenseManager;
    private final SpaceManager spaceManager;
    private final PagePublisher pagePublisher;
    private final SpacePublisher spacePublisher;
    private final PublishingSpaceService publishingSpaceService;
    private final EventPublisher eventPublisher;

    public PublishingResources(ManifestManager manifestManager, PageManager pageManager, PermissionManager permissionManager, InternalPublishingConfigurationManager publishingConfigurationManager, InternalPublishingManager publishingManager, AbstractPageService abstractPageService, AdhocPublishingLicenseManager licenseManager, SpaceManager spaceManager, PagePublisher pagePublisher, SpacePublisher spacePublisher, PublishingSpaceService publishingSpaceService, EventPublisher eventPublisher) {
        this.manifestManager = manifestManager;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.publishingConfigurationManager = publishingConfigurationManager;
        this.publishingManager = publishingManager;
        this.abstractPageService = abstractPageService;
        this.licenseManager = licenseManager;
        this.spaceManager = spaceManager;
        this.pagePublisher = pagePublisher;
        this.spacePublisher = spacePublisher;
        this.publishingSpaceService = publishingSpaceService;
        this.eventPublisher = eventPublisher;
    }

    @Produces(value={"application/json"})
    @Path(value="/space/{spaceKey}")
    @GET
    public Response getSpaceInfo(@PathParam(value="spaceKey") String spaceKey) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!TextUtils.stringSet((String)spaceKey) || this.spaceManager.getSpace(spaceKey) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)this.spaceManager.getSpace(spaceKey))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        String destSpaceKey = this.publishingConfigurationManager.getPublicSpaceKey(space);
        boolean existDestSpace = TextUtils.stringSet((String)destSpaceKey);
        SpaceInfo spaceInfo = new SpaceInfo();
        if (existDestSpace) {
            spaceInfo.setDraft(true);
            spaceInfo.setWatermark(this.publishingConfigurationManager.isDraftWatermark(space));
        }
        return Response.ok((Object)spaceInfo).build();
    }

    @Produces(value={"application/json"})
    @Path(value="/{pageId}")
    @GET
    public Response getInfo(@PathParam(value="pageId") long pageId) {
        PublishManifest manifest;
        Space destinationSpace;
        PagePublishingInfo pagePublishingInfo = new PagePublishingInfo();
        DraftPageInfo draftPageInfo = null;
        PublishedPageInfo publishedPageInfo = null;
        AbstractPage page = this.pageManager.getAbstractPage(pageId);
        if (page == null || !this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)page)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String sourceSpaceKey = this.publishingConfigurationManager.getSourceSpaceKey(page.getSpace());
        String destinationSpaceKey = this.publishingConfigurationManager.getPublicSpaceKey(page.getSpace());
        if (TextUtils.stringSet((String)destinationSpaceKey) && (destinationSpace = this.spaceManager.getSpace(destinationSpaceKey)) != null) {
            String spaceKey;
            draftPageInfo = new DraftPageInfo();
            draftPageInfo.setPublishSpace(destinationSpaceKey);
            draftPageInfo.setPublishSpaceName(destinationSpace.getName());
            draftPageInfo.setCanPublish(this.publishingManager.canPublishPage(page.getSpaceKey(), destinationSpaceKey) && this.isLicensed());
            draftPageInfo.setWatermark(this.publishingConfigurationManager.isDraftWatermark(page.getSpace()));
            draftPageInfo.setDisplayLozenge(this.publishingConfigurationManager.isDisplayPublishingLozenge(page.getSpace()));
            long destinationPageId = this.publishingManager.getPublishedPageId(page, destinationSpaceKey);
            AbstractPage destinationPage = null;
            if (destinationPageId != 0L && TextUtils.stringSet((String)(spaceKey = this.spaceManager.getSpaceFromPageId(destinationPageId))) && spaceKey.equalsIgnoreCase(destinationSpaceKey)) {
                destinationPage = this.abstractPageService.loadById(destinationPageId);
            }
            if (destinationPage == null) {
                destinationPage = this.abstractPageService.loadByTypeAndSpace(page, destinationSpaceKey);
            }
            if (destinationPage != null && !destinationPage.isDeleted()) {
                draftPageInfo.setPublishedPageId(destinationPage.getId());
            }
            manifest = this.manifestManager.getManifest((ContentEntityObject)destinationPage);
            draftPageInfo.setSyncState(this.getSyncStatus(page, destinationPage, manifest));
        }
        if (TextUtils.stringSet((String)sourceSpaceKey)) {
            Space sourceSpace;
            long draftPageId = this.publishingManager.getDraftPageId(page);
            AbstractPage sourcePage = this.abstractPageService.loadById(draftPageId);
            if (sourcePage == null) {
                sourcePage = this.abstractPageService.loadByTypeAndSpace(page, sourceSpaceKey);
            }
            if ((sourceSpace = this.spaceManager.getSpace(sourceSpaceKey)) != null && (this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)sourcePage) || sourcePage == null && this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)sourceSpace))) {
                publishedPageInfo = new PublishedPageInfo();
                publishedPageInfo.setDraftSpace(sourceSpaceKey);
                manifest = this.manifestManager.getManifest((ContentEntityObject)page);
                publishedPageInfo.setSyncState(this.getSyncStatus(sourcePage, page, manifest));
                if (sourcePage != null && !sourcePage.isDeleted()) {
                    publishedPageInfo.setDraftPageId(sourcePage.getId());
                }
            }
        }
        pagePublishingInfo.setDraftPageInfo(draftPageInfo);
        pagePublishingInfo.setPublishedPageInfo(publishedPageInfo);
        return Response.ok((Object)pagePublishingInfo).build();
    }

    private boolean isLicensed() {
        return this.licenseManager.getLicense().isDefined() && !((PluginLicense)this.licenseManager.getLicense().get()).getError().isDefined();
    }

    protected String getSyncStatus(AbstractPage source, AbstractPage destination, PublishManifest manifest) {
        Map<PublishingOption, Boolean> publishingOptions;
        if (source == null || source.isDeleted() || destination == null || destination.isDeleted() || manifest == null) {
            return NEW_PAGE;
        }
        if (destination.getVersion() == manifest.getDestinationVersion() && source.getVersion() == manifest.getSourceVersion() && !this.pagePublisher.isPageChanged(source, destination, publishingOptions = this.publishingConfigurationManager.getSpacePublishingOptions(source.getLatestVersion().getSpace()))) {
            return SYNCHRONISED;
        }
        return UNSYNCHRONISED;
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/{pageId}/publish")
    @POST
    public Response publishPage(@PathParam(value="pageId") long pageId, @QueryParam(value="updateComment") String updateComment, @DefaultValue(value="false") @QueryParam(value="suppressNotifications") boolean suppressNotifications) {
        AbstractPage page = this.pageManager.getAbstractPage(pageId);
        if (page == null || !this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)page)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String destinationSpaceKey = this.publishingConfigurationManager.getPublicSpaceKey(page.getSpace());
        if (!this.publishingManager.canPublishPage(page.getSpaceKey(), destinationSpaceKey) || !this.isLicensed()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            this.publishingManager.publishPageWithoutCheckingPermissions(page, updateComment, suppressNotifications);
        }
        catch (Exception e) {
            log.error("Error when publishing page: " + page, (Throwable)e);
            return Response.serverError().build();
        }
        this.eventPublisher.publish((Object)new PagePublishedActionEvent());
        return this.getInfo(pageId);
    }

    @Produces(value={"application/json"})
    @Path(value="/publish/space/{spaceKey}")
    @GET
    public Response getPublishSpaceOptions(@PathParam(value="spaceKey") String spaceKey) {
        Space space = this.getSpace(spaceKey);
        if (space == null) {
            log.error("Error getting the space for the given space key: " + spaceKey);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            this.publishingManager.checkSpacePublishingOrCopyPermissions(space, null, false);
        }
        catch (PublishingUserException ex) {
            log.error("Error getting Publish Space configuration: " + ex.getMessage());
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ex.getMessage()).build();
        }
        PublishSpaceData publishSpaceData = this.publishingSpaceService.getPublishSpaceConfiguration(space);
        return this.buildRestPublishSpace(publishSpaceData);
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/publish/space/{spaceKey}")
    @POST
    public Response updatePublishSpaceOptions(@PathParam(value="spaceKey") String spaceKey, PublishSpaceRequest publishSpaceRequest) {
        Space space = this.getSpace(spaceKey);
        if (space == null) {
            log.error("Error getting the space for the given space key: " + spaceKey);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            this.publishingManager.checkSpacePublishingOrCopyPermissions(space, null, false);
        }
        catch (PublishingUserException ex) {
            log.error("Error getting Publish Space configuration: " + ex.getMessage());
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ex.getMessage()).build();
        }
        try {
            this.publishingSpaceService.updatePublishSpaceConfiguration(space, publishSpaceRequest.getPublishSpaceData().getPublicSpace(), publishSpaceRequest.getPublishSpaceData());
        }
        catch (Exception ex) {
            log.error("There has been an error saving the publish space configuration: " + ex.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build();
        }
        return Response.ok().build();
    }

    private Response buildRestPublishSpace(PublishSpaceData publishSpaceData) {
        PublishSpaceResponse publishSpace = new PublishSpaceResponse();
        publishSpace.setPublishSpaceData(publishSpaceData);
        return Response.ok().entity((Object)publishSpace).type("application/json").build();
    }

    private Space getSpace(String spaceKey) {
        if (TextUtils.stringSet((String)spaceKey)) {
            return this.spaceManager.getSpace(spaceKey);
        }
        return null;
    }
}

