/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.reports.rest;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.comalatech.confluence.publishing.DefaultPublishingConfigurationManager;
import com.comalatech.confluence.publishing.PublishingUserException;
import com.comalatech.confluence.publishing.model.PublishingOption;
import com.comalatech.confluence.publishing.reports.PublishingSpaceReportManager;
import com.comalatech.confluence.publishing.reports.model.OutOfSyncPagesBatchResponse;
import com.comalatech.confluence.publishing.utils.ValueException;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/space")
public class PublishingReportingResources {
    private static final Logger log = LoggerFactory.getLogger(PublishingReportingResources.class);
    private final SpaceManager spaceManager;
    private final PublishingSpaceReportManager publishingSpaceReportManager;
    private final DefaultPublishingConfigurationManager publishingConfigurationManager;
    private final PermissionManager permissionManager;

    public PublishingReportingResources(PublishingSpaceReportManager publishingSpaceReportManager, SpaceManager spaceManager, PermissionManager permissionManager, DefaultPublishingConfigurationManager publishingConfigurationManager) {
        this.spaceManager = spaceManager;
        this.publishingSpaceReportManager = publishingSpaceReportManager;
        this.publishingConfigurationManager = publishingConfigurationManager;
        this.permissionManager = permissionManager;
    }

    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/draft/{index}")
    @GET
    public Response getDraftSpaceChanges(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="index") int index) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!TextUtils.stringSet((String)spaceKey) || this.spaceManager.getSpace(spaceKey) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)this.spaceManager.getSpace(spaceKey))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            OutOfSyncPagesBatchResponse draftSpaceChangesBatch = this.publishingSpaceReportManager.getDraftOutOfSyncPagesList(spaceKey, index);
            if (draftSpaceChangesBatch.results.isEmpty() && index == 0) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)new OutOfSyncPagesBatchResponse(ConfluenceActionSupport.getTextStatic((String)"publishing.reporting.draft.no.changes", (Object[])new Object[]{this.spaceManager.getSpace(spaceKey).getName()}))).build();
            }
            return Response.ok((Object)draftSpaceChangesBatch).build();
        }
        catch (PublishingUserException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new OutOfSyncPagesBatchResponse(e.getMessage())).build();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new OutOfSyncPagesBatchResponse("Internal Server Error. Check Logs.")).build();
        }
    }

    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/public")
    @GET
    public Response getPublicSpaceChanges(@PathParam(value="spaceKey") String spaceKey) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!TextUtils.stringSet((String)spaceKey) || this.spaceManager.getSpace(spaceKey) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)this.spaceManager.getSpace(spaceKey))) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            OutOfSyncPagesBatchResponse destinationSpaceChangesBatch = this.publishingSpaceReportManager.getPublicOutOfSyncPagesList(spaceKey);
            if (destinationSpaceChangesBatch.results.isEmpty()) {
                String messageKey = this.publishingConfigurationManager.isOption(this.spaceManager.getSpace(spaceKey), PublishingOption.DELETEINDESTINATION) ? "publishing.reporting.public.no.changes.delete" : "publishing.reporting.public.no.changes";
                String destinationSpaceKey = this.publishingConfigurationManager.getPublicSpaceKey(this.spaceManager.getSpace(spaceKey));
                Space destinationSpace = this.spaceManager.getSpace(destinationSpaceKey);
                return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)new OutOfSyncPagesBatchResponse(ConfluenceActionSupport.getTextStatic((String)messageKey, (Object[])new Object[]{destinationSpace.getName()}))).build();
            }
            return Response.ok((Object)destinationSpaceChangesBatch).build();
        }
        catch (ValueException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new OutOfSyncPagesBatchResponse(ConfluenceActionSupport.getTextStatic((String)e.getError().getMessage()), e.getValue().orElse(Collections.emptyList()))).build();
        }
        catch (Exception e) {
            log.error("Error {}", (Object)e.getMessage(), (Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new OutOfSyncPagesBatchResponse("Internal Server Error. Check Logs.")).build();
        }
    }
}

