/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.reports;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.user.User;
import com.comalatech.confluence.publishing.DefaultPublishingConfigurationManager;
import com.comalatech.confluence.publishing.DefaultPublishingManager;
import com.comalatech.confluence.publishing.DefaultSpacePublisher;
import com.comalatech.confluence.publishing.PagePublisher;
import com.comalatech.confluence.publishing.PublishingUserException;
import com.comalatech.confluence.publishing.SpacePublisher;
import com.comalatech.confluence.publishing.model.AbstractPageChange;
import com.comalatech.confluence.publishing.model.AttachmentEntityChange;
import com.comalatech.confluence.publishing.model.EntityChange;
import com.comalatech.confluence.publishing.model.EntityChangeSet;
import com.comalatech.confluence.publishing.model.PageChangeSet;
import com.comalatech.confluence.publishing.model.PublishingOption;
import com.comalatech.confluence.publishing.reports.PublishingSpaceReportManager;
import com.comalatech.confluence.publishing.reports.model.AbstractPublishingReportChange;
import com.comalatech.confluence.publishing.reports.model.OutOfSyncAbstractPage;
import com.comalatech.confluence.publishing.reports.model.OutOfSyncPagesBatchResponse;
import com.comalatech.confluence.publishing.reports.model.PublishingReportAttachmentChange;
import com.comalatech.confluence.publishing.reports.model.PublishingReportAttachmentChangeTypesEnum;
import com.comalatech.confluence.publishing.reports.model.PublishingReportChangeTypesEnum;
import com.comalatech.confluence.publishing.reports.model.PublishingReportPageChange;
import com.comalatech.confluence.publishing.utils.DateUtils;
import com.comalatech.confluence.publishing.utils.ValueException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultPublishingSpaceReportManager
implements PublishingSpaceReportManager,
InitializingBean,
ApplicationContextAware {
    private final DefaultPublishingConfigurationManager publishingConfigurationManager;
    private final SpaceManager spaceManager;
    private final PageManager pageManager;
    private final CQLSearchService cqlSearchService;
    private final PagePublisher pagePublisher;
    private final WikiStyleRenderer wikiStyleRenderer;
    private final UserAccessor userAccessor;
    private final BootstrapManager bootstrapManager;
    private final DefaultPublishingManager publishingManager;
    private DefaultSpacePublisher spacePublisher;
    public static final int REPORT_BATCH_SIZE = 25;
    private ApplicationContext context;

    public DefaultPublishingSpaceReportManager(DefaultPublishingConfigurationManager publishingConfigurationManager, SpaceManager spaceManager, PageManager pageManager, CQLSearchService cqlSearchService, PagePublisher pagePublisher, WikiStyleRenderer wikiStyleRenderer, UserAccessor userAccessor, BootstrapManager bootstrapManager, DefaultPublishingManager publishingManager) {
        this.publishingConfigurationManager = publishingConfigurationManager;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.cqlSearchService = cqlSearchService;
        this.pagePublisher = pagePublisher;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.userAccessor = userAccessor;
        this.bootstrapManager = bootstrapManager;
        this.publishingManager = publishingManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.spacePublisher = (DefaultSpacePublisher)this.context.getBean("spacePublisher", SpacePublisher.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public OutOfSyncPagesBatchResponse getDraftOutOfSyncPagesList(String spaceKey, int startingIndex) throws PublishingUserException {
        int returnIndex = startingIndex;
        Space draftSpace = this.spaceManager.getSpace(spaceKey);
        String destinationSpaceKey = this.publishingConfigurationManager.getPublicSpaceKey(draftSpace);
        if (destinationSpaceKey == null) {
            throw new PublishingUserException("publishing.reporting.public.space.missing", draftSpace.getName());
        }
        Space destinationSpace = this.spaceManager.getSpace(destinationSpaceKey);
        this.publishingManager.checkSpacePublishingOrCopyPermissions(draftSpace, destinationSpace, false);
        Map<PublishingOption, Boolean> options = this.publishingConfigurationManager.getSpacePublishingOptions(draftSpace);
        ArrayList<PageChangeSet> pageChangeSets = new ArrayList<PageChangeSet>();
        while (pageChangeSets.size() < 25) {
            int limit = 25 - pageChangeSets.size();
            boolean endOfResults = this.processDraftSpaceBatch(pageChangeSets, spaceKey, destinationSpaceKey, returnIndex, limit, options);
            if (endOfResults) {
                returnIndex = -1;
                break;
            }
            returnIndex += limit;
        }
        List outOfSyncAbstractPages = pageChangeSets.stream().map(pcs -> this.transformPageChangeSetIntoReportModel((PageChangeSet)pcs, spaceKey, options)).filter(Objects::nonNull).collect(Collectors.toList());
        OutOfSyncPagesBatchResponse batchResponse = new OutOfSyncPagesBatchResponse();
        batchResponse.results = outOfSyncAbstractPages;
        batchResponse.nextIndex = returnIndex;
        batchResponse.spaceSize = this.getTotalNumberOfPagesToBeChecked(draftSpace, options.get((Object)PublishingOption.PUBLISHPAGES), options.get((Object)PublishingOption.PUBLISHBLOGPOSTS));
        return batchResponse;
    }

    @Override
    public OutOfSyncPagesBatchResponse getPublicOutOfSyncPagesList(String spaceKey) throws ValueException {
        Space draftSpace = this.spaceManager.getSpace(spaceKey);
        String destinationSpaceKey = this.publishingConfigurationManager.getPublicSpaceKey(draftSpace);
        if (destinationSpaceKey == null) {
            PublishingUserException publishingUserException = new PublishingUserException("publishing.reporting.public.space.missing", draftSpace.getName());
            throw new ValueException(publishingUserException, null);
        }
        Space destinationSpace = this.spaceManager.getSpace(destinationSpaceKey);
        try {
            this.publishingManager.checkSpacePublishingOrCopyPermissions(draftSpace, destinationSpace, false);
        }
        catch (PublishingUserException e) {
            throw new ValueException(e, null);
        }
        Map<PublishingOption, Boolean> publishingConfigurationOptions = this.publishingConfigurationManager.getSpacePublishingOptions(draftSpace);
        List<BlogPost> allDraftSpaceBlogPosts = this.spacePublisher.getPermissionCheckedBlogs(draftSpace);
        List<Page> allDraftSpacePages = this.spacePublisher.getPermissionCheckedPages(draftSpace);
        try {
            List<AbstractPageChange> pagesToDeleteOrOutOfsync = this.spacePublisher.getPagesToDeleteOrOutOfSync(draftSpace, destinationSpace, allDraftSpaceBlogPosts, allDraftSpacePages, publishingConfigurationOptions);
            List<OutOfSyncAbstractPage> destinationPageChanges = this.getDestinationSpaceChanges(spaceKey, destinationSpaceKey, publishingConfigurationOptions, pagesToDeleteOrOutOfsync);
            return new OutOfSyncPagesBatchResponse(destinationPageChanges);
        }
        catch (ValueException e) {
            List<OutOfSyncAbstractPage> destinationPageChanges = this.getDestinationSpaceChanges(spaceKey, destinationSpaceKey, publishingConfigurationOptions, e.getValue().orElse(Collections.emptyList()));
            throw new ValueException(e.getError(), destinationPageChanges);
        }
    }

    private List<OutOfSyncAbstractPage> getDestinationSpaceChanges(String spaceKey, String destinationSpaceKey, Map<PublishingOption, Boolean> publishingConfigurationOptions, List<AbstractPageChange> pagesToDeleteOrOutOfsync) {
        ArrayList<OutOfSyncAbstractPage> destinationPageChanges = new ArrayList<OutOfSyncAbstractPage>();
        PublishingReportChangeTypesEnum changeType = publishingConfigurationOptions.get((Object)PublishingOption.DELETEINDESTINATION) != false ? PublishingReportChangeTypesEnum.DELETE : PublishingReportChangeTypesEnum.OUT_OF_SYNC;
        for (AbstractPageChange pageChange : pagesToDeleteOrOutOfsync) {
            OutOfSyncAbstractPage outOfSyncAbstractPage = new OutOfSyncAbstractPage();
            AbstractPage abstractPage = (AbstractPage)pageChange.getEntity(destinationSpaceKey);
            if (abstractPage == null) continue;
            outOfSyncAbstractPage.pageName = abstractPage.getTitle();
            outOfSyncAbstractPage.pageLink = this.getPageURL(abstractPage, spaceKey);
            outOfSyncAbstractPage.version = abstractPage.getVersion();
            ArrayList<AbstractPublishingReportChange> publishingReportPageChanges = new ArrayList<AbstractPublishingReportChange>();
            PublishingReportPageChange publishingReportPageChange = new PublishingReportPageChange();
            publishingReportPageChange.type = changeType;
            publishingReportPageChanges.add(publishingReportPageChange);
            outOfSyncAbstractPage.changes = publishingReportPageChanges;
            destinationPageChanges.add(outOfSyncAbstractPage);
        }
        return destinationPageChanges;
    }

    private OutOfSyncAbstractPage transformPageChangeSetIntoReportModel(PageChangeSet pageChangeSet, String spaceKey, Map<PublishingOption, Boolean> publishingConfigurationOptions) {
        OutOfSyncAbstractPage outOfSyncAbstractPage = new OutOfSyncAbstractPage();
        ArrayList<AbstractPublishingReportChange> publishingReportChanges = new ArrayList<AbstractPublishingReportChange>();
        AbstractPage abstractPage = (AbstractPage)pageChangeSet.getChanges().get(0).getEntity(spaceKey);
        if (abstractPage == null) {
            return null;
        }
        outOfSyncAbstractPage.pageName = abstractPage.getTitle();
        outOfSyncAbstractPage.pageLink = this.getPageURL(abstractPage, spaceKey);
        outOfSyncAbstractPage.version = abstractPage.getVersion();
        AbstractPageChange addChange = pageChangeSet.getChangeOfType(1);
        if (addChange != null) {
            PublishingReportPageChange reportAddChange = new PublishingReportPageChange();
            reportAddChange.type = PublishingReportChangeTypesEnum.ADD;
            reportAddChange.date = DateUtils.getFormatter2NoTimeZone().format(abstractPage.getLastModificationDate());
            ConfluenceUser lastModifier = abstractPage.getLastModifier() != null ? abstractPage.getLastModifier() : abstractPage.getCreator();
            reportAddChange.userName = lastModifier != null ? lastModifier.getName() : null;
            reportAddChange.displayName = lastModifier != null ? lastModifier.getFullName() : null;
            reportAddChange.userPicture = lastModifier != null ? this.getUserProfilePicture((User)lastModifier) : null;
            publishingReportChanges.add(reportAddChange);
            publishingReportChanges.addAll(this.getReportAttachmentChanges(addChange));
        } else if (pageChangeSet.getChangeOfType(8) != null) {
            PublishingReportPageChange pageRestorationChange = new PublishingReportPageChange();
            pageRestorationChange.type = PublishingReportChangeTypesEnum.RESTORATION_UPDATE;
            publishingReportChanges.add(pageRestorationChange);
        } else {
            AbstractPageChange updateChange = pageChangeSet.getChangeOfType(3);
            if (updateChange != null) {
                PublishingReportPageChange reportUpdateChange = new PublishingReportPageChange();
                reportUpdateChange.type = PublishingReportChangeTypesEnum.UPDATE;
                ConfluenceUser lastModifier = abstractPage.getLastModifier() != null ? abstractPage.getLastModifier() : abstractPage.getCreator();
                reportUpdateChange.userName = lastModifier != null ? lastModifier.getName() : null;
                reportUpdateChange.displayName = lastModifier != null ? lastModifier.getFullName() : null;
                reportUpdateChange.userPicture = lastModifier != null ? this.getUserProfilePicture((User)lastModifier) : null;
                reportUpdateChange.date = DateUtils.getFormatter2NoTimeZone().format(abstractPage.getLastModificationDate());
                publishingReportChanges.add(reportUpdateChange);
                publishingReportChanges.addAll(this.getReportAttachmentChanges(updateChange));
            }
            AbstractPageChange updatePropsChange = pageChangeSet.getChangeOfType(4);
            if (publishingConfigurationOptions.get((Object)PublishingOption.COPYPROPERTIES).booleanValue() && updatePropsChange != null) {
                PublishingReportPageChange reportUpdatePropsChange = new PublishingReportPageChange();
                reportUpdatePropsChange.type = PublishingReportChangeTypesEnum.PROPS_UPDATE;
                publishingReportChanges.add(reportUpdatePropsChange);
            }
            AbstractPageChange updateLabelsChange = pageChangeSet.getChangeOfType(5);
            if (publishingConfigurationOptions.get((Object)PublishingOption.COPYLABELS).booleanValue() && updateLabelsChange != null) {
                PublishingReportPageChange reportUpdateLabelsChange = new PublishingReportPageChange();
                reportUpdateLabelsChange.type = PublishingReportChangeTypesEnum.LABELS_UPDATE;
                publishingReportChanges.add(reportUpdateLabelsChange);
            }
            AbstractPageChange updateRestrictionsChange = pageChangeSet.getChangeOfType(6);
            if (publishingConfigurationOptions.get((Object)PublishingOption.COPY_RESTRICTIONS).booleanValue() && updateRestrictionsChange != null) {
                PublishingReportPageChange reportUpdateRestrictionsChange = new PublishingReportPageChange();
                reportUpdateRestrictionsChange.type = PublishingReportChangeTypesEnum.RESTRICTIONS_UPDATE;
                publishingReportChanges.add(reportUpdateRestrictionsChange);
            }
            AbstractPageChange awpFinalUnpublishableChange = pageChangeSet.getChangeOfType(7);
            if (publishingConfigurationOptions.get((Object)PublishingOption.PUBLISH_AWP_FINAL_STATE).booleanValue() && awpFinalUnpublishableChange != null) {
                PublishingReportPageChange reportAWPUnpublishableChange = new PublishingReportPageChange();
                reportAWPUnpublishableChange.type = PublishingReportChangeTypesEnum.AWP_UNPUBLISHABLE;
                publishingReportChanges.add(reportAWPUnpublishableChange);
            }
        }
        outOfSyncAbstractPage.changes = publishingReportChanges;
        return outOfSyncAbstractPage;
    }

    private String getPageURL(AbstractPage page, String spaceKey) {
        String stringLink = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new PageContext(spaceKey), page.getLinkWikiMarkup());
        Document element = Jsoup.parse((String)stringLink, (String)"", (Parser)Parser.xmlParser());
        if (stringLink.contains("<span class=\"error\">")) {
            return "/confluence/pages/viewpage.action?pageId=" + page.getId();
        }
        return element.getElementsByTag("a").attr("href");
    }

    private List<PublishingReportAttachmentChange> getReportAttachmentChanges(AbstractPageChange pageChange) {
        ArrayList<PublishingReportAttachmentChange> publishingReportAttachmentChanges = new ArrayList<PublishingReportAttachmentChange>();
        EntityChangeSet attachmentChanges = pageChange.getAttachmentChanges();
        if (attachmentChanges != null && attachmentChanges.size() > 0) {
            for (EntityChange entityChange : attachmentChanges.getChanges()) {
                AttachmentEntityChange attachmentChange = (AttachmentEntityChange)entityChange;
                PublishingReportAttachmentChange reportAttachmentChange = new PublishingReportAttachmentChange();
                reportAttachmentChange.attachmentName = attachmentChange.getName();
                if (attachmentChange.isAdd()) {
                    reportAttachmentChange.type = PublishingReportAttachmentChangeTypesEnum.ADD;
                } else if (attachmentChange.isUpdate()) {
                    reportAttachmentChange.type = PublishingReportAttachmentChangeTypesEnum.UPDATE;
                } else if (attachmentChange.isUpdateLabels()) {
                    reportAttachmentChange.type = PublishingReportAttachmentChangeTypesEnum.LABELS_UPDATE;
                } else {
                    if (!attachmentChange.isDelete()) continue;
                    reportAttachmentChange.type = PublishingReportAttachmentChangeTypesEnum.DELETE;
                }
                Attachment attachment = (Attachment)attachmentChange.getEntity(null);
                if (attachment != null) {
                    reportAttachmentChange.attachmentVersion = attachment.getVersion();
                    reportAttachmentChange.date = DateUtils.getFormatter2NoTimeZone().format(attachment.getLastModificationDate());
                    ConfluenceUser lastModifier = attachment.getLastModifier() != null ? attachment.getLastModifier() : attachment.getCreator();
                    reportAttachmentChange.userName = lastModifier != null ? lastModifier.getName() : null;
                    reportAttachmentChange.displayName = lastModifier != null ? lastModifier.getFullName() : null;
                    reportAttachmentChange.userPicture = lastModifier != null ? this.getUserProfilePicture((User)lastModifier) : null;
                }
                publishingReportAttachmentChanges.add(reportAttachmentChange);
            }
        }
        return publishingReportAttachmentChanges;
    }

    private boolean processDraftSpaceBatch(List<PageChangeSet> changeSetList, String originSpaceKey, String destinationSpaceKey, int startingIndex, int limit, Map<PublishingOption, Boolean> publishingConfigurationOptions) {
        List<Content> searchResults = this.cqlPageSearch(originSpaceKey, startingIndex, limit, publishingConfigurationOptions.get((Object)PublishingOption.PUBLISHPAGES), publishingConfigurationOptions.get((Object)PublishingOption.PUBLISHBLOGPOSTS));
        for (Content content : searchResults) {
            PageChangeSet candidatePageChangeSet;
            AbstractPage candidatePage = this.pageManager.getAbstractPage(content.getId().asLong());
            AbstractPage destinationPage = this.spacePublisher.loadDestinationPage(destinationSpaceKey, candidatePage);
            if (!this.spacePublisher.hasCorrectLabel(candidatePage, publishingConfigurationOptions) || (candidatePageChangeSet = this.pagePublisher.createChangeSet(candidatePage, destinationPage, publishingConfigurationOptions)).getPageChanges().isEmpty()) continue;
            changeSetList.add(candidatePageChangeSet);
        }
        return searchResults.isEmpty() || searchResults.size() < limit;
    }

    private List<Content> cqlPageSearch(String spaceKey, int startingIndex, int limit, boolean copyPages, boolean copyBlogs) {
        String contentTypes;
        if (copyPages && copyBlogs) {
            contentTypes = "\"page\",\"blogpost\"";
        } else if (copyPages) {
            contentTypes = "\"page\"";
        } else if (copyBlogs) {
            contentTypes = "\"blogpost\"";
        } else {
            return new ArrayList<Content>();
        }
        String cqlInput = String.format("space = \"%s\" and type in (%s) order by title", spaceKey, contentTypes);
        return this.cqlSearchService.searchContent(cqlInput, (PageRequest)new SimplePageRequest(startingIndex, limit), new Expansion[0]).getResults();
    }

    private int getTotalNumberOfPagesToBeChecked(Space space, boolean copyPages, boolean copyBlogposts) {
        int numberOfPages = 0;
        if (copyPages) {
            numberOfPages += this.pageManager.getPages(space, true).size();
        }
        if (copyBlogposts) {
            numberOfPages += this.pageManager.getBlogPosts(space, true).size();
        }
        return numberOfPages;
    }

    protected String getUserProfilePicture(User user) {
        ProfilePictureInfo picture = this.userAccessor.getUserProfilePicture(user);
        if (picture != null) {
            return picture.getUriReference();
        }
        return this.bootstrapManager.getWebAppContextPath() + "/images/icons/profilepics/default.svg";
    }
}

