/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.model;

import com.comalatech.confluence.publishing.model.EntityChangeSet;
import com.comalatech.confluence.publishing.model.PublishingOption;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SpaceChangeSet {
    private EntityChangeSet pageAdditions;
    private EntityChangeSet pageDeletions;
    private EntityChangeSet pageUpdates;
    private EntityChangeSet propertiesUpdates;
    private EntityChangeSet restrictionsUpdates;
    private EntityChangeSet labelUpdates;
    private EntityChangeSet outOfSyncPages;
    private EntityChangeSet awpNonPublishable;
    private EntityChangeSet restorationUpdates;
    private Map<PublishingOption, Boolean> spacePublishingOptions;
    private int maxEntitiesInBatch;
    private String sourceSpaceKey;
    private String destinationSpaceKey;

    public SpaceChangeSet(String sourceSpaceKey, String destinationSpaceKey, int maxEntitiesInBatch, Map<PublishingOption, Boolean> spacePublishingOptions) {
        this.sourceSpaceKey = sourceSpaceKey;
        this.destinationSpaceKey = destinationSpaceKey;
        this.pageAdditions = new EntityChangeSet();
        this.pageDeletions = new EntityChangeSet();
        this.pageUpdates = new EntityChangeSet();
        this.propertiesUpdates = new EntityChangeSet();
        this.labelUpdates = new EntityChangeSet();
        this.restrictionsUpdates = new EntityChangeSet();
        this.outOfSyncPages = new EntityChangeSet();
        this.awpNonPublishable = new EntityChangeSet();
        this.restorationUpdates = new EntityChangeSet();
        this.maxEntitiesInBatch = maxEntitiesInBatch;
        this.spacePublishingOptions = spacePublishingOptions;
    }

    public String getSourceSpaceKey() {
        return this.sourceSpaceKey;
    }

    public String getDestinationSpaceKey() {
        return this.destinationSpaceKey;
    }

    public EntityChangeSet getPageAdditions() {
        return this.pageAdditions;
    }

    public EntityChangeSet getPageDeletions() {
        return this.pageDeletions;
    }

    public EntityChangeSet getPageUpdates() {
        return this.pageUpdates;
    }

    public EntityChangeSet getPropertiesUpdates() {
        return this.propertiesUpdates;
    }

    public EntityChangeSet getLabelUpdates() {
        return this.labelUpdates;
    }

    public EntityChangeSet getRestrictionsUpdates() {
        return this.restrictionsUpdates;
    }

    public EntityChangeSet getOutOfSyncPages() {
        return this.outOfSyncPages;
    }

    public EntityChangeSet getAwpNonPublishable() {
        return this.awpNonPublishable;
    }

    public EntityChangeSet getRestorationUpdates() {
        return this.restorationUpdates;
    }

    public int getMaxEntitiesInBatch() {
        return this.maxEntitiesInBatch;
    }

    public int getNumberOfEntities() {
        return this.pageAdditions.size() + this.pageDeletions.size() + this.pageUpdates.size() + this.labelUpdates.size() + this.propertiesUpdates.size() + this.restrictionsUpdates.size() + this.restorationUpdates.size();
    }

    public SpaceChangeSet getBatchChangesSet() {
        int max = this.maxEntitiesInBatch;
        SpaceChangeSet newBatchSpaceChangeSet = new SpaceChangeSet(this.sourceSpaceKey, this.destinationSpaceKey, this.maxEntitiesInBatch, this.spacePublishingOptions);
        newBatchSpaceChangeSet.pageDeletions = this.pageDeletions.retrieveBatchChanges(max);
        newBatchSpaceChangeSet.restorationUpdates = this.restorationUpdates.retrieveBatchChanges(max -= newBatchSpaceChangeSet.pageDeletions.size());
        newBatchSpaceChangeSet.pageAdditions = this.pageAdditions.retrieveBatchChanges(max -= newBatchSpaceChangeSet.restorationUpdates.size());
        newBatchSpaceChangeSet.pageUpdates = this.pageUpdates.retrieveBatchChanges(max -= newBatchSpaceChangeSet.pageAdditions.size());
        newBatchSpaceChangeSet.labelUpdates = this.labelUpdates.retrieveBatchChanges(max -= newBatchSpaceChangeSet.pageUpdates.size());
        newBatchSpaceChangeSet.restrictionsUpdates = this.restrictionsUpdates.retrieveBatchChanges(max -= newBatchSpaceChangeSet.labelUpdates.size());
        newBatchSpaceChangeSet.propertiesUpdates = this.propertiesUpdates.retrieveBatchChanges(max -= newBatchSpaceChangeSet.restrictionsUpdates.size());
        return newBatchSpaceChangeSet;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean isOption(PublishingOption option) {
        return this.spacePublishingOptions.get((Object)option);
    }

    public boolean isCopySpace() {
        return this.isOption(PublishingOption.COPY_SPACE);
    }
}

