/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.model;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.publishing.AbstractPageService;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityChange {
    private static final Logger log = LoggerFactory.getLogger(EntityChange.class);
    protected static PageManager pageManager;
    protected static AbstractPageService abstractPageService;
    public static final int NONE = 0;
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int UPDATE = 3;
    public static final int UPDATE_PROPERTIES = 4;
    public static final int UPDATE_LABELS = 5;
    public static final int UPDATE_RESTRICTIONS = 6;
    public static final int AWP_FINAL_UNPUBLISHABLE = 7;
    public static final int RESTORE = 8;
    protected String name;
    protected int version;
    protected List<Integer> attachmentVersions;
    protected int type;

    public EntityChange(String name, int version, int type) {
        this.name = name;
        this.version = version;
        this.type = type;
    }

    public abstract ConfluenceEntityObject getEntity(@Nullable String var1);

    public List<Integer> getAttachmentVersions() {
        return this.attachmentVersions;
    }

    public void setAttachmentVersions(List<Integer> attachmentVersions) {
        this.attachmentVersions = attachmentVersions;
    }

    public boolean isAdd() {
        return this.type == 1;
    }

    public boolean isDelete() {
        return this.type == 2;
    }

    public boolean isUpdate() {
        return this.type == 3;
    }

    public boolean isUpdateProperties() {
        return this.type == 4;
    }

    public boolean isChange() {
        return this.type != 0;
    }

    public boolean isUpdateLabels() {
        return this.type == 5;
    }

    public boolean isUpdateRestrictions() {
        return this.type == 6;
    }

    public boolean isUnpublishableAWP() {
        return this.type == 7;
    }

    public boolean isRestore() {
        return this.type == 8;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static void setPageManager(PageManager pageManager) {
        EntityChange.pageManager = pageManager;
    }

    public static void setAbstractPageService(AbstractPageService abstractPageService) {
        EntityChange.abstractPageService = abstractPageService;
    }
}

