/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.model;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.comalatech.confluence.publishing.model.AbstractPageChange;
import com.comalatech.confluence.publishing.model.AttachmentEntityChange;
import com.comalatech.confluence.publishing.model.BlogPostAttachmentEntityChange;
import com.comalatech.confluence.publishing.model.PublishingOption;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlogPostChange
extends AbstractPageChange {
    private static final Logger log = LoggerFactory.getLogger(BlogPostChange.class);
    private static final String BLOG_NOT_FOUND_MESSAGE = "The blog could not be retrieved. If it should exists and the error still persists, this may require to rebuilt Confluence index. Space name is ''{0}'', blog name is ''{1}'', blog creation date is: ''{2}''";
    private Date creationDate;

    public BlogPostChange(BlogPost source, long destinationId, int type, Map<PublishingOption, Boolean> spacePublishingOptions) {
        super(source.getTitle(), destinationId, source.getVersion(), type, spacePublishingOptions);
        this.creationDate = source.getCreationDate();
    }

    @Override
    public ConfluenceEntityObject getEntity(String spaceKey) {
        BlogPost blogPost = abstractPageService.loadBlogPostBySpaceKeyAndTitleAndCreationDate(spaceKey, this.name, this.creationDate);
        if (blogPost == null) {
            log.warn(MessageFormat.format(BLOG_NOT_FOUND_MESSAGE, spaceKey, this.name, this.creationDate));
        }
        return blogPost;
    }

    @Override
    public ConfluenceEntityObject getDestEntity() {
        return pageManager.getBlogPost(this.destinationId);
    }

    @Override
    public AttachmentEntityChange createAttachmentEntityChange(AbstractPage page, String name, int version, int type) {
        return new BlogPostAttachmentEntityChange(page, name, version, page.getCreationDate(), type);
    }
}

