/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.model;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.comalatech.confluence.publishing.model.EntityChange;
import java.text.MessageFormat;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttachmentEntityChange
extends EntityChange {
    private static final Logger log = LoggerFactory.getLogger(AttachmentEntityChange.class);
    private static final String ATTACHMENT_NOT_FOUND_MESSAGE = "The attachment or the page containing it could not be retrieved. If it should exists and the error still persists, this may require to rebuilt Confluence index. Attachment name is ''{0}'', page id is ''{1}''";
    protected long contentId;
    private static AttachmentManager attachmentManager;

    protected AttachmentEntityChange(AbstractPage page, String name, int version, int type) {
        super(name, version, type);
        this.contentId = page.getId();
    }

    @Override
    public ConfluenceEntityObject getEntity(@Nullable String spaceKey) {
        ContentEntityObject page = this.loadEntityObject();
        Attachment attachment = null;
        if (page != null) {
            attachment = this.version > 0 ? attachmentManager.getAttachment(page, this.name, this.version) : attachmentManager.getAttachment(page, this.name);
        }
        if (attachment == null) {
            log.warn(MessageFormat.format(ATTACHMENT_NOT_FOUND_MESSAGE, this.name, this.contentId));
        }
        return attachment;
    }

    protected abstract ContentEntityObject loadEntityObject();

    public static void setAttachmentManager(AttachmentManager attachmentManager) {
        AttachmentEntityChange.attachmentManager = attachmentManager;
    }
}

