/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.macro.action;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.publishing.InternalPublishingManager;
import com.comalatech.confluence.publishing.PublishingUserException;
import com.comalatech.confluence.publishing.event.PagePublishMacroActionEvent;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishMacro
extends BaseMacro {
    private static final Logger log = LoggerFactory.getLogger(PublishMacro.class);
    public static final String EXECUTE_KEY = "com.comalatech.execute";
    public static final String LOG_KEY = "com.comalatech.log";
    public static final String USER_MESSAGE_KEY = "com.comalatech.user.message";
    private InternalPublishingManager publishingManager;
    private EventPublisher eventPublisher;
    private static final String COMMENT_PARAM = "comment";

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return null;
    }

    protected boolean inExecuteMode(RenderContext renderContext) {
        return renderContext.getParam((Object)EXECUTE_KEY) != null;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            if (!this.inExecuteMode(renderContext)) {
                return "";
            }
            String comment = (String)parameters.get(COMMENT_PARAM);
            AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
            this.publishingManager.publishPageWithoutCheckingPermissions(page, comment, false);
            this.eventPublisher.publish((Object)new PagePublishMacroActionEvent());
        }
        catch (PublishingUserException e) {
            if (log.isDebugEnabled()) {
                log.error("", (Throwable)e);
            }
            if (this.inExecuteMode(renderContext)) {
                this.setUserMessage(renderContext, e.getMessage());
                this.logMessage(renderContext, e.getMessage());
            }
            throw new MacroException(e.getMessage());
        }
        catch (Exception e) {
            if (this.inExecuteMode(renderContext)) {
                log.error("error", (Throwable)e);
                this.logMessage(renderContext, e.getMessage());
            }
            throw new MacroException(e.getMessage());
        }
        return "";
    }

    private void setUserMessage(RenderContext renderContext, String message) {
        renderContext.addParam((Object)USER_MESSAGE_KEY, (Object)message);
    }

    private void logMessage(RenderContext renderContext, String message) {
        renderContext.addParam((Object)LOG_KEY, (Object)message);
    }

    public void setPublishingManager(InternalPublishingManager publishingManager) {
        this.publishingManager = publishingManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

