/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.integration;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.publishing.utils.OsgiUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaffoldingIntegration {
    private static final Logger log = LoggerFactory.getLogger(ScaffoldingIntegration.class);
    private static final String METADATA_PACKAGE = "com.servicerocket.confluence.randombits.metadata";

    public static boolean isEnabled() {
        try {
            Class.forName("com.servicerocket.confluence.randombits.metadata.MetadataManager");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void copyScaffoldData(AbstractPage source, AbstractPage destination) {
        try {
            Class<?> metadataManagerClazz = Class.forName("com.servicerocket.confluence.randombits.metadata.MetadataManager");
            Class<?> metadataStorageClazz = Class.forName("com.servicerocket.confluence.randombits.metadata.MetadataStorage");
            Object metadataManager = OsgiUtils.getService(metadataManagerClazz);
            Object sourceData = metadataManagerClazz.getMethod("loadWritableData", ContentEntityObject.class, Integer.TYPE).invoke(metadataManager, source, source.getVersion());
            Map sourceMap = (Map)sourceData.getClass().getMethod("getBaseMap", new Class[0]).invoke(sourceData, new Object[0]);
            Object destinationStorage = metadataManagerClazz.getMethod("loadWritableData", ContentEntityObject.class).invoke(metadataManager, destination);
            for (Map.Entry entry : sourceMap.entrySet()) {
                destinationStorage.getClass().getMethod("setObject", String.class, Object.class).invoke(destinationStorage, entry.getKey(), entry.getValue());
            }
            metadataManagerClazz.getMethod("saveData", metadataStorageClazz, Boolean.TYPE).invoke(metadataManager, destinationStorage, true);
        }
        catch (Exception ex) {
            log.error("Error at scaffolding integration", (Throwable)ex);
        }
    }
}

