/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.diagrams;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.comalatech.confluence.publishing.InternalPublishingManager;
import com.comalatech.confluence.publishing.diagrams.DiagramProcessor;
import com.comalatech.confluence.publishing.diagrams.DrawIoXmlTransformer;
import com.comalatech.confluence.publishing.utils.CompressionUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrawIoProcessor
implements DiagramProcessor {
    private static final Logger log = LoggerFactory.getLogger(DrawIoProcessor.class);
    public static final String DRAW_IO_PLUGIN_KEY = "com.mxgraph.confluence.plugins.diagramly";
    public static final String DRAWIO_MACRO_NAME = "drawio";
    public static final String DRAWIO_ATTACHMENT_NAME = "diagramName";
    private final String DRAWIO_ATTACHMENT_VERSION_NAME = "revision";
    private final String DIAGRAM_LABEL = "diagram";
    private final AttachmentManager attachmentManager;
    private final PageManager pageManager;
    private final DarkFeaturesManager featuresManager;
    private final InternalPublishingManager internalPublishingManager;
    public static final String DRAW_IO_TAG = "ac:name=\"drawio\"";

    public DrawIoProcessor(AttachmentManager attachmentManager, PageManager pageManager, DarkFeaturesManager featuresManager, InternalPublishingManager publishingManager) {
        this.attachmentManager = attachmentManager;
        this.pageManager = pageManager;
        this.featuresManager = featuresManager;
        this.internalPublishingManager = publishingManager;
    }

    @Override
    public ByteArrayOutputStream processGraphLinks(Attachment attachment, AbstractPage destination) {
        ByteArrayOutputStream byteArrayOutputStream;
        block12: {
            Validate.notNull((Object)destination, (String)"Destination page cannot be null", (Object[])new Object[0]);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            InputStream attachmentData = this.attachmentManager.getAttachmentData(attachment);
            try {
                XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(result);
                XMLInputFactory factory = XMLInputFactory.newInstance();
                XMLEventReader xmlEventReader = factory.createXMLEventReader(attachmentData);
                while (xmlEventReader.hasNext()) {
                    StartElement startElement;
                    String qName;
                    XMLEvent event = xmlEventReader.nextEvent();
                    if (event.getEventType() == 7) {
                        event = xmlEventReader.nextEvent();
                    } else if (event.getEventType() == 1 && (qName = (startElement = event.asStartElement()).getName().getLocalPart()).equalsIgnoreCase("diagram")) {
                        writer.add(event);
                        event = xmlEventReader.nextEvent();
                        event = this.handleDrawIoDiagram(destination, event);
                    }
                    writer.add(event);
                }
                byteArrayOutputStream = result;
                if (attachmentData == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (attachmentData != null) {
                        try {
                            attachmentData.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | IllegalArgumentException | XMLStreamException e) {
                    log.error("Error when processing drawIo attachment to page {} ", (Object)destination, (Object)e);
                    return null;
                }
            }
            attachmentData.close();
        }
        return byteArrayOutputStream;
    }

    @Override
    public void setAttachmentMacroVersion(AbstractPage source, AbstractPage destination, MacroDefinition macroDefinition, AttachmentManager attachmentManager) {
        this.setAttachmentMacroVersion(source, destination, DRAWIO_ATTACHMENT_NAME, "revision", macroDefinition, attachmentManager);
    }

    private String decodeDrawIoGraphFomString(String deflatedXml) throws IOException {
        CompressionUtils compressionUtils = new CompressionUtils();
        byte[] decode = compressionUtils.decode(deflatedXml);
        String urlEncodedXml = compressionUtils.inflate(decode);
        return URLDecoder.decode(urlEncodedXml, CompressionUtils.CHARSET_FOR_URL_ENCODING.toString());
    }

    private String encodeDrawIoGraphFromXml(String inflatedXml) throws UnsupportedEncodingException {
        CompressionUtils compressionUtils = new CompressionUtils();
        String urlEncodedXml = URLEncoder.encode(inflatedXml, CompressionUtils.CHARSET_FOR_URL_ENCODING.toString()).replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        byte[] deflate = compressionUtils.deflate(urlEncodedXml);
        byte[] base64EncodedXml = compressionUtils.encode(deflate);
        return new String(base64EncodedXml, CompressionUtils.DEFAULT_CHARSET);
    }

    private XMLEvent handleDrawIoDiagram(AbstractPage destination, XMLEvent event) throws IOException {
        if (event.getEventType() == 4) {
            DrawIoXmlTransformer drawIoXmlTransformer = new DrawIoXmlTransformer(this.pageManager, this.internalPublishingManager);
            String deflatedXml = event.asCharacters().getData();
            String drawIoXml = this.decodeDrawIoGraphFomString(deflatedXml);
            String updatedXml = drawIoXmlTransformer.updateLinksToDestinationSpace(drawIoXml, destination);
            String elementText = this.encodeDrawIoGraphFromXml(updatedXml);
            return this.generateCharacterEvent(elementText);
        }
        return event;
    }

    private Characters generateCharacterEvent(String elementText) {
        XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
        return xmlEventFactory.createCharacters(elementText);
    }
}

