/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.diagrams;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.DarkFeatures;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.comalatech.confluence.publishing.InternalPublishingManager;
import com.comalatech.confluence.publishing.diagrams.DiagramProcessor;
import com.comalatech.confluence.publishing.diagrams.DrawIoProcessor;
import com.comalatech.confluence.publishing.diagrams.GliffyProcessor;
import com.comalatech.confluence.publishing.utils.DarkFeatureKeys;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagramPublicationService {
    private static final Logger log = LoggerFactory.getLogger(DiagramPublicationService.class);
    private final XhtmlContent xhtmlContent;
    private final AttachmentManager attachmentManager;
    private final DarkFeaturesManager darkFeaturesManager;
    private final PageManager pageManager;
    private final InternalPublishingManager internalPublishingManager;

    public DiagramPublicationService(AttachmentManager attachmentManager, XhtmlContent xhtmlContent, DarkFeaturesManager darkFeaturesManager, PageManager pageManager, InternalPublishingManager internalPublishingManager) {
        this.xhtmlContent = xhtmlContent;
        this.attachmentManager = attachmentManager;
        this.darkFeaturesManager = darkFeaturesManager;
        this.pageManager = pageManager;
        this.internalPublishingManager = internalPublishingManager;
    }

    public String updateAttachmentMacrosVersionOnDestination(AbstractPage source, AbstractPage destination, String bodyStr) {
        try {
            DefaultConversionContext defaultConversionContext = new DefaultConversionContext((RenderContext)source.toPageContext());
            return this.xhtmlContent.updateMacroDefinitions(bodyStr, (ConversionContext)defaultConversionContext, macroDefinition -> {
                this.getDiagramProcessor(macroDefinition.getName()).ifPresent(diagram -> diagram.setAttachmentMacroVersion(source, destination, macroDefinition, this.attachmentManager));
                return macroDefinition;
            });
        }
        catch (XhtmlException e) {
            log.debug("XhtmlException while trying to update attachment macro version: {} ", (Object)e.getMessage());
            return bodyStr;
        }
    }

    public Optional<ByteArrayOutputStream> updateLinksWhenIsADiagramMacro(AbstractPage destination, Attachment attachment) {
        DefaultConversionContext defaultConversionContext = new DefaultConversionContext((RenderContext)destination.toPageContext());
        DarkFeatures darkFeatures = this.darkFeaturesManager.getDarkFeatures();
        ArrayList pageParameterList = new ArrayList();
        ByteArrayOutputStream data = null;
        try {
            if (darkFeatures.isFeatureEnabled(DarkFeatureKeys.DIAGRAMS_LINKS_UPDATE.toString())) {
                String pageBody = destination.getBodyAsString();
                this.xhtmlContent.handleMacroDefinitions(pageBody, (ConversionContext)defaultConversionContext, macroDefinition -> pageParameterList.add(macroDefinition.getTypedParameters()));
                for (Map currentParameterMap : pageParameterList) {
                    if (this.isDiagramMacro(pageBody, s -> s.contains("ac:name=\"drawio\""))) {
                        data = this.getUpdatedDiagramAttachmentData(destination, attachment, currentParameterMap, "diagramName", "drawio");
                    }
                    if (!this.isDiagramMacro(pageBody, s -> s.contains("ac:name=\"gliffy\""))) continue;
                    data = this.getUpdatedDiagramAttachmentData(destination, attachment, currentParameterMap, "name", "gliffy");
                }
            }
        }
        catch (Exception e) {
            log.debug("Could not process links for diagrams for destination {}", (Object)destination.getUrlPath(), (Object)e);
        }
        return Optional.ofNullable(data);
    }

    private ByteArrayOutputStream getUpdatedDiagramAttachmentData(AbstractPage destination, Attachment attachment, Map<String, Object> currentParameterMap, String diagramAttachmentNameKey, String diagramName) {
        String diagramAttachmentNameValue;
        String attachmentName = attachment.getNameForComparison();
        Object attachmentFromMap = currentParameterMap.get(diagramAttachmentNameKey);
        if (attachmentFromMap instanceof String && StringUtils.contains((CharSequence)(diagramAttachmentNameValue = (String)attachmentFromMap), (CharSequence)attachmentName)) {
            DiagramProcessor diagramProcessor = this.getDiagramProcessor(diagramName).get();
            return diagramProcessor.processGraphLinks(attachment, destination);
        }
        return null;
    }

    public boolean isDiagramMacro(String body, Predicate<String> macroCheck) {
        if (body == null) {
            return false;
        }
        return macroCheck.test(body);
    }

    private Optional<DiagramProcessor> getDiagramProcessor(String name) {
        if (StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"drawio")) {
            return Optional.of(new DrawIoProcessor(this.attachmentManager, this.pageManager, this.darkFeaturesManager, this.internalPublishingManager));
        }
        if (StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"gliffy")) {
            return Optional.of(new GliffyProcessor());
        }
        return Optional.empty();
    }
}

