/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.awp;

import com.atlassian.plugin.PluginAccessor;
import com.comalatech.confluence.publishing.awp.StateServiceAccessor;
import com.comalatech.confluence.publishing.awp.StateServiceFactory;
import com.comalatech.confluence.publishing.awp.StateServiceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class StateServiceAccessorImpl
implements StateServiceAccessor {
    private static final Logger log = LoggerFactory.getLogger(StateServiceAccessorImpl.class);
    private static final String CDM_PLUGIN_KEY = "com.comalatech.workflow";
    private final ApplicationContext applicationContext;
    private final PluginAccessor pluginAccessor;
    private StateServiceHolder stateServiceHolder;

    public StateServiceAccessorImpl(ApplicationContext applicationContext, PluginAccessor pluginAccessor) {
        this.applicationContext = applicationContext;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public synchronized StateServiceHolder getStateService() {
        if (this.stateServiceHolder == null) {
            this.initStateServiceHolder();
        }
        return this.stateServiceHolder;
    }

    private void initStateServiceHolder() {
        try {
            Class<?> stateServiceFactoryClass = this.getStateServiceFactoryClass();
            if (stateServiceFactoryClass != null) {
                this.stateServiceHolder = ((StateServiceFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(StateServiceFactory.class, 3, false)).get();
            }
        }
        catch (Exception e) {
            log.debug("Could not create SupplierAssistantHolder", (Throwable)e);
        }
    }

    private Class<?> getStateServiceFactoryClass() {
        try {
            boolean isWorkflowEnabled = this.pluginAccessor.isPluginEnabled(CDM_PLUGIN_KEY);
            if (isWorkflowEnabled) {
                return this.getClass().getClassLoader().loadClass("com.comalatech.confluence.publishing.awp.StateServiceFactory");
            }
            return null;
        }
        catch (Exception e) {
            log.error("Unexpectely, the state factory service could not be loaded.", (Throwable)e);
            return null;
        }
    }
}

