/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.analytics.web;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.comalatech.confluence.analytics.AnalyticsManager;
import com.comalatech.confluence.publishing.analytics.web.WebAnalyticsManager;

public class MatomoWebAnalyticsManagerImpl
implements WebAnalyticsManager {
    private static final String DEV_UA = "2";
    private static final String PRODUCTION_UA = "3";
    private static final String MATOMO_DOMAIN = "comalatech.matomo.cloud";
    private AnalyticsManager analyticsManager;
    private PluginLicenseManager licenseManager;

    public MatomoWebAnalyticsManagerImpl(AnalyticsManager analyticsManager, PluginLicenseManager licenseManager) {
        this.analyticsManager = analyticsManager;
        this.licenseManager = licenseManager;
    }

    @Override
    public String getUAKey() {
        if (this.isProdInstance()) {
            return PRODUCTION_UA;
        }
        return DEV_UA;
    }

    @Override
    public String getAnalyticsDomain() {
        return MATOMO_DOMAIN;
    }

    @Override
    public boolean isStatsEnabled() {
        return this.analyticsManager.isEnabled();
    }

    private boolean isProdInstance() {
        return !this.analyticsManager.isDevMode() && this.isValidLicense();
    }

    private boolean isValidLicense() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            return pluginLicense.isValid() || pluginLicense.isEvaluation();
        }
        return false;
    }
}

