/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.analytics;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.comalatech.confluence.analytics.DefaultAnalyticsManager;
import com.comalatech.confluence.analytics.StatField;
import com.comalatech.confluence.publishing.analytics.AnalyticsDataCollector;
import com.comalatech.confluence.publishing.stats.PublishingStatisticsManager;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;

public class ExtendedAnalyticsManager
extends DefaultAnalyticsManager
implements InitializingBean {
    private final AnalyticsDataCollector publishingDataCollector;
    private final AnalyticsDataCollector workflowsIntegrationDataCollector;
    private final PublishingStatisticsManager publishingStatisticsManager;

    public ExtendedAnalyticsManager(BandanaManager bandanaManager, ConfluenceSidManager confluenceSidManager, SystemInformationService systemInformationService, PluginAccessor pluginAccessor, PluginLicenseManager pluginLicenseManager, SearchManager searchManager, @Qualifier(value="publishingDataCollector") AnalyticsDataCollector publishingDataCollector, @Qualifier(value="workflowsIntegrationDataCollector") AnalyticsDataCollector workflowsIntegrationDataCollector, PublishingStatisticsManager publishingStatisticsManager) {
        super(bandanaManager, confluenceSidManager, systemInformationService, pluginAccessor, pluginLicenseManager, searchManager);
        this.publishingDataCollector = publishingDataCollector;
        this.workflowsIntegrationDataCollector = workflowsIntegrationDataCollector;
        this.publishingStatisticsManager = publishingStatisticsManager;
    }

    protected StatField[] getExtendedStatFields() {
        ArrayList<StatField> fields = new ArrayList<StatField>();
        fields.addAll(this.publishingDataCollector.getAnalyticsFields(Arrays.asList("latestSpacePublished", "latestSpaceCopied", "latestPagePublished")));
        fields.addAll(this.workflowsIntegrationDataCollector.getAnalyticsFields());
        return fields.toArray(new StatField[0]);
    }

    public void afterPropertiesSet() {
        if (this.publishingStatisticsManager != null) {
            this.setEnabled(this.publishingStatisticsManager.isStatsEnabled());
        }
    }
}

