/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.action.model;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import java.util.List;

public class PageReorder {
    private final Page page;
    private final PageManager pageManager;

    public PageReorder(Long pageId, PageManager pageManager) {
        this.page = pageManager.getPage(pageId.longValue());
        this.pageManager = pageManager;
    }

    public void reorderPage() throws Exception {
        PagePosition pagePosition = this.getPagePosition();
        Page oldParent = this.page.getParent();
        switch (pagePosition) {
            case SINGLE_CHILD: {
                this.pageManager.movePageToTopLevel(this.page, this.page.getSpace());
                this.pageManager.movePageAsChild(this.page, oldParent);
                break;
            }
            case FIRST_CHILD: {
                Page nextSiblingPage = this.getSiblingWithPosition(this.page.getPosition() + 1, oldParent);
                this.pageManager.movePageToTopLevel(this.page, this.page.getSpace());
                this.pageManager.movePageBefore(this.page, nextSiblingPage);
                break;
            }
            case NOT_FIRST_CHILD: {
                Page previousSiblingPage = this.getSiblingWithPosition(this.page.getPosition() - 1, oldParent);
                this.pageManager.movePageToTopLevel(this.page, this.page.getSpace());
                this.pageManager.movePageAfter(this.page, previousSiblingPage);
                break;
            }
        }
    }

    private Page getSiblingWithPosition(Integer siblingPosition, Page parent) throws Exception {
        for (Page child : parent.getChildren()) {
            if (!child.getPosition().equals(siblingPosition)) continue;
            return child;
        }
        throw new IllegalArgumentException("No child found for parent page with id '" + parent.getId() + "' with position '" + siblingPosition + "'");
    }

    private PagePosition getPagePosition() {
        Page parent = this.page.getParent();
        if (parent != null) {
            List parentChildren = parent.getChildren();
            if (parentChildren.size() == 1) {
                return PagePosition.SINGLE_CHILD;
            }
            if (parentChildren.size() > 1) {
                return this.page.getPosition() == 0 ? PagePosition.FIRST_CHILD : PagePosition.NOT_FIRST_CHILD;
            }
        }
        return PagePosition.ROOT;
    }

    static enum PagePosition {
        FIRST_CHILD,
        NOT_FIRST_CHILD,
        SINGLE_CHILD,
        ROOT;

    }
}

