/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.action.condition;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.plugin.PluginAccessor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SpaceHasSidebarTheme
extends BaseConfluenceCondition {
    private final PluginAccessor pluginAccessor;
    private final ThemeManager themeManager;

    public SpaceHasSidebarTheme(PluginAccessor pluginAccessor, ThemeManager themeManager) {
        this.pluginAccessor = pluginAccessor;
        this.themeManager = themeManager;
    }

    protected boolean shouldDisplay(WebInterfaceContext webInterfaceContext) {
        Space space = webInterfaceContext.getSpace();
        boolean pluginEnabled = this.pluginAccessor.isPluginEnabled("com.atlassian.confluence.plugins.confluence-space-ia");
        boolean correctSpaceTheme = space != null && this.hasSpaceSideBar(space);
        return correctSpaceTheme && pluginEnabled;
    }

    private boolean hasSpaceSideBar(Space space) {
        Theme spaceTheme = this.themeManager.getSpaceTheme(space.getKey());
        try {
            Method hasSpaceSideBarMethod = spaceTheme.getClass().getMethod("hasSpaceSideBar", new Class[0]);
            return (Boolean)hasSpaceSideBarMethod.invoke((Object)spaceTheme, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }
}

