/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.action;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.core.util.PairType;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import com.comalatech.confluence.publishing.InternalPublishingManager;
import com.comalatech.confluence.publishing.PublishingException;
import com.comalatech.confluence.publishing.PublishingUserException;
import com.comalatech.confluence.publishing.api.model.PublishingSpaceConfiguration;
import com.comalatech.confluence.publishing.awp.StateServiceAccessor;
import com.comalatech.confluence.publishing.event.SpacePublishedActionEvent;
import com.comalatech.confluence.publishing.license.AdhocPublishingLicenseManager;
import com.comalatech.confluence.publishing.model.PublishingOption;
import com.comalatech.confluence.publishing.model.SpaceChangeSet;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.opensymphony.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingAction
extends AbstractSpaceAction
implements SpaceAware {
    private static final Logger log = LoggerFactory.getLogger(PublishingAction.class);
    public static final String WIZARD = "WIZARD";
    public static final String VIEWPUBLIC = "VIEWPUBLIC";
    private static final String PUBLISH_SPACE_TASK_KEY = "com.comalatech.publishing.publishSpace.task";
    protected InternalPublishingManager publishingManager;
    protected InternalPublishingConfigurationManager publishingConfigurationManager;
    protected AdhocPublishingLicenseManager licenseManager;
    protected LongRunningTaskManager longRunningTaskManager;
    protected StateServiceAccessor stateServiceAccessor;
    private ContentPropertyManager contentPropertyManager;
    private TransactionalHostContextAccessor transactionalHostContextAccessor;
    protected String publicSpaceKey;
    protected boolean copyProperties;
    protected boolean copyLabels;
    protected boolean copyPages;
    protected boolean copyBlogPosts;
    protected boolean deleteInDestination;
    protected boolean replaceLocalReferences;
    protected boolean copyVersionComments;
    protected boolean ignoreManifest;
    protected boolean ignoreTopLevelPages;
    protected boolean overrideContent;
    protected boolean copyScaffoldData;
    protected boolean ignoreSyncLabel;
    protected boolean syncLabelCascadeMode;
    protected boolean ignoreSyncLabelOnBlogPosts;
    protected boolean deleteSyncLabelOnSource;
    protected boolean exclusiveSyncLabel;
    protected boolean exactLabelSync;
    protected int maxBatchSize;
    protected boolean singlePagePublishing;
    protected boolean publicToDraftSyncRequired;
    protected boolean publishAWPFinalVersion;
    protected boolean draftWatermark;
    protected boolean displayLozenge;
    protected boolean usePublishDate;
    protected boolean copyRestrictions;
    protected boolean largeSpaceCopyOrPublication;
    protected List<PairType> publicSpaces;
    protected List<PairType> draftSpaces;
    protected Space publicSpace;
    protected Space draftSpace;
    private Date lastSync;
    private boolean isPublishing;
    private String publishSpaceTaskId;
    private int publishPercentage;
    private SpaceChangeSet spaceChangeSet;
    private boolean editMode = false;
    private boolean publicMode = false;
    protected boolean canPublish;
    protected String errorMessage;
    protected LongRunningTaskId taskId;
    protected int totalBatches;
    protected int totalNumberOfChanges;
    protected final ObjectMapper jsonObjectMapper = new ObjectMapper();
    protected EventPublisher eventPublisher;

    public String viewWizard() {
        this.createPublicSpacesList();
        this.createDraftSpacesList();
        this.editMode = true;
        return WIZARD;
    }

    public String viewPublic() {
        this.publicToDraftSyncRequired = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.PUBLIC_TO_DRAFT_SYNC_REQUIRED);
        if (this.publicToDraftSyncRequired) {
            this.editMode = true;
        }
        this.publicMode = true;
        this.canPublish = false;
        return VIEWPUBLIC;
    }

    public String viewPublishSpaceUi() {
        return "success";
    }

    public String view() {
        try {
            this.checkPermissions(null, false);
            try {
                this.retrievePublicSpace(this.getSpace());
            }
            catch (PublishingUserException e) {
                this.errorMessage = e.getMessage();
                return this.viewWizard();
            }
            this.copyProperties = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.COPYPROPERTIES);
            this.replaceLocalReferences = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.REPLACELOCALREFERENCES);
            this.copyVersionComments = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.COPYVERSIONCOMMENTS);
            this.copyScaffoldData = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.COPYSCAFFOLDDATA);
            this.copyLabels = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.COPYLABELS);
            this.copyPages = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.PUBLISHPAGES);
            this.copyBlogPosts = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.PUBLISHBLOGPOSTS);
            this.deleteInDestination = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.DELETEINDESTINATION);
            this.ignoreManifest = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.IGNORE_MANIFEST);
            this.ignoreTopLevelPages = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.IGNORE_TOPLEVELPAGES);
            this.overrideContent = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.OVERRIDE_CONTENT);
            this.ignoreSyncLabel = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.SYNC_LABEL_IGNORE);
            this.syncLabelCascadeMode = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.SYNC_LABEL_CASCADE_MODE_ENABLED);
            this.ignoreSyncLabelOnBlogPosts = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.SYNC_LABEL_IGNORE_ON_BLOGPOSTS);
            this.deleteSyncLabelOnSource = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.DELETE_SYNC_LABL_ON_SOURCE);
            this.exclusiveSyncLabel = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.EXCLUSIVE_SYNC_LABEL);
            this.exactLabelSync = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.EXACT_LABL_SYNC);
            this.maxBatchSize = this.publishingConfigurationManager.getMaxBatchSize(this.getSpace());
            this.singlePagePublishing = this.publishingConfigurationManager.isSinglePagePublishing(this.getSpace());
            this.publishAWPFinalVersion = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.PUBLISH_AWP_FINAL_STATE);
            this.draftWatermark = this.publishingConfigurationManager.isDraftWatermark(this.getSpace());
            this.displayLozenge = this.publishingConfigurationManager.isDisplayPublishingLozenge(this.getSpace());
            this.usePublishDate = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.USE_PUBLISHING_DATE);
            this.copyRestrictions = this.publishingConfigurationManager.isOption(this.getSpace(), PublishingOption.COPY_RESTRICTIONS);
            Space space = this.getSpace();
            if (space != null) {
                LongRunningTask task = this.getPublishSpaceTask(space);
                if (task != null) {
                    this.isPublishing = true;
                    this.publishPercentage = task.getPercentageComplete();
                } else {
                    this.isPublishing = false;
                }
            }
            if (!TextUtils.stringSet((String)this.publicSpaceKey)) {
                this.draftSpace = this.publishingConfigurationManager.getSourceSpace(this.getSpace());
                if (this.draftSpace != null) {
                    this.retrievePublicSpace(this.draftSpace);
                    return this.viewPublic();
                }
                return this.viewWizard();
            }
        }
        catch (PublishingUserException e) {
            this.errorMessage = e.getMessage();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "success";
    }

    private void retrievePublicSpace(Space space) throws PublishingUserException {
        this.publicSpaceKey = this.publishingConfigurationManager.getPublicSpaceKey(space);
        if (this.publicSpaceKey != null) {
            this.publicSpace = this.spaceManager.getSpace(this.publicSpaceKey);
            if (this.publicSpace == null) {
                String key = this.publicSpaceKey;
                this.publicSpaceKey = null;
                throw new PublishingUserException("publishing.space.invalid", key);
            }
            this.lastSync = this.publishingManager.getLastSyncDate(this.publicSpace);
            this.canPublish = this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, (Object)this.publicSpace) && !this.publishingManager.isPublishing(this.publicSpace.getKey());
        }
    }

    @ReadOnlyAccessBlocked
    public String edit() {
        this.editMode = true;
        this.createPublicSpacesList();
        Space pubSpace = this.publishingConfigurationManager.getPublicSpace(this.getSpace());
        this.publicSpaces.add(0, new PairType((Serializable)((Object)""), (Serializable)((Object)this.getText("publishing.space.unlink.public", new String[]{pubSpace.getName()}))));
        return this.view();
    }

    @ReadOnlyAccessBlocked
    public String save() {
        try {
            this.checkPermissions(null, false);
            if (TextUtils.stringSet((String)this.publicSpaceKey)) {
                PublishingSpaceConfiguration config = new PublishingSpaceConfiguration();
                config.copyPropertiesOpt = this.copyProperties;
                config.copyLabelsOpt = this.copyLabels;
                config.copyPagesOpt = this.copyPages;
                config.copyBlogPostsOpt = this.copyBlogPosts;
                config.copyScaffoldDataOpt = this.copyScaffoldData;
                config.copyVersionUpdateCommentsOpt = this.copyVersionComments;
                config.deleteTargetPagesOpt = this.deleteInDestination;
                config.ignoreManifestOpt = this.ignoreManifest;
                config.ignoreTopLevelOpt = this.ignoreTopLevelPages;
                config.overrideContentOpt = this.overrideContent;
                config.ignoreSyncLabelOpt = this.ignoreSyncLabel;
                config.includeChildPagesOpt = this.syncLabelCascadeMode;
                config.copyBlogIgnoreSyncLabelOpt = this.ignoreSyncLabelOnBlogPosts;
                config.removeSourceSyncLabelOpt = this.deleteSyncLabelOnSource;
                config.onlySyncPagesWithNoSyncLabelOpt = this.exclusiveSyncLabel;
                config.replaceLabelsExactlyOpt = this.exactLabelSync;
                config.singlePagePublishingOpt = this.singlePagePublishing;
                config.copyWorkflowsFinalStateVersionOpt = this.publishAWPFinalVersion;
                config.draftWatermarkOpt = this.draftWatermark;
                config.displayStatusLozengeOpt = this.displayLozenge;
                config.replaceModDateWithPubDateOption = this.usePublishDate;
                config.copyPageRestrictionsOpt = this.copyRestrictions;
                this.publishingConfigurationManager.linkSpacesToPublish(this.getSpaceKey(), this.publicSpaceKey, config);
                this.publishingConfigurationManager.setOption(this.getSpace(), PublishingOption.REPLACELOCALREFERENCES, this.replaceLocalReferences);
                this.publishingConfigurationManager.setOption(this.publicSpace, PublishingOption.PUBLIC_TO_DRAFT_SYNC_REQUIRED, this.publicToDraftSyncRequired);
            } else {
                this.publishingConfigurationManager.setPublicSpace(this.getSpace(), null);
            }
        }
        catch (PublishingUserException e) {
            this.addActionError(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return "success";
    }

    public String createChangeSet() {
        try {
            this.retrievePublicSpace(this.getSpace());
            this.checkPermissions(this.publicSpace, false);
            if (!this.canPublish) {
                throw new PublishingUserException("publishing.space-publishing.not-allowed");
            }
            this.spaceChangeSet = this.publishingManager.createSpaceChangeSet(this.getSpace(), this.publicSpace, new ProgressMeter(), this.publishingConfigurationManager.getSpacePublishingOptions(this.getSpace()), Collections.EMPTY_SET);
            int pageChanges = this.spaceChangeSet.getPageAdditions().size() + this.spaceChangeSet.getPageUpdates().size();
            this.largeSpaceCopyOrPublication = this.publishingConfigurationManager.isLargeAmountOfPageUpdates(pageChanges);
        }
        catch (PublishingUserException e) {
            this.errorMessage = e.getMessage();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String publish() {
        try {
            LongRunningTask publishSpaceTask = this.getPublishSpaceTask(this.getSpace());
            if (publishSpaceTask != null) {
                this.isPublishing = true;
                return "error";
            }
            this.isPublishing = false;
            this.retrievePublicSpace(this.getSpace());
            this.checkPermissions(this.publicSpace, false);
            if (!this.canPublish || this.getSpace().getKey().equals(this.publicSpace.getKey())) {
                throw new PublishingUserException("publishing.space-publishing.not-allowed");
            }
            PublishSpaceTask task = new PublishSpaceTask(this.getSpace(), this.publicSpace, "publishing.space-publishing.publishing", this.publishingConfigurationManager.getSpacePublishingOptions(this.getSpace()), AuthenticatedUserThreadLocal.get());
            this.taskId = this.longRunningTaskManager.startLongRunningTask((User)AuthenticatedUserThreadLocal.get(), (LongRunningTask)task);
            if (this.taskId != null) {
                this.contentPropertyManager.setStringProperty((ContentEntityObject)this.getSpace().getDescription(), PUBLISH_SPACE_TASK_KEY, this.taskId.toString());
                this.publishSpaceTaskId = this.taskId.toString();
                this.isPublishing = true;
            }
            this.eventPublisher.publish((Object)new SpacePublishedActionEvent());
        }
        catch (PublishingUserException e) {
            this.errorMessage = e.getMessage();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return "success";
    }

    protected List<String> getPermissionTypes() {
        return Collections.singletonList("SETSPACEPERMISSIONS");
    }

    protected void checkPermissions(Space destinationSpace, boolean copySpace) throws PublishingException {
        this.publishingManager.checkSpacePublishingOrCopyPermissions(this.getSpace(), destinationSpace, copySpace);
    }

    protected List<Space> getAllSpaces() {
        SpacesQuery.Builder queryBuilder = SpacesQuery.newQuery().withSpaceType(SpaceType.GLOBAL);
        queryBuilder.forUser((User)AuthenticatedUserThreadLocal.get());
        queryBuilder.withPermission("SETSPACEPERMISSIONS");
        ListBuilder allSpacesBuilder = this.spaceManager.getSpaces(queryBuilder.build());
        if (allSpacesBuilder != null) {
            return allSpacesBuilder.getRange(0, allSpacesBuilder.getAvailableSize());
        }
        return null;
    }

    protected List<PairType> getPublicSpaceList() {
        if (log.isDebugEnabled()) {
            log.debug("creating public space list for user: " + AuthenticatedUserThreadLocal.getUsername());
        }
        ArrayList<PairType> publicSpaces = new ArrayList<PairType>();
        List<Space> allSpaces = this.getAllSpaces();
        if (allSpaces != null) {
            for (Space destinationCandidate : allSpaces) {
                String sourceSpaceKey;
                if (destinationCandidate.getKey().equals(this.getSpace().getKey()) || (sourceSpaceKey = this.publishingConfigurationManager.getSourceSpaceKey(destinationCandidate)) != null && !sourceSpaceKey.equals(this.getSpaceKey())) continue;
                publicSpaces.add(new PairType((Serializable)((Object)destinationCandidate.getKey()), (Serializable)((Object)destinationCandidate.getName())));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("public space list: " + publicSpaces);
        }
        return publicSpaces;
    }

    protected List<PairType> getDraftSpaceList() {
        if (log.isDebugEnabled()) {
            log.debug("creating draft space list for user: " + AuthenticatedUserThreadLocal.getUsername());
        }
        ArrayList<PairType> draftSpaces = new ArrayList<PairType>();
        List<Space> allSpaces = this.getAllSpaces();
        if (allSpaces != null) {
            for (Space sourceCandidate : allSpaces) {
                String destinationSpaceKey;
                if (!this.publishingManager.isSpacePublishable(sourceCandidate) || sourceCandidate.getKey().equals(this.getSpace().getKey()) || (destinationSpaceKey = this.publishingConfigurationManager.getPublicSpaceKey(sourceCandidate)) != null) continue;
                draftSpaces.add(new PairType((Serializable)((Object)sourceCandidate.getKey()), (Serializable)((Object)sourceCandidate.getName())));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("draft space list: " + draftSpaces);
        }
        return draftSpaces;
    }

    private void createPublicSpacesList() {
        this.publicSpaces = this.getPublicSpaceList();
    }

    private void createDraftSpacesList() {
        this.draftSpaces = this.getDraftSpaceList();
    }

    public SpaceChangeSet getSpaceChangeSet() {
        return this.spaceChangeSet;
    }

    private LongRunningTask getPublishSpaceTask(Space space) {
        String publishSpaceTask = this.contentPropertyManager.getStringProperty((ContentEntityObject)space.getDescription(), PUBLISH_SPACE_TASK_KEY);
        if (publishSpaceTask == null) {
            return null;
        }
        this.publishSpaceTaskId = publishSpaceTask;
        LongRunningTask task = this.longRunningTaskManager.getLongRunningTask((User)AuthenticatedUserThreadLocal.get(), LongRunningTaskId.valueOf((String)publishSpaceTask));
        if (task == null) {
            this.contentPropertyManager.removeProperty((ContentEntityObject)space.getDescription(), PUBLISH_SPACE_TASK_KEY);
            return null;
        }
        return task;
    }

    public String getTaskId() {
        return this.taskId.toString();
    }

    public void setTaskId(LongRunningTaskId taskId) {
        this.taskId = taskId;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public boolean isPublicMode() {
        return this.publicMode;
    }

    public boolean isCanPublish() {
        return this.canPublish;
    }

    public String getPublicSpaceKey() {
        return this.publicSpaceKey;
    }

    public void setPublicSpaceKey(String publicSpaceKey) {
        this.publicSpaceKey = publicSpaceKey;
    }

    public boolean isDeleteInDestination() {
        return this.deleteInDestination;
    }

    public void setDeleteInDestination(boolean deleteInDestination) {
        this.deleteInDestination = deleteInDestination;
    }

    public boolean isCopyLabels() {
        return this.copyLabels;
    }

    public void setCopyLabels(boolean copyLabels) {
        this.copyLabels = copyLabels;
    }

    public boolean isCopyPages() {
        return this.copyPages;
    }

    public void setCopyPages(boolean copyPages) {
        this.copyPages = copyPages;
    }

    public boolean isCopyBlogPosts() {
        return this.copyBlogPosts;
    }

    public void setCopyBlogPosts(boolean copyBlogPosts) {
        this.copyBlogPosts = copyBlogPosts;
    }

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }

    public boolean isIgnoreSyncLabel() {
        return this.ignoreSyncLabel;
    }

    public void setIgnoreSyncLabel(boolean ignoreSyncLabel) {
        this.ignoreSyncLabel = ignoreSyncLabel;
    }

    public boolean isIgnoreSyncLabelOnBlogPosts() {
        return this.ignoreSyncLabelOnBlogPosts;
    }

    public boolean isSyncLabelCascadeMode() {
        return this.syncLabelCascadeMode;
    }

    public void setSyncLabelCascadeMode(boolean syncLabelCascadeMode) {
        this.syncLabelCascadeMode = syncLabelCascadeMode;
    }

    public void setIgnoreSyncLabelOnBlogPosts(boolean ignoreSyncLabelOnBlogPosts) {
        this.ignoreSyncLabelOnBlogPosts = ignoreSyncLabelOnBlogPosts;
    }

    public boolean isDeleteSyncLabelOnSource() {
        return this.deleteSyncLabelOnSource;
    }

    public void setDeleteSyncLabelOnSource(boolean deleteSyncLabelOnSource) {
        this.deleteSyncLabelOnSource = deleteSyncLabelOnSource;
    }

    public boolean isExclusiveSyncLabel() {
        return this.exclusiveSyncLabel;
    }

    public void setExclusiveSyncLabel(boolean exclusiveSyncLabel) {
        this.exclusiveSyncLabel = exclusiveSyncLabel;
    }

    public boolean isExactLabelSync() {
        return this.exactLabelSync;
    }

    public void setExactLabelSync(boolean exactLabelSync) {
        this.exactLabelSync = exactLabelSync;
    }

    public List<PairType> getPublicSpaces() {
        return this.publicSpaces;
    }

    public List<PairType> getDraftSpaces() {
        return this.draftSpaces;
    }

    public Space getPublicSpace() {
        return this.publicSpace;
    }

    public Space getDraftSpace() {
        return this.draftSpace;
    }

    public void setPublicSpace(Space publicSpace) {
        this.publicSpace = publicSpace;
    }

    public Date getLastSync() {
        return this.lastSync;
    }

    public void setLastSync(Date lastSync) {
        this.lastSync = lastSync;
    }

    public boolean getIsPublishing() {
        return this.isPublishing;
    }

    public void setPublishing(boolean publishing) {
        this.isPublishing = publishing;
    }

    public int getPublishPercentage() {
        return this.publishPercentage;
    }

    public String getPublishSpaceTaskId() {
        return this.publishSpaceTaskId;
    }

    public void setPublishPercentage(int publishPercentage) {
        this.publishPercentage = publishPercentage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean isIgnoreManifest() {
        return this.ignoreManifest;
    }

    public void setIgnoreManifest(boolean ignoreManifest) {
        this.ignoreManifest = ignoreManifest;
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean isIgnoreTopLevelPages() {
        return this.ignoreTopLevelPages;
    }

    public void setIgnoreTopLevelPages(boolean ignoreTopLevelPages) {
        this.ignoreTopLevelPages = ignoreTopLevelPages;
    }

    public void setPublishingConfigurationManager(InternalPublishingConfigurationManager publishingConfigurationManager) {
        this.publishingConfigurationManager = publishingConfigurationManager;
    }

    public void setPublishingManager(InternalPublishingManager publishingManager) {
        this.publishingManager = publishingManager;
    }

    public void setReplaceLocalReferences(boolean replaceLocalReferences) {
        this.replaceLocalReferences = replaceLocalReferences;
    }

    public boolean isReplaceLocalReferences() {
        return this.replaceLocalReferences;
    }

    public boolean isCopyVersionComments() {
        return this.copyVersionComments;
    }

    public void setCopyVersionComments(boolean copyVersionComments) {
        this.copyVersionComments = copyVersionComments;
    }

    public boolean isCopyScaffoldData() {
        return this.copyScaffoldData;
    }

    public void setCopyScaffoldData(boolean copyScaffoldData) {
        this.copyScaffoldData = copyScaffoldData;
    }

    public void setOverrideContent(boolean overrideContent) {
        this.overrideContent = overrideContent;
    }

    public boolean isOverrideContent() {
        return this.overrideContent;
    }

    public void setLongRunningTaskManager(LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }

    public AdhocPublishingLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLicenseManager(AdhocPublishingLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public boolean isSinglePagePublishing() {
        return this.singlePagePublishing;
    }

    public boolean isLargeSpaceCopyOrPublication() {
        return this.largeSpaceCopyOrPublication;
    }

    public void setSinglePagePublishing(boolean singlePagePublishing) {
        this.singlePagePublishing = singlePagePublishing;
    }

    public void setPublicToDraftSyncRequired(boolean publicToDraftSyncRequired) {
        this.publicToDraftSyncRequired = publicToDraftSyncRequired;
    }

    public boolean isPublicToDraftSyncRequired() {
        return this.publicToDraftSyncRequired;
    }

    public boolean isPublishAWPFinalVersion() {
        return this.publishAWPFinalVersion;
    }

    public void setPublishAWPFinalVersion(boolean publishAWPFinalVersion) {
        this.publishAWPFinalVersion = publishAWPFinalVersion;
    }

    public void setStateServiceAccessor(StateServiceAccessor stateServiceAccessor) {
        this.stateServiceAccessor = stateServiceAccessor;
    }

    public boolean isDraftWatermark() {
        return this.draftWatermark;
    }

    public void setDraftWatermark(boolean draftWatermark) {
        this.draftWatermark = draftWatermark;
    }

    public boolean isDisplayLozenge() {
        return this.displayLozenge;
    }

    public void setDisplayLozenge(boolean displayLozenge) {
        this.displayLozenge = displayLozenge;
    }

    public boolean isUsePublishDate() {
        return this.usePublishDate;
    }

    public void setUsePublishDate(boolean usePublishDate) {
        this.usePublishDate = usePublishDate;
    }

    public boolean isCopyRestrictions() {
        return this.copyRestrictions;
    }

    public void setCopyRestrictions(boolean copyRestrictions) {
        this.copyRestrictions = copyRestrictions;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setContentPropertyManager(ContentPropertyManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    public void setTransactionalHostContextAccessor(TransactionalHostContextAccessor transactionalHostContextAccessor) {
        this.transactionalHostContextAccessor = transactionalHostContextAccessor;
    }

    public class PublishSpaceTask
    extends ConfluenceAbstractLongRunningTask {
        private Space source;
        private Space destination;
        private String taskNameKey;
        private Map<PublishingOption, Boolean> options;
        private ConfluenceUser runningUser;
        private final Set<Long> spaceCopyManifest = Sets.newHashSet();

        public PublishSpaceTask(Space source, Space destination, String taskNameKey, Map<PublishingOption, Boolean> options, ConfluenceUser runningUser) {
            this.source = source;
            this.destination = destination;
            this.taskNameKey = taskNameKey;
            this.runningUser = runningUser;
            this.options = options;
        }

        public String getName() {
            return PublishingAction.this.getText(this.taskNameKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runInternal() {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)this.runningUser);
            try {
                Thread.sleep(500L);
                SpaceChangeSet spaceChangeSet = (SpaceChangeSet)PublishingAction.this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRES_NEW, TransactionalHostContextAccessor.Permission.READ_ONLY, () -> {
                    log.info("AHP - Creating changeset...");
                    try {
                        return PublishingAction.this.publishingManager.createSpaceChangeSet(this.source, this.destination, this.progress, this.options, this.spaceCopyManifest);
                    }
                    catch (Exception e) {
                        this.progress.setStatus(String.format("{\"status\":\"%s\"}", PublishingAction.this.getText("publishing.space-publishing.progress.error")));
                        this.progress.setCompletedSuccessfully(false);
                        log.error("There has been an error publishing the space " + this.source.getKey(), (Throwable)e);
                        return null;
                    }
                });
                if (spaceChangeSet == null) {
                    return;
                }
                if (spaceChangeSet.getNumberOfEntities() == 0 && spaceChangeSet.getAwpNonPublishable() != null && spaceChangeSet.getAwpNonPublishable().getChanges() != null && spaceChangeSet.getAwpNonPublishable().getChanges().size() == 0) {
                    this.progress.setStatus("{\"statusKey\" : \"publishing.space-publishing.progress.synchronized\"}");
                    this.progress.setCompletedSuccessfully(true);
                    return;
                }
                PublishingAction.this.totalNumberOfChanges = spaceChangeSet.getNumberOfEntities();
                PublishingAction.this.totalBatches = spaceChangeSet.getNumberOfEntities() / spaceChangeSet.getMaxEntitiesInBatch();
                PublishingAction.this.totalBatches = PublishingAction.this.totalBatches + (spaceChangeSet.getNumberOfEntities() % spaceChangeSet.getMaxEntitiesInBatch() > 0 ? 1 : 0);
                if (PublishingAction.this.totalBatches == 0) {
                    this.progress.setStatus("{\"statusKey\" : \"publishing.space-publishing.progress.done\"}");
                    this.progress.setCompletedSuccessfully(true);
                    this.progress.setPercentage(100);
                    PublishingAction.this.contentPropertyManager.removeProperty((ContentEntityObject)PublishingAction.this.getSpace().getDescription(), PublishingAction.PUBLISH_SPACE_TASK_KEY);
                    return;
                }
                log.info("AHP - Space changeset created, starting to publish");
                for (int batch = 1; batch <= PublishingAction.this.totalBatches; ++batch) {
                    log.info(String.format("Publishing/Copying %s to %s. Running batch %s out of %s.", spaceChangeSet.getSourceSpaceKey(), spaceChangeSet.getDestinationSpaceKey(), batch, PublishingAction.this.totalBatches));
                    boolean completed = (Boolean)PublishingAction.this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRES_NEW, TransactionalHostContextAccessor.Permission.READ_WRITE, () -> {
                        try {
                            return PublishingAction.this.publishingManager.publishSpace(this.destination, spaceChangeSet, this.progress, this.spaceCopyManifest);
                        }
                        catch (Exception e) {
                            log.error("Error publishing the space batch " + this.source.getKey(), (Throwable)e);
                            return false;
                        }
                    });
                    this.progress.setPercentage(batch, PublishingAction.this.totalBatches);
                    if (completed) {
                        log.info("AHP space publish completed");
                        if (!spaceChangeSet.isOption(PublishingOption.COPY_FOR_PUBLISHING)) break;
                        log.info(String.format("AHP - copied space for publishing, setting publishing configuration for %s (source) and %s (destination)", this.source.getKey(), this.destination.getKey()));
                        PublishingAction.this.publishingConfigurationManager.setPublicSpace(this.destination, this.source);
                        PublishingAction.this.publishingConfigurationManager.setSinglePagePublishing(this.destination, PublishingAction.this.isSinglePagePublishing());
                        PublishingAction.this.publishingConfigurationManager.setOption(this.source, PublishingOption.PUBLIC_TO_DRAFT_SYNC_REQUIRED, false);
                        break;
                    }
                    ImmutableMap status = ImmutableMap.of((Object)"statusKey", (Object)"publishing.space-publishing.progress.batch-complete", (Object)"totalBatches", (Object)PublishingAction.this.totalBatches, (Object)"currentBatch", (Object)batch);
                    this.progress.setStatus(PublishingAction.this.jsonObjectMapper.writeValueAsString((Object)status));
                    log.info("AHP space publish batch " + batch + "/" + PublishingAction.this.totalBatches + " complete");
                }
                this.progress.setStatus("{\"statusKey\" : \"publishing.space-publishing.progress.done\"}");
                this.progress.setCompletedSuccessfully(true);
                PublishingAction.this.publishingManager.setLastSyncDate(this.source, new Date());
            }
            catch (PublishingUserException e) {
                this.progress.setStatus(String.format("{\"status\":\"%s\"}", e.getMessage()));
                this.progress.setCompletedSuccessfully(false);
                log.error("There has been an error publishing the space " + this.source.getKey(), (Throwable)e);
            }
            catch (Exception e) {
                this.progress.setStatus(String.format("{\"status\":\"%s\"}", PublishingAction.this.getText("publishing.space-publishing.progress.error")));
                this.progress.setCompletedSuccessfully(false);
                log.error("There has been an error publishing the space " + this.source.getKey(), (Throwable)e);
            }
            finally {
                this.progress.setPercentage(100);
                PublishingAction.this.contentPropertyManager.removeProperty((ContentEntityObject)PublishingAction.this.getSpace().getDescription(), PublishingAction.PUBLISH_SPACE_TASK_KEY);
            }
        }
    }
}

