/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing.action;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.core.util.PairType;
import com.atlassian.user.User;
import com.comalatech.confluence.publishing.PublishingUserException;
import com.comalatech.confluence.publishing.action.PublishingAction;
import com.comalatech.confluence.publishing.event.CopySpaceActionEvent;
import com.comalatech.confluence.publishing.model.PublishingOption;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopySpaceAction
extends PublishingAction {
    private static final Logger log = LoggerFactory.getLogger(CopySpaceAction.class);
    private boolean copyForPublishing;
    private boolean editMode = true;

    protected void initOptions() {
        this.copyProperties = PublishingOption.COPYPROPERTIES.isChecked();
        this.replaceLocalReferences = PublishingOption.REPLACELOCALREFERENCES.isChecked();
        this.copyVersionComments = PublishingOption.COPYVERSIONCOMMENTS.isChecked();
        this.copyScaffoldData = PublishingOption.COPYSCAFFOLDDATA.isChecked();
        this.copyLabels = PublishingOption.COPYLABELS.isChecked();
        this.copyPages = PublishingOption.PUBLISHPAGES.isChecked();
        this.copyBlogPosts = PublishingOption.PUBLISHBLOGPOSTS.isChecked();
        this.deleteInDestination = PublishingOption.DELETEINDESTINATION.isChecked();
        this.ignoreTopLevelPages = PublishingOption.IGNORE_TOPLEVELPAGES.isChecked();
        this.ignoreSyncLabel = PublishingOption.SYNC_LABEL_IGNORE.isChecked();
        this.ignoreSyncLabelOnBlogPosts = PublishingOption.SYNC_LABEL_IGNORE_ON_BLOGPOSTS.isChecked();
        this.deleteSyncLabelOnSource = PublishingOption.DELETE_SYNC_LABL_ON_SOURCE.isChecked();
        this.exactLabelSync = PublishingOption.EXACT_LABL_SYNC.isChecked();
        this.copyForPublishing = PublishingOption.COPY_FOR_PUBLISHING.isChecked();
        this.publishAWPFinalVersion = PublishingOption.PUBLISH_AWP_FINAL_STATE.isChecked();
        this.usePublishDate = PublishingOption.USE_PUBLISHING_DATE.isChecked();
        this.copyRestrictions = PublishingOption.COPY_RESTRICTIONS.isChecked();
    }

    @Override
    public String view() {
        try {
            this.checkPermissions(null, true);
            this.initOptions();
            this.publicSpaces = this.getPublicSpaceList();
            int totalPageAndBlogsInSpace = (int)((long)this.spaceManager.getNumberOfBlogPosts(this.space) + this.spaceManager.findPageTotal(this.space));
            this.largeSpaceCopyOrPublication = this.publishingConfigurationManager.isLargeAmountOfPageUpdates(totalPageAndBlogsInSpace);
        }
        catch (PublishingUserException e) {
            this.errorMessage = e.getMessage();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String copy() {
        try {
            this.publicSpaces = this.getPublicSpaceList();
            this.retrieveTargetSpace();
            if (log.isDebugEnabled()) {
                log.debug("checking permissions for copy space");
            }
            this.publishingManager.checkSpacePublishingOrCopyPermissions(this.getSpace(), this.publicSpace, true);
            if (!this.canPublish || this.getSpace().getKey().equals(this.publicSpace.getKey())) {
                throw new PublishingUserException("publishing.space-publishing.not-allowed");
            }
            PublishingAction.PublishSpaceTask task = new PublishingAction.PublishSpaceTask(this.getSpace(), this.publicSpace, "publishing.space-copy.copying.name", this.makeCopyOptions(), AuthenticatedUserThreadLocal.get());
            this.taskId = this.longRunningTaskManager.startLongRunningTask((User)AuthenticatedUserThreadLocal.get(), (LongRunningTask)task);
            this.eventPublisher.publish((Object)new CopySpaceActionEvent());
        }
        catch (PublishingUserException e) {
            this.errorMessage = e.getMessage();
            return "error";
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "error";
        }
        return "success";
    }

    private void retrieveTargetSpace() throws PublishingUserException {
        if (this.publicSpaceKey != null) {
            this.publicSpace = this.spaceManager.getSpace(this.publicSpaceKey);
            if (this.publicSpace == null) {
                String key = this.publicSpaceKey;
                this.publicSpaceKey = null;
                throw new PublishingUserException("publishing.space.invalid", key);
            }
        } else {
            throw new PublishingUserException("publishing.space.invalid", this.key);
        }
        this.canPublish = this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, (Object)this.publicSpace) && !this.publishingManager.isPublishing(this.publicSpace.getKey());
    }

    public Map<PublishingOption, Boolean> makeCopyOptions() {
        HashMap<PublishingOption, Boolean> spacePublishingOptions = new HashMap<PublishingOption, Boolean>();
        spacePublishingOptions.put(PublishingOption.COPY_FOR_PUBLISHING, this.copyForPublishing);
        spacePublishingOptions.put(PublishingOption.COPYPROPERTIES, this.copyProperties);
        spacePublishingOptions.put(PublishingOption.COPYLABELS, this.copyLabels);
        spacePublishingOptions.put(PublishingOption.PUBLISHPAGES, this.copyPages);
        spacePublishingOptions.put(PublishingOption.PUBLISHBLOGPOSTS, this.copyBlogPosts);
        spacePublishingOptions.put(PublishingOption.DELETEINDESTINATION, this.deleteInDestination);
        spacePublishingOptions.put(PublishingOption.REPLACELOCALREFERENCES, this.replaceLocalReferences);
        spacePublishingOptions.put(PublishingOption.COPYSCAFFOLDDATA, this.copyScaffoldData);
        spacePublishingOptions.put(PublishingOption.COPYVERSIONCOMMENTS, this.copyVersionComments);
        spacePublishingOptions.put(PublishingOption.IGNORE_TOPLEVELPAGES, this.ignoreTopLevelPages);
        spacePublishingOptions.put(PublishingOption.EXACT_LABL_SYNC, this.exactLabelSync);
        spacePublishingOptions.put(PublishingOption.PUBLISH_AWP_FINAL_STATE, this.publishAWPFinalVersion);
        spacePublishingOptions.put(PublishingOption.USE_PUBLISHING_DATE, this.usePublishDate);
        spacePublishingOptions.put(PublishingOption.COPY_RESTRICTIONS, this.copyRestrictions);
        spacePublishingOptions.put(PublishingOption.COPY_SPACE, true);
        spacePublishingOptions.put(PublishingOption.SYNC_LABEL_IGNORE, true);
        spacePublishingOptions.put(PublishingOption.SYNC_LABEL_IGNORE_ON_BLOGPOSTS, true);
        spacePublishingOptions.put(PublishingOption.IGNORE_MANIFEST, true);
        spacePublishingOptions.put(PublishingOption.OVERRIDE_CONTENT, false);
        spacePublishingOptions.put(PublishingOption.DELETE_SYNC_LABL_ON_SOURCE, false);
        return spacePublishingOptions;
    }

    @Override
    protected List<PairType> getPublicSpaceList() {
        if (log.isDebugEnabled()) {
            log.debug("creating copy space list for user: " + AuthenticatedUserThreadLocal.getUsername());
        }
        ArrayList<PairType> copySpaces = new ArrayList<PairType>();
        List<Space> allSpaces = this.getAllSpaces();
        if (allSpaces != null) {
            for (Space copyCandidate : allSpaces) {
                if (copyCandidate.getKey().equals(this.getSpace().getKey())) continue;
                copySpaces.add(new PairType((Serializable)((Object)copyCandidate.getKey()), (Serializable)((Object)copyCandidate.getName())));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("copy space list: " + copySpaces);
        }
        return copySpaces;
    }

    public boolean isCopyForPublishing() {
        return this.copyForPublishing;
    }

    public void setCopyForPublishing(boolean copyForPublishing) {
        this.copyForPublishing = copyForPublishing;
    }

    @Override
    public boolean isEditMode() {
        return this.editMode;
    }
}

