/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.bonnie.Searchable;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.compat.setup.xstream.XStreamManagerCompat;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.comalatech.confluence.publishing.AbstractPageService;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import com.comalatech.confluence.publishing.InternalPublishingManager;
import com.comalatech.confluence.publishing.ManifestManager;
import com.comalatech.confluence.publishing.PagePublisher;
import com.comalatech.confluence.publishing.PublishingException;
import com.comalatech.confluence.publishing.PublishingUserException;
import com.comalatech.confluence.publishing.SpacePublisher;
import com.comalatech.confluence.publishing.api.PublishingManager;
import com.comalatech.confluence.publishing.model.PageChangeSet;
import com.comalatech.confluence.publishing.model.PublishManifest;
import com.comalatech.confluence.publishing.model.PublishingOption;
import com.comalatech.confluence.publishing.model.SpaceChangeSet;
import com.comalatech.confluence.publishing.utils.CustomXstreamDateConverter;
import com.comalatech.confluence.publishing.utils.DarkFeatureKeys;
import com.comalatech.confluence.publishing.utils.PluginContainerManager;
import com.comalatech.confluence.publishing.utils.ValueException;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import com.thoughtworks.xstream.converters.Converter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultPublishingManager
implements InitializingBean,
ApplicationContextAware,
InternalPublishingManager,
PublishingManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultPublishingManager.class);
    public static final String LAST_SYNC_DATE_KEY = "com.comalatech.publishing.lastsync";
    public static final String PUBLISHED_PAGE_ID_KEY = "com.comalatech.publishing.published.page.id";
    private List<String> REQUIRED_SPACEPERMISSIONS;
    private final PermissionManager permissionManager;
    private final SpacePermissionManager spacePermissionManager;
    private final SpaceManager spaceManager;
    private final BandanaManager bandanaManager;
    private final InternalPublishingConfigurationManager publishingConfigurationManager;
    private final GroupManager groupManager;
    private final AbstractPageService abstractPageService;
    private final CacheManager cacheManager;
    private final ConfluenceIndexer indexer;
    private final AttachmentManager attachmentManager;
    private final ContentPropertyManager contentPropertyManager;
    private final PageManager pageManager;
    private final ManifestManager manifestManager;
    private final PluginAccessor pluginAccessor;
    private final DarkFeaturesManager darkFeaturesManager;
    private Cache publishingSpacesCache;
    private SpacePublisher spacePublisher;
    private XStreamManagerCompat xStreamManagerCompat;
    private PagePublisher pagePublisher;
    private ApplicationContext context;

    public DefaultPublishingManager(PermissionManager permissionManager, SpacePermissionManager spacePermissionManager, SpaceManager spaceManager, BandanaManager bandanaManager, InternalPublishingConfigurationManager publishingConfigurationManager, GroupManager groupManager, AbstractPageService abstractPageService, CacheManager cacheManager, ConfluenceIndexer indexer, AttachmentManager attachmentManager, ContentPropertyManager contentPropertyManager, PageManager pageManager, ManifestManager manifestManager, PluginAccessor pluginAccessor, DarkFeaturesManager darkFeaturesManager) {
        this.permissionManager = permissionManager;
        this.spacePermissionManager = spacePermissionManager;
        this.spaceManager = spaceManager;
        this.bandanaManager = bandanaManager;
        this.publishingConfigurationManager = publishingConfigurationManager;
        this.groupManager = groupManager;
        this.abstractPageService = abstractPageService;
        this.cacheManager = cacheManager;
        this.indexer = indexer;
        this.attachmentManager = attachmentManager;
        this.contentPropertyManager = contentPropertyManager;
        this.pageManager = pageManager;
        this.manifestManager = manifestManager;
        this.pluginAccessor = pluginAccessor;
        this.darkFeaturesManager = darkFeaturesManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.REQUIRED_SPACEPERMISSIONS = new ArrayList<String>();
        this.REQUIRED_SPACEPERMISSIONS.add("CREATEATTACHMENT");
        this.REQUIRED_SPACEPERMISSIONS.add("REMOVEATTACHMENT");
        this.REQUIRED_SPACEPERMISSIONS.add("EDITSPACE");
        this.REQUIRED_SPACEPERMISSIONS.add("REMOVEPAGE");
        this.publishingSpacesCache = this.cacheManager.getCache("Publishing Spaces Cache");
        this.pagePublisher = (PagePublisher)this.context.getBean("pagePublisher", PagePublisher.class);
        this.spacePublisher = (SpacePublisher)this.context.getBean("spacePublisher", SpacePublisher.class);
        this.spacePublisher = (SpacePublisher)this.context.getBean("spacePublisher", SpacePublisher.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void publishPageWithoutCheckingPermissions(AbstractPage page, String comment, boolean suppressNotifications) throws Exception {
        Space destinationSpace = this.checkDestinationSpace(page);
        AbstractPage destination = this.doSinglePagePublish(page, destinationSpace, comment, true, suppressNotifications);
        if (destination == null) {
            log.error("destination page is null when publishing " + page);
        } else {
            this.indexer.reIndex((Searchable)destination);
            List attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)destination);
            for (Attachment attachment : attachments) {
                this.indexer.reIndex((Searchable)attachment);
            }
        }
    }

    private Space checkDestinationSpace(AbstractPage page) throws PublishingUserException {
        Space destinationSpace = this.publishingConfigurationManager.getPublicSpace(page.getSpace());
        if (destinationSpace == null) {
            throw new PublishingUserException("publishing.space.not-set");
        }
        return destinationSpace;
    }

    private AbstractPage doSinglePagePublish(AbstractPage page, Space destinationSpace, String comment, boolean ignoreManifest, boolean suppressNotifications) throws Exception {
        AbstractPage destination = (AbstractPage)this.pageManager.getById(this.getPublishedPageId(page, destinationSpace.getKey()));
        if (destination == null) {
            destination = this.abstractPageService.loadByTypeAndSpace(page, destinationSpace.getKey());
        }
        Map<PublishingOption, Boolean> publishingOptions = this.getSinglePagePublishingOptions(page, ignoreManifest, suppressNotifications);
        PageChangeSet changeSet = this.pagePublisher.createChangeSet(page, destination, publishingOptions);
        if (TextUtils.stringSet((String)comment)) {
            changeSet.setVersionComment(comment);
        }
        return this.pagePublisher.publish(changeSet, page.getSpaceKey(), destinationSpace.getKey(), new Date());
    }

    private Map<PublishingOption, Boolean> getSinglePagePublishingOptions(AbstractPage page, boolean ignoreManifest, boolean suppressNotifications) {
        Map<PublishingOption, Boolean> publishingOptions = this.publishingConfigurationManager.getSpacePublishingOptions(page.getSpace());
        if (ignoreManifest) {
            publishingOptions.put(PublishingOption.IGNORE_MANIFEST, true);
        }
        publishingOptions.put(PublishingOption.PUBLISH_AWP_FINAL_STATE, false);
        if (!suppressNotifications) {
            publishingOptions.put(PublishingOption.SUPPRESS_NOTIFICATIONS, false);
        }
        publishingOptions.put(PublishingOption.IGNORE_TOPLEVELPAGES, false);
        publishingOptions.put(PublishingOption.SYNC_LABEL_IGNORE, true);
        return publishingOptions;
    }

    @Override
    public long getDraftPageId(AbstractPage publishedPage) {
        PublishManifest manifest = this.manifestManager.getManifest((ContentEntityObject)publishedPage);
        if (manifest == null) {
            return 0L;
        }
        Space sourceSpace = this.publishingConfigurationManager.getSourceSpace(publishedPage.getSpace());
        if (sourceSpace != null && publishedPage.getSpaceKey().equalsIgnoreCase(this.publishingConfigurationManager.getPublicSpaceKey(sourceSpace))) {
            return manifest.getSourceId();
        }
        return 0L;
    }

    @Override
    public boolean canPublishPage(String sourceSpaceKey, String destinationSpaceKey) {
        boolean canPublishPage;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Space destinationSpace = this.spaceManager.getSpace(destinationSpaceKey);
        Space sourceSpace = this.spaceManager.getSpace(sourceSpaceKey);
        boolean bl = canPublishPage = user != null && destinationSpace != null && this.publishingConfigurationManager.isSinglePagePublishing(sourceSpace) && this.spacePermissionManager.hasAllPermissions(this.REQUIRED_SPACEPERMISSIONS, destinationSpace, (User)user);
        if (log.isDebugEnabled()) {
            log.debug("canPublishPage? = " + canPublishPage + "\nisSinglePagePublishing? = " + this.publishingConfigurationManager.isSinglePagePublishing(sourceSpace) + "\nhasPermission? = " + this.spacePermissionManager.hasAllPermissions(this.REQUIRED_SPACEPERMISSIONS, destinationSpace, (User)user));
        }
        return canPublishPage;
    }

    @Override
    public void checkSpacePublishingOrCopyPermissions(Space sourceSpace, Space destinationSpace, boolean checkCopySpace) throws PublishingUserException {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!checkCopySpace && !this.isSpacePublishable(sourceSpace)) {
            throw new PublishingUserException("publishing.space-publishing.not-allowed-space");
        }
        if (this.permissionManager.isConfluenceAdministrator((User)user)) {
            return;
        }
        if (!this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)sourceSpace)) {
            throw new PublishingUserException("publishing.space-publishing.not-allowed");
        }
        try {
            if (!this.groupManager.hasMembership(this.groupManager.getGroup(this.publishingConfigurationManager.getAllowedGroupName(checkCopySpace)), (User)user)) {
                if (checkCopySpace) {
                    throw new PublishingUserException("publishing.space-publishing.copy-no-membership");
                }
                throw new PublishingUserException("publishing.space-publishing.destination-no-membership");
            }
        }
        catch (EntityException e) {
            log.error("error", (Throwable)e);
            throw new PublishingUserException("publishing.space-publishing.destination-no-membership", this.publishingConfigurationManager.getAllowedGroupName(checkCopySpace));
        }
        if (destinationSpace != null) {
            if (!this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", destinationSpace, (User)user)) {
                throw new PublishingUserException("publishing.space-publishing.destination-not-allowed");
            }
            if (this.isPublishing(destinationSpace.getKey())) {
                throw new PublishingUserException("publishing.space-publishing.being-published");
            }
        }
    }

    @Override
    public boolean isSpacePublishable(Space space) {
        ArrayList publishingSpaces = Lists.newArrayList((Object[])this.publishingConfigurationManager.getPublishingSpaces());
        return this.publishingConfigurationManager.isPublishAnySpace() || publishingSpaces.contains(space.getKey());
    }

    @Override
    public SpaceChangeSet createSpaceChangeSet(Space source, Space destination, ProgressMeter progressMeter, Map<PublishingOption, Boolean> spacePublishingOptions, Set<Long> copyManifest) throws PublishingException {
        Comparator<AbstractPage> orderDrawIoPagesAsLastOnes = null;
        if (null != this.pluginAccessor.getEnabledPlugin("com.mxgraph.confluence.plugins.diagramly") && this.darkFeaturesManager.getDarkFeatures().isFeatureEnabled(DarkFeatureKeys.DIAGRAMS_LINKS_UPDATE.toString())) {
            orderDrawIoPagesAsLastOnes = this.getDrawIoComparator();
        }
        int max = spacePublishingOptions.get((Object)PublishingOption.COPY_SPACE) != false ? this.publishingConfigurationManager.getMaxCopyBatchSize(source) : this.publishingConfigurationManager.getMaxBatchSize(source);
        try {
            return this.spacePublisher.createSpaceChangeSet(source, destination, progressMeter, max, spacePublishingOptions, copyManifest, orderDrawIoPagesAsLastOnes);
        }
        catch (ValueException e) {
            throw (PublishingException)e.getError();
        }
    }

    private Comparator<AbstractPage> getDrawIoComparator() {
        Predicate<AbstractPage> hasDrawIoMacro = page -> page.getBodyAsString().contains("ac:name=\"drawio\"");
        return (page, comparingPage) -> {
            if (hasDrawIoMacro.test((AbstractPage)page) && hasDrawIoMacro.test((AbstractPage)comparingPage)) {
                return 0;
            }
            if (hasDrawIoMacro.test((AbstractPage)comparingPage)) {
                return -1;
            }
            return 1;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean publishSpace(Space destinationSpace, SpaceChangeSet spaceChangeSet, ProgressMeter progressMeter, Set<Long> copyManifest) throws Exception {
        try {
            Date publishingDate = new Date();
            this.setPublishingSignal(spaceChangeSet);
            boolean completed = this.spacePublisher.publish(spaceChangeSet, progressMeter, publishingDate, copyManifest);
            if (log.isDebugEnabled()) {
                log.debug("AHP - published complete:" + completed + " setting last sync date in destination " + destinationSpace.getKey());
            }
            this.setLastSyncDate(destinationSpace, publishingDate);
            boolean bl = completed;
            return bl;
        }
        finally {
            this.unsetPublishingSignal(spaceChangeSet);
        }
    }

    private void setPublishingSignal(SpaceChangeSet spaceChangeSet) {
        this.publishingSpacesCache.put((Object)spaceChangeSet.getDestinationSpaceKey(), (Object)"true");
    }

    private void unsetPublishingSignal(SpaceChangeSet spaceChangeSet) {
        try {
            this.publishingSpacesCache.remove((Object)spaceChangeSet.getDestinationSpaceKey());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setPublishedPageId(AbstractPage page, long id) {
        this.contentPropertyManager.setStringProperty((ContentEntityObject)page, PUBLISHED_PAGE_ID_KEY, Long.toString(id));
    }

    @Override
    public long getPublishedPageId(AbstractPage draftPage, String destinationSpace) {
        String publishedPageSpaceKey;
        long pageId;
        String idString = this.contentPropertyManager.getStringProperty((ContentEntityObject)draftPage, PUBLISHED_PAGE_ID_KEY);
        long l = pageId = TextUtils.stringSet((String)idString) ? Long.parseLong(idString) : 0L;
        if (pageId != 0L && TextUtils.stringSet((String)(publishedPageSpaceKey = this.spaceManager.getSpaceFromPageId(pageId))) && publishedPageSpaceKey.equalsIgnoreCase(destinationSpace)) {
            return pageId;
        }
        return 0L;
    }

    @Override
    public boolean isPublishing(String destinationSpaceKey) {
        return this.publishingSpacesCache.get((Object)destinationSpaceKey) != null;
    }

    @Override
    public Date getLastSyncDate(Space space) {
        String rawDate = (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(space), LAST_SYNC_DATE_KEY);
        if (!TextUtils.stringSet((String)rawDate)) {
            return null;
        }
        if (this.xStreamManagerCompat == null) {
            this.initXStreamManagerCompat();
        }
        return (Date)this.xStreamManagerCompat.fromXML(rawDate);
    }

    @Override
    public void setLastSyncDate(Space space, Date date) {
        if (this.xStreamManagerCompat == null) {
            this.initXStreamManagerCompat();
        }
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(space), LAST_SYNC_DATE_KEY, (Object)this.xStreamManagerCompat.toXML((Object)date));
    }

    private void initXStreamManagerCompat() {
        this.xStreamManagerCompat = PluginContainerManager.getComponent("xStreamManagerCompat", XStreamManagerCompat.class);
        if (this.xStreamManagerCompat != null) {
            this.xStreamManagerCompat.alias("Date", Date.class);
            this.xStreamManagerCompat.registerConverter((Converter)new CustomXstreamDateConverter(), Integer.valueOf(0));
        } else {
            log.error("Could not load XStream Manager Compat.");
        }
    }
}

