/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.BodyContent;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.core.DefaultDeleteContext;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.ChildPositionComparator;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.RenderContext;
import com.atlassian.user.User;
import com.comalatech.confluence.publishing.AbstractEntityPublisher;
import com.comalatech.confluence.publishing.AbstractPageService;
import com.comalatech.confluence.publishing.AttachmentPublisher;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import com.comalatech.confluence.publishing.InternalPublishingManager;
import com.comalatech.confluence.publishing.LabelPublisher;
import com.comalatech.confluence.publishing.ManifestManager;
import com.comalatech.confluence.publishing.PagePublisher;
import com.comalatech.confluence.publishing.PropertiesPublisher;
import com.comalatech.confluence.publishing.PublishingException;
import com.comalatech.confluence.publishing.diagrams.DiagramPublicationService;
import com.comalatech.confluence.publishing.event.PageAddedPublishedEventImpl;
import com.comalatech.confluence.publishing.event.PageAttachmentUpdatedPublishedEventImpl;
import com.comalatech.confluence.publishing.event.PageContentUpdatedPublishedEventImpl;
import com.comalatech.confluence.publishing.event.PageDeletedPublishedEventImpl;
import com.comalatech.confluence.publishing.event.PageLabelUpdatedPublishedEventImpl;
import com.comalatech.confluence.publishing.event.PagePropertiesUpdatedPublishedEventImpl;
import com.comalatech.confluence.publishing.event.PageRestoredPublishedEventImpl;
import com.comalatech.confluence.publishing.event.PageRestrictionsUpdatedPublishedEventImpl;
import com.comalatech.confluence.publishing.event.PageUpdatedPublishedEventImpl;
import com.comalatech.confluence.publishing.event.seibertmedia.linchpinenterprisenews.PagePublishPropertiesEvent;
import com.comalatech.confluence.publishing.integration.ScaffoldingIntegration;
import com.comalatech.confluence.publishing.model.AbstractPageChange;
import com.comalatech.confluence.publishing.model.EntityChange;
import com.comalatech.confluence.publishing.model.PageChangeSet;
import com.comalatech.confluence.publishing.model.PublishManifest;
import com.comalatech.confluence.publishing.model.PublishingOption;
import com.comalatech.confluence.publishing.utils.WorkflowsStateDelegate;
import com.comalatech.workflow.model.State;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultPagePublisher
extends AbstractEntityPublisher
implements PagePublisher,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultPagePublisher.class);
    public static final String EXCERPT_KEY = "confluence.excerpt";
    public static final String IGNORE_PUBLISHING_MACRO_NAME = "ignore-publishing";
    private final DefaultSaveContext PUBLISH_OVERRIDE_CONTEXT = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)new DefaultSaveContext.Builder().suppressNotifications(true)).updateLastModifier(false).suppressEvents(false)).build();
    private final DefaultSaveContext PUBLISH_SAVE_CONTEXT = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)new DefaultSaveContext.Builder().suppressNotifications(true)).updateLastModifier(true).suppressEvents(false)).build();
    private final DefaultSaveContext PUBLISH_OVERRIDE_CONTEXT_WITH_NOTIFICATIONS = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)new DefaultSaveContext.Builder().suppressNotifications(false)).updateLastModifier(false).suppressEvents(false)).build();
    private final DefaultSaveContext PUBLISH_SAVE_CONTEXT_WITH_NOTIFICATIONS = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)new DefaultSaveContext.Builder().suppressNotifications(false)).updateLastModifier(true).suppressEvents(false)).build();
    private final PageManager pageManager;
    private final PropertiesPublisher propertiesPublisher;
    private final SpaceManager spaceManager;
    private final AttachmentPublisher attachmentPublisher;
    private final LabelPublisher labelPublisher;
    private final ManifestManager manifestManager;
    private final ContentPropertyManager contentPropertyManager;
    private final AbstractPageService abstractPageService;
    private final EventPublisher eventPublisher;
    private final ContentPermissionManager contentPermissionManager;
    private final XhtmlContent xhtmlContent;
    private final InternalPublishingConfigurationManager publishingConfigurationManager;
    private InternalPublishingManager publishingManager;
    private DiagramPublicationService diagramPublicationService;
    private ApplicationContext context;
    private TransactionalHostContextAccessor transactionalHostContextAccessor;

    public DefaultPagePublisher(PageManager pageManager, PropertiesPublisher propertiesPublisher, SpaceManager spaceManager, AttachmentPublisher attachmentPublisher, LabelPublisher labelPublisher, ManifestManager manifestManager, ContentPropertyManager contentPropertyManager, AbstractPageService abstractPageService, EventPublisher eventPublisher, ContentPermissionManager contentPermissionManager, XhtmlContent xhtmlContent, InternalPublishingConfigurationManager publishingConfigurationManager, TransactionalHostContextAccessor transactionalHostContextAccessor) {
        this.pageManager = pageManager;
        EntityChange.setPageManager(pageManager);
        this.propertiesPublisher = propertiesPublisher;
        this.spaceManager = spaceManager;
        this.attachmentPublisher = attachmentPublisher;
        this.labelPublisher = labelPublisher;
        this.manifestManager = manifestManager;
        this.contentPropertyManager = contentPropertyManager;
        this.abstractPageService = abstractPageService;
        EntityChange.setAbstractPageService(abstractPageService);
        this.eventPublisher = eventPublisher;
        this.contentPermissionManager = contentPermissionManager;
        this.xhtmlContent = xhtmlContent;
        this.publishingConfigurationManager = publishingConfigurationManager;
        this.transactionalHostContextAccessor = transactionalHostContextAccessor;
    }

    public void afterPropertiesSet() throws Exception {
        this.publishingManager = (InternalPublishingManager)this.context.getBean("publishingManager", InternalPublishingManager.class);
        this.diagramPublicationService = (DiagramPublicationService)this.context.getBean("diagramPublicationService", DiagramPublicationService.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public PageChangeSet createChangeSet(AbstractPage source, AbstractPage destination, Map<PublishingOption, Boolean> spacePublishingOptions) {
        return this.createChangeSet(source, destination, spacePublishingOptions, false);
    }

    private PageChangeSet createChangeSet(AbstractPage source, AbstractPage destination, Map<PublishingOption, Boolean> spacePublishingOptions, boolean firstChangeOnly) {
        if (log.isDebugEnabled()) {
            log.debug("Creating Change set for source page: " + source + "     destination page: " + destination);
        }
        PageChangeSet changeSet = new PageChangeSet(spacePublishingOptions);
        if (spacePublishingOptions.get((Object)PublishingOption.IGNORE_TOPLEVELPAGES).booleanValue() && source instanceof Page && ((Page)source).getParent() == null) {
            return changeSet;
        }
        PublishManifest manifest = null;
        if (!spacePublishingOptions.get((Object)PublishingOption.COPY_SPACE).booleanValue()) {
            manifest = this.manifestManager.getManifest((ContentEntityObject)destination);
        }
        if (manifest != null && manifest.getSourceSpaceKey() != null && !manifest.getSourceSpaceKey().equals(source.getSpaceKey())) {
            log.warn(destination + " has already been published from space " + manifest.getSourceSpaceKey() + " and now will be published from space " + source.getSpaceKey());
            manifest = null;
        }
        int publishedVersion = 0;
        WorkflowsStateDelegate workflowsStateDelegate = new WorkflowsStateDelegate(this.context);
        if (spacePublishingOptions.get((Object)PublishingOption.PUBLISH_AWP_FINAL_STATE).booleanValue() && workflowsStateDelegate.isComalaWorkFlowsInstalled()) {
            boolean copyPropertiesEnabled;
            State finalPublishedState = workflowsStateDelegate.obtainWorkflowsState(source);
            if (finalPublishedState != null) {
                if (!this.finalPublishedVersionHasChanged(manifest, finalPublishedState.getContentVersion(), source, destination, spacePublishingOptions)) {
                    return changeSet;
                }
            } else {
                return changeSet;
            }
            publishedVersion = finalPublishedState.getContentVersion();
            if (publishedVersion != 0 && publishedVersion != source.getVersion() && (copyPropertiesEnabled = spacePublishingOptions.get((Object)PublishingOption.COPYPROPERTIES).booleanValue())) {
                changeSet.addChange(AbstractPageChange.create(source, 0L, 7, spacePublishingOptions, null));
                return changeSet;
            }
        }
        if (destination == null) {
            AbstractPageChange pageChange = AbstractPageChange.create(source, 0L, 1, spacePublishingOptions, null);
            changeSet.addChange(pageChange);
            if (firstChangeOnly) {
                return changeSet;
            }
            this.attachmentPublisher.createChangeLists(source, destination, pageChange, manifest, spacePublishingOptions);
        } else {
            AbstractPageChange change;
            if (destination.isDeleted()) {
                AbstractPageChange pageRestorationChange = AbstractPageChange.create(source, destination.getId(), 8, spacePublishingOptions, manifest);
                changeSet.addChange(pageRestorationChange);
                return changeSet;
            }
            if (spacePublishingOptions.get((Object)PublishingOption.IGNORE_MANIFEST).booleanValue() || manifest == null || !manifest.getSourceTitle().equals(source.getTitle()) || manifest.getSourceVersion() != source.getVersion() || manifest.getDestinationVersion() != destination.getVersion() || !this.haveSameParentAndPosition(source, destination, spacePublishingOptions) || this.isPublishedPageRestored(source, destination, spacePublishingOptions)) {
                AbstractPageChange pageUpdateChange = AbstractPageChange.create(source, destination.getId(), 3, spacePublishingOptions, manifest);
                changeSet.addChange(pageUpdateChange);
                if (firstChangeOnly) {
                    return changeSet;
                }
            }
            if (spacePublishingOptions.get((Object)PublishingOption.COPYLABELS).booleanValue() && this.labelPublisher.mustUpdateLabels((ContentEntityObject)source, (ContentEntityObject)destination, (boolean)spacePublishingOptions.get((Object)PublishingOption.EXACT_LABL_SYNC))) {
                AbstractPageChange labelsChange = AbstractPageChange.create(source, destination.getId(), 5, spacePublishingOptions, manifest);
                changeSet.addChange(labelsChange);
                if (firstChangeOnly) {
                    return changeSet;
                }
            }
            if ((change = changeSet.getChangeOfType(3)) == null) {
                change = AbstractPageChange.create(source, destination.getId(), 3, spacePublishingOptions, manifest);
                this.attachmentPublisher.createChangeLists(source, destination, change, manifest, spacePublishingOptions);
                if (change.getAttachmentChanges().size() > 0) {
                    changeSet.addChange(change);
                    if (firstChangeOnly) {
                        return changeSet;
                    }
                }
            } else {
                this.attachmentPublisher.createChangeLists(source, destination, change, manifest, spacePublishingOptions);
            }
            if (spacePublishingOptions.get((Object)PublishingOption.COPY_RESTRICTIONS).booleanValue() && this.isDifferentPermissionsSet(source, destination)) {
                AbstractPageChange propertiesChange = AbstractPageChange.create(source, destination.getId(), 6, spacePublishingOptions, manifest);
                changeSet.addChange(propertiesChange);
                if (firstChangeOnly) {
                    return changeSet;
                }
            }
            if (changeSet.getChangeOfType(1) == null && spacePublishingOptions.get((Object)PublishingOption.COPYPROPERTIES).booleanValue() && !this.propertiesPublisher.arePropertiesCopied((ContentEntityObject)source, (ContentEntityObject)destination)) {
                AbstractPageChange propertiesChange = AbstractPageChange.create(source, destination.getId(), 4, spacePublishingOptions, manifest);
                changeSet.addChange(propertiesChange);
                if (firstChangeOnly) {
                    return changeSet;
                }
            }
        }
        if (publishedVersion != 0) {
            for (EntityChange change : changeSet.getChanges()) {
                change.setVersion(publishedVersion);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(changeSet.toString());
        }
        return changeSet;
    }

    private boolean isPublishedPageRestored(AbstractPage source, AbstractPage destination, Map<PublishingOption, Boolean> spacePublishingOptions) {
        if (source instanceof BlogPost) {
            return false;
        }
        Page sourcePage = (Page)source;
        Page destPage = (Page)destination;
        if (sourcePage.getParent() != null) {
            Page publishedSourceParentPage = (Page)this.abstractPageService.loadByTypeAndSpace((AbstractPage)sourcePage.getParent(), destination.getSpace().getKey());
            if (spacePublishingOptions.get((Object)PublishingOption.IGNORE_TOPLEVELPAGES).booleanValue() && sourcePage.getParent().getParent() != null && publishedSourceParentPage != null && destPage.getParent() == null) {
                return true;
            }
            if (!spacePublishingOptions.get((Object)PublishingOption.IGNORE_TOPLEVELPAGES).booleanValue() && publishedSourceParentPage != null && destPage.getParent() == null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPageChanged(AbstractPage source, AbstractPage destination, Map<PublishingOption, Boolean> spacePublishingOptions) {
        spacePublishingOptions.put(PublishingOption.IGNORE_PARENT_AND_POSITION, true);
        PageChangeSet changeSet = this.createChangeSet(source, destination, spacePublishingOptions, true);
        return !changeSet.getChanges().isEmpty();
    }

    private boolean isDifferentPermissionsSet(AbstractPage source, AbstractPage destination) {
        List<ContentPermission> destinationPermissions;
        List<ContentPermission> sourcePermissions = this.getContentPermissions(source);
        return !sourcePermissions.equals(destinationPermissions = this.getContentPermissions(destination));
    }

    private List<ContentPermission> getContentPermissions(AbstractPage abstractPage) {
        ArrayList<ContentPermission> allContentPermissions = new ArrayList<ContentPermission>();
        ContentPermissionSet editPermissionSet = abstractPage.getContentPermissionSet("Edit");
        ContentPermissionSet viewPermissionSet = abstractPage.getContentPermissionSet("View");
        if (editPermissionSet != null) {
            allContentPermissions.addAll(editPermissionSet.getAllExcept(new ArrayList()));
        }
        if (viewPermissionSet != null) {
            allContentPermissions.addAll(viewPermissionSet.getAllExcept(new ArrayList()));
        }
        return allContentPermissions;
    }

    @Override
    public AbstractPage publish(AbstractPageChange pageChange, String sourceSpaceKey, String destinationSpaceKey, Date publishingDate) throws Exception {
        AbstractPage source = (AbstractPage)pageChange.getEntity(sourceSpaceKey);
        AbstractPage destination = (AbstractPage)pageChange.getDestEntity();
        if (source != null && !source.isCurrent()) {
            throw new Exception("source " + source + " is not current");
        }
        if (destination != null && !destination.isCurrent() && !destination.isDeleted()) {
            throw new Exception("destination " + destination + " is not current");
        }
        try {
            if (pageChange.isAdd()) {
                if ((destination = this.copyPage(source, destination, destinationSpaceKey, pageChange, publishingDate, pageChange.isOption(PublishingOption.SUPPRESS_NOTIFICATIONS))) == null) {
                    return null;
                }
                pageChange.setDestinationId(destination.getId());
                this.attachmentPublisher.publish(pageChange, sourceSpaceKey, destinationSpaceKey, publishingDate, this.diagramPublicationService);
                this.processPageAttributes(source, destination, pageChange);
                this.eventPublisher.publish((Object)new PageAddedPublishedEventImpl(destination, source, (User)AuthenticatedUserThreadLocal.get()));
                this.eventPublisher.publish((Object)new PagePublishPropertiesEvent(source, destination, sourceSpaceKey, destinationSpaceKey).getPayload());
                log.trace("AHP - added page and attachments {} ", (Object)((AbstractPage)pageChange.getDestEntity()).getTitle());
            } else {
                if (pageChange.isRestore()) {
                    this.restorePage(destination);
                    this.setParentAndPosition(source, destination);
                    this.eventPublisher.publish((Object)new PageRestoredPublishedEventImpl(destination, source, (User)AuthenticatedUserThreadLocal.get()));
                    return destination;
                }
                if (pageChange.isUpdate()) {
                    if (pageChange.isUpdateAttachments()) {
                        this.attachmentPublisher.publish(pageChange, sourceSpaceKey, destinationSpaceKey, publishingDate, this.diagramPublicationService);
                        this.eventPublisher.publish((Object)new PageAttachmentUpdatedPublishedEventImpl(destination, source, (User)AuthenticatedUserThreadLocal.get()));
                        log.trace("AHP - updated attachments {} ", (Object)((AbstractPage)pageChange.getDestEntity()).getTitle());
                    }
                    this.updatePage(source, destination, pageChange, publishingDate, pageChange.isOption(PublishingOption.SUPPRESS_NOTIFICATIONS));
                    this.processScaffoldData(source, destination, pageChange);
                    this.eventPublisher.publish((Object)new PageContentUpdatedPublishedEventImpl(destination, source, (User)AuthenticatedUserThreadLocal.get()));
                    this.eventPublisher.publish((Object)new PagePublishPropertiesEvent(source, destination, sourceSpaceKey, destinationSpaceKey).getPayload());
                    log.trace("AHP - updated page and attachments {} ", (Object)((AbstractPage)pageChange.getDestEntity()).getTitle());
                } else if (pageChange.isUpdateLabels()) {
                    this.labelPublisher.copyLabels((ContentEntityObject)source, (ContentEntityObject)destination, pageChange.isOption(PublishingOption.EXACT_LABL_SYNC));
                    this.processScaffoldData(source, destination, pageChange);
                    if (!pageChange.isOption(PublishingOption.COPY_SPACE)) {
                        return destination;
                    }
                    this.eventPublisher.publish((Object)new PageLabelUpdatedPublishedEventImpl(destination, source, (User)AuthenticatedUserThreadLocal.get()));
                    log.trace("AHP - updated labels {}", (Object)((AbstractPage)pageChange.getDestEntity()).getTitle());
                } else if (pageChange.isUpdateRestrictions()) {
                    this.copyRestrictions(source, destination, pageChange);
                    if (!pageChange.isOption(PublishingOption.COPY_SPACE)) {
                        return destination;
                    }
                    this.eventPublisher.publish((Object)new PageRestrictionsUpdatedPublishedEventImpl(destination, source, (User)AuthenticatedUserThreadLocal.get()));
                    log.trace("AHP - updated restrictions,{}", (Object)((AbstractPage)pageChange.getDestEntity()).getTitle());
                } else if (pageChange.isUpdateProperties() && pageChange.isOption(PublishingOption.COPYPROPERTIES)) {
                    this.propertiesPublisher.copyProperties((ContentEntityObject)source, (ContentEntityObject)destination);
                    this.eventPublisher.publish((Object)new PagePropertiesUpdatedPublishedEventImpl(destination, source, (User)AuthenticatedUserThreadLocal.get()));
                    log.trace("AHP - updated content properties,{} ", (Object)((AbstractPage)pageChange.getDestEntity()).getTitle());
                    if (!pageChange.isOption(PublishingOption.COPY_SPACE)) {
                        return destination;
                    }
                } else if (pageChange.isDelete()) {
                    this.trashPage(destination);
                    this.eventPublisher.publish((Object)new PageDeletedPublishedEventImpl(destination, source, (User)AuthenticatedUserThreadLocal.get()));
                    return destination;
                }
            }
            if (pageChange.isOption(PublishingOption.COPYLABELS)) {
                this.labelPublisher.copyLabels((ContentEntityObject)source, (ContentEntityObject)destination, pageChange.isOption(PublishingOption.EXACT_LABL_SYNC));
            }
            try {
                if (pageChange.isOption(PublishingOption.COPY_SPACE)) {
                    if (pageChange.isOption(PublishingOption.COPY_FOR_PUBLISHING)) {
                        this.publishingManager.setPublishedPageId(source, destination.getId());
                        this.manifestManager.setManifest(destination, source);
                    }
                } else {
                    this.publishingManager.setPublishedPageId(source, destination.getId());
                    this.manifestManager.setManifest(source, destination);
                }
                log.trace("AHP - updated manifest {}", (Object)((AbstractPage)pageChange.getDestEntity()).getTitle());
            }
            catch (PublishingException e) {
                log.debug("{} {}", (Object)pageChange, (Object)e);
                log.warn("{} {}", (Object)e.getMessage(), (Object)pageChange);
            }
            return destination;
        }
        catch (PublishingException e) {
            throw e;
        }
        catch (Exception e) {
            MDC.put((String)"Page change name", (String)pageChange.getName());
            MDC.put((String)"Page change type", (String)Integer.toString(pageChange.getType()));
            if (source != null) {
                MDC.put((String)"Source", (String)source.toString());
            }
            if (destination != null) {
                MDC.put((String)"Destination", (String)destination.toString());
            }
            throw e;
        }
    }

    @Override
    public AbstractPage publish(PageChangeSet pageChangeSet, String sourceSpaceKey, String destinationSpaceKey, Date publishingDate) throws Exception {
        AbstractPage page = null;
        PageUpdatedPublishedEventImpl pageUpdatedEvt = null;
        for (AbstractPageChange change : pageChangeSet.getPageChanges()) {
            Object transactionResponse = this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRED, TransactionalHostContextAccessor.Permission.READ_WRITE, () -> {
                try {
                    return this.publish(change, sourceSpaceKey, destinationSpaceKey, publishingDate);
                }
                catch (Exception e) {
                    return e;
                }
            });
            if (transactionResponse instanceof AbstractPage) {
                page = (AbstractPage)transactionResponse;
                if (pageUpdatedEvt != null || !this.isPageUpdatedEventReleasedWith(change)) continue;
                AbstractPage pageSource = (AbstractPage)change.getEntity(sourceSpaceKey);
                AbstractPage destination = (AbstractPage)change.getDestEntity();
                pageUpdatedEvt = new PageUpdatedPublishedEventImpl(destination, pageSource, (User)AuthenticatedUserThreadLocal.get());
                continue;
            }
            if (!(transactionResponse instanceof Exception)) continue;
            throw (Exception)transactionResponse;
        }
        if (pageUpdatedEvt != null) {
            this.eventPublisher.publish(pageUpdatedEvt);
        }
        return page;
    }

    @Override
    public boolean isPageUpdatedEventReleasedWith(AbstractPageChange pageChange) {
        return pageChange.isUpdate() || pageChange.isOption(PublishingOption.COPY_SPACE) && (pageChange.isUpdateLabels() || pageChange.isUpdateRestrictions()) || pageChange.isUpdateProperties() && pageChange.isOption(PublishingOption.COPYPROPERTIES);
    }

    private void processPageAttributes(AbstractPage source, AbstractPage destination, AbstractPageChange pageChangeSet) {
        if (pageChangeSet.isOption(PublishingOption.COPYPROPERTIES)) {
            this.propertiesPublisher.copyProperties((ContentEntityObject)source, (ContentEntityObject)destination);
        }
        this.processScaffoldData(source, destination, pageChangeSet);
    }

    private void processScaffoldData(AbstractPage source, AbstractPage destination, AbstractPageChange pageChangeSet) {
        if (pageChangeSet.isOption(PublishingOption.COPYSCAFFOLDDATA) && ScaffoldingIntegration.isEnabled()) {
            ScaffoldingIntegration.copyScaffoldData(source, destination);
        }
    }

    private void processPageContent(AbstractPage source, AbstractPage destination, AbstractPageChange pageChange) {
        if (pageChange.getVersionComment() != null && destination instanceof Page) {
            destination.setVersionComment(pageChange.getVersionComment());
        } else if (pageChange.isOption(PublishingOption.COPYVERSIONCOMMENTS) && destination instanceof Page) {
            this.copyVersionComments(source, destination);
        }
    }

    private void copyVersionComments(AbstractPage source, AbstractPage destination) {
        destination.setVersionComment(source.getVersionComment());
    }

    private void trashPage(AbstractPage page) {
        this.pageManager.trashPage(page, DefaultDeleteContext.DEFAULT);
    }

    private void restorePage(AbstractPage page) {
        this.pageManager.restorePage(page);
    }

    private AbstractPage copyPage(AbstractPage source, AbstractPage destination, String destinationSpaceKey, AbstractPageChange pageChangeSet, Date publishingDate, boolean suppressNotifications) {
        if (source == null) {
            log.error("source " + pageChangeSet.getName() + " should not be null in copyPage");
            return null;
        }
        if (destination != null) {
            log.warn(destination.toString() + (destination.isCurrent() ? "" : "(not current)") + " was marked for copy but it exists in " + destination.getSpaceKey() + " source page is " + source.toString() + (source.isCurrent() ? "" : "(not current)"));
            this.updatePage(source, destination, pageChangeSet, publishingDate, suppressNotifications);
            return destination;
        }
        destination = this.abstractPageService.createNewInstanceOf(source);
        destination.setTitle(source.getTitle());
        destination.setSpace(this.spaceManager.getSpace(destinationSpaceKey));
        Map<PublishingOption, Boolean> spacePublishingOptions = pageChangeSet.getSpacePublishingOptions();
        BodyContent updatedBodyContent = this.getUpdatedBodyContent(source, destination, spacePublishingOptions.get((Object)PublishingOption.COPY_SPACE));
        destination.setBodyContent(updatedBodyContent);
        this.processPageContent(source, destination, pageChangeSet);
        DefaultSaveContext saveContext = suppressNotifications ? this.PUBLISH_SAVE_CONTEXT : this.PUBLISH_SAVE_CONTEXT_WITH_NOTIFICATIONS;
        this.pageManager.saveContentEntity((ContentEntityObject)destination, (SaveContext)saveContext);
        if (!pageChangeSet.getSpacePublishingOptions().get((Object)PublishingOption.USE_PUBLISHING_DATE).booleanValue()) {
            publishingDate = null;
        }
        this.copyRestrictions(source, destination, pageChangeSet);
        this.copyEntityCreatedMetaData((ConfluenceEntityObject)source, (ConfluenceEntityObject)destination, publishingDate);
        this.copyEntityUpdatedMetadata((ConfluenceEntityObject)source, (ConfluenceEntityObject)destination, publishingDate);
        this.copyExcerpt(source, destination);
        this.setParentAndPosition(source, destination);
        return destination;
    }

    private void copyRestrictions(AbstractPage source, AbstractPage destination, AbstractPageChange pageChange) {
        Map<PublishingOption, Boolean> spacePublishingOptions = pageChange.getSpacePublishingOptions();
        if (spacePublishingOptions.get((Object)PublishingOption.COPY_RESTRICTIONS).booleanValue() && destination != null) {
            HashSet<ContentPermission> newContentViewPermissions = new HashSet<ContentPermission>();
            HashSet<ContentPermission> newContentEditPermissions = new HashSet<ContentPermission>();
            List<ContentPermission> sourcePermissions = this.getContentPermissions(source);
            for (ContentPermission permission : sourcePermissions) {
                ContentPermission newPermission;
                ContentPermission contentPermission = newPermission = permission.isGroupPermission() ? ContentPermission.createGroupPermission((String)permission.getType(), (String)permission.getGroupName()) : ContentPermission.createUserPermission((String)permission.getType(), (ConfluenceUser)permission.getUserSubject());
                if (newPermission.getType().equals("View")) {
                    newContentViewPermissions.add(newPermission);
                    continue;
                }
                newContentEditPermissions.add(newPermission);
            }
            this.contentPermissionManager.setContentPermissions(newContentViewPermissions, (ContentEntityObject)destination, "View");
            this.contentPermissionManager.setContentPermissions(newContentEditPermissions, (ContentEntityObject)destination, "Edit");
        }
    }

    private BodyContent getUpdatedBodyContent(AbstractPage source, AbstractPage destination, boolean isSpaceCopy) {
        BodyContent bodyContent = source.getBodyContent();
        if (destination != null && source != null) {
            String bodyStr = source.getBodyContent().getBody();
            if (this.diagramPublicationService.isDiagramMacro(bodyStr, body -> body.contains("ac:name=\"drawio\"")) || this.diagramPublicationService.isDiagramMacro(bodyStr, body -> body.contains("ac:name=\"gliffy\""))) {
                bodyStr = this.diagramPublicationService.updateAttachmentMacrosVersionOnDestination(source, destination, bodyStr);
            }
            if (!isSpaceCopy && bodyStr.contains("ac:name=\"ignore-publishing\"")) {
                bodyStr = this.removeIgnorePublishingMacroContent(bodyStr, (ConversionContext)new DefaultConversionContext((RenderContext)source.toPageContext()));
            }
            String sourceSpaceKey = source.getSpaceKey();
            String destSpaceKey = destination.getSpaceKey();
            bodyStr = bodyStr.replace(this.getSpaceKeyParam(sourceSpaceKey), this.getSpaceKeyParam(destSpaceKey));
            bodyStr = bodyStr.replace(this.getSpaceKeyMacroParamOldStyle(sourceSpaceKey), this.getSpaceKeyMacroParamOldStyle(destSpaceKey));
            bodyContent.setBody(bodyStr);
        }
        return bodyContent;
    }

    private String removeIgnorePublishingMacroContent(String bodyContent, ConversionContext conversionContext) {
        try {
            return this.xhtmlContent.replaceMacroDefinitionsWithString(bodyContent, conversionContext, macroDefinition -> {
                if (IGNORE_PUBLISHING_MACRO_NAME.equals(macroDefinition.getName())) {
                    return "";
                }
                return this.xhtmlContent.convertMacroDefinitionToStorage(macroDefinition, conversionContext);
            });
        }
        catch (XhtmlException e) {
            if (log.isDebugEnabled()) {
                log.debug("XhtmlException while trying to remove content inside the Ignore Publishing macro." + e.getMessage());
            }
            return bodyContent;
        }
    }

    private String getSpaceKeyParam(String spaceKey) {
        String spaceKeyParam = "ri:space-key=\"" + spaceKey + "\"";
        return spaceKeyParam;
    }

    private String getSpaceKeyMacroParamOldStyle(String spaceKey) {
        String spaceKeyParam = "<ac:parameter ac:name=\"spaceKey\">" + spaceKey + "</ac:parameter>";
        return spaceKeyParam;
    }

    private void updatePage(AbstractPage source, AbstractPage destination, AbstractPageChange pageChangeSet, Date publishingDate, boolean suppressNotifications) {
        Map<PublishingOption, Boolean> spacePublishingOptions = pageChangeSet.getSpacePublishingOptions();
        if (spacePublishingOptions.get((Object)PublishingOption.OVERRIDE_CONTENT).booleanValue()) {
            if (!destination.getTitle().equals(source.getTitle())) {
                destination.setTitle(source.getTitle());
            }
            destination.setBodyContent(this.getUpdatedBodyContent(source, destination, spacePublishingOptions.get((Object)PublishingOption.COPY_SPACE)));
            DefaultSaveContext saveContext = suppressNotifications ? this.PUBLISH_OVERRIDE_CONTEXT : this.PUBLISH_OVERRIDE_CONTEXT_WITH_NOTIFICATIONS;
            this.pageManager.saveContentEntity((ContentEntityObject)destination, (SaveContext)saveContext);
        } else {
            DefaultSaveContext saveContext = suppressNotifications ? this.PUBLISH_SAVE_CONTEXT : this.PUBLISH_SAVE_CONTEXT_WITH_NOTIFICATIONS;
            this.pageManager.saveNewVersion((ContentEntityObject)destination, page -> {
                page.setBodyContent(this.getUpdatedBodyContent(source, destination, (Boolean)spacePublishingOptions.get((Object)PublishingOption.COPY_SPACE)));
                page.setTitle(source.getTitle());
                this.processPageContent(source, (AbstractPage)page, pageChangeSet);
            }, (SaveContext)saveContext);
        }
        if (!pageChangeSet.getSpacePublishingOptions().get((Object)PublishingOption.USE_PUBLISHING_DATE).booleanValue()) {
            publishingDate = null;
        }
        this.copyRestrictions(source, destination, pageChangeSet);
        this.copyEntityUpdatedMetadata((ConfluenceEntityObject)source, (ConfluenceEntityObject)destination, publishingDate);
        this.copyExcerpt(source, destination);
        this.setParentAndPosition(source, destination);
    }

    private void copyExcerpt(AbstractPage source, AbstractPage destination) {
        String excerpt = this.contentPropertyManager.getTextProperty((ContentEntityObject)source, EXCERPT_KEY);
        if (!TextUtils.stringSet((String)excerpt)) {
            this.contentPropertyManager.setTextProperty((ContentEntityObject)destination, EXCERPT_KEY, excerpt);
        }
    }

    protected void setParentAndPosition(AbstractPage source, AbstractPage destination) {
        if (!(source instanceof Page)) {
            return;
        }
        Integer sourcePosition = ((Page)source).getPosition();
        Page sourceParentPage = ((Page)source.getLatestVersion()).getParent();
        Page destinationPage = (Page)destination;
        Page originalDestinationParent = destinationPage.getParent();
        if (sourceParentPage != null) {
            long destinationParentId = this.publishingManager.getPublishedPageId((AbstractPage)sourceParentPage, destination.getSpaceKey());
            AbstractPage destinationParent = this.abstractPageService.loadById(destinationParentId);
            if (destinationParent == null) {
                destinationParent = this.abstractPageService.loadByTypeAndSpace((AbstractPage)sourceParentPage, destination.getSpaceKey());
            }
            if (destinationParent != null && (destinationPage.getParent() == null || destinationPage.getParent().getId() != destinationParent.getId())) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Parent %s:%s added child %s:%s", destinationParent.getTitle(), destinationParent.getId(), destination.getTitle(), destination.getId()));
                }
                if (originalDestinationParent != null) {
                    originalDestinationParent.removeChild(destinationPage);
                }
                ((Page)destinationParent).addChild(destinationPage);
            }
            if (destinationParent != null) {
                this.sortChildren(sourceParentPage, (Page)destinationParent, destination.getSpaceKey());
            }
        } else if (destinationPage.getParent() != null) {
            Page parentPage = destinationPage.getParent();
            parentPage.removeChild(destinationPage);
        } else if (sourcePosition != null) {
            ((Page)destination).setPosition(sourcePosition);
        }
        this.linkChildPages(destinationPage, ((Page)source).getSortedChildren());
        this.sortChildren((Page)source, destinationPage, destination.getSpaceKey());
    }

    protected void sortChildren(Page sourcePage, Page destinationPage, String destinationSpaceKey) {
        if (sourcePage != null && destinationPage != null) {
            List sourceChildren = sourcePage.getSortedChildren();
            if (sourceChildren == null || sourceChildren.size() == 0) {
                return;
            }
            if (this.isChildrenSorted(sourcePage)) {
                List<Long> destChildIds = this.getOrderedDestChildrenIds(destinationPage, sourceChildren);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Parent %s:%s set children with order %s", destinationPage.getTitle(), destinationPage.getId(), destChildIds));
                }
                this.pageManager.setChildPageOrder(destinationPage, destChildIds);
            } else if (this.isChildrenSorted(destinationPage)) {
                this.pageManager.revertChildPageOrder(destinationPage);
            }
        }
    }

    private void linkChildPages(Page destinationPage, List<Page> sourceChildren) {
        for (Page sourceChild : sourceChildren) {
            Page destChild = this.pageManager.getPage(destinationPage.getSpaceKey(), sourceChild.getTitle());
            if (destChild == null || destChild.getParent() != null && destChild.getParent().getId() == destinationPage.getId()) continue;
            destChild.setParentPage(destinationPage);
        }
    }

    private List<Long> getOrderedDestChildrenIds(Page destinationPage, List<Page> orderedSourceChildren) {
        ArrayList destChildIds = Lists.newArrayList();
        for (Page sourceChild : orderedSourceChildren) {
            Page destChild = this.pageManager.getPage(destinationPage.getSpaceKey(), sourceChild.getTitle());
            if (destChild == null) continue;
            destChildIds.add(destChild.getId());
        }
        return destChildIds;
    }

    private boolean isChildrenSorted(Page page) {
        List children = page.getSortedChildren();
        return children != null && children.size() >= 1 && ((Page)children.get(0)).getPosition() != null;
    }

    private boolean finalPublishedVersionHasChanged(PublishManifest manifest, int finalPublishedStateVersion, AbstractPage source, AbstractPage destination, Map<PublishingOption, Boolean> spacePublishingOptions) {
        boolean isFinalPublishedVersionNewer = manifest == null || manifest.getSourceVersion() != finalPublishedStateVersion;
        boolean isNonVersionedDataChanged = false;
        if (!isFinalPublishedVersionNewer && destination != null && source.getVersion() == finalPublishedStateVersion) {
            isNonVersionedDataChanged = !this.haveSameParentAndPosition(source, destination, spacePublishingOptions) || this.labelPublisher.mustUpdateLabels((ContentEntityObject)source, (ContentEntityObject)destination, (boolean)spacePublishingOptions.get((Object)PublishingOption.EXACT_LABL_SYNC)) || this.isDifferentPermissionsSet(source, destination);
        }
        return isFinalPublishedVersionNewer || isNonVersionedDataChanged;
    }

    private boolean haveSameParentAndPosition(AbstractPage source, AbstractPage dest, Map<PublishingOption, Boolean> spacePublishingOptions) {
        boolean isTopLevelAndSamePosition;
        if (spacePublishingOptions.get((Object)PublishingOption.IGNORE_PARENT_AND_POSITION).booleanValue()) {
            return true;
        }
        if (source instanceof BlogPost) {
            return true;
        }
        Page sourcePage = (Page)source;
        Page destPage = (Page)dest;
        PublishManifest destParentManifest = null;
        if (destPage.getParent() != null) {
            destParentManifest = this.manifestManager.getManifest((ContentEntityObject)destPage.getParent());
        }
        boolean bl = isTopLevelAndSamePosition = sourcePage.getParent() == null && destPage.getParent() == null && this.haveSamePosition(sourcePage, destPage);
        if (isTopLevelAndSamePosition) {
            return isTopLevelAndSamePosition;
        }
        if (sourcePage.getParent() != null && destPage.getParent() == null && this.haveSamePosition(sourcePage, destPage)) {
            return true;
        }
        String labelName = this.publishingConfigurationManager.getPublishingLabel();
        if (!spacePublishingOptions.get((Object)PublishingOption.SYNC_LABEL_IGNORE).booleanValue() && StringUtils.isNotBlank((CharSequence)labelName) && sourcePage.getParent() != null && destPage.getParent() == null && !sourcePage.getParent().getLabels().contains(labelName)) {
            return true;
        }
        return sourcePage.getParent() != null && destPage.getParent() != null && destParentManifest != null && sourcePage.getParent().getId() == destParentManifest.getSourceId() && this.haveSamePosition(sourcePage, destPage);
    }

    private boolean haveSamePosition(Page sourcePage, Page destPage) {
        if (sourcePage.getPosition() == null && destPage.getPosition() == null) {
            return true;
        }
        List<Long> sourceSiblingsIds = this.getSortedSiblingIds(sourcePage);
        List<Long> destSiblingsIds = this.getSortedDraftSiblingIds(destPage);
        if (log.isDebugEnabled()) {
            log.debug("soucePage: " + sourcePage + " siblingIds: " + sourceSiblingsIds);
            log.debug("destPage: " + destPage + " draftSiblingIds: " + destSiblingsIds);
        }
        List sourceDestInter = ListUtils.intersection(sourceSiblingsIds, destSiblingsIds);
        List destSourceInter = ListUtils.intersection(destSiblingsIds, sourceSiblingsIds);
        if (sourceDestInter.size() == destSourceInter.size() && sourceDestInter.contains(sourcePage.getId()) && destSourceInter.contains(sourcePage.getId())) {
            for (int i = 0; i < sourceDestInter.size(); ++i) {
                if (((Long)sourceDestInter.get(i)).longValue() != sourcePage.getId()) continue;
                return ((Long)destSourceInter.get(i)).longValue() == sourcePage.getId();
            }
        }
        return false;
    }

    private List<Long> getSortedSiblingIds(Page page) {
        Page parent = page.getParent();
        List<Page> siblings = parent != null ? parent.getSortedChildren() : this.getSortedTopPages(page.getSpace());
        ArrayList<Long> siblingIds = new ArrayList<Long>(siblings.size());
        for (Page sibling : siblings) {
            siblingIds.add(sibling.getId());
        }
        return siblingIds;
    }

    private List<Page> getSortedTopPages(Space space) {
        List topPages = this.pageManager.getTopLevelPages(space);
        Collections.sort(topPages, new ChildPositionComparator());
        return topPages;
    }

    private List<Long> getSortedDraftSiblingIds(Page publishedPage) {
        Page publishedPageParent = publishedPage.getParent();
        List<Page> siblings = publishedPageParent != null ? publishedPageParent.getSortedChildren() : this.getSortedTopPages(publishedPage.getSpace());
        ArrayList<Long> siblingIds = new ArrayList<Long>(siblings.size());
        for (Page sibling : siblings) {
            long draftSiblingId = this.publishingManager.getDraftPageId((AbstractPage)sibling);
            if (draftSiblingId <= 0L) continue;
            siblingIds.add(draftSiblingId);
        }
        return siblingIds;
    }
}

