/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing;

import com.atlassian.confluence.compat.setup.xstream.XStreamManagerCompat;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.comalatech.confluence.publishing.ManifestManager;
import com.comalatech.confluence.publishing.PublishingException;
import com.comalatech.confluence.publishing.model.AttachmentManifest;
import com.comalatech.confluence.publishing.model.PublishManifest;
import com.comalatech.confluence.publishing.utils.PluginContainerManager;
import com.opensymphony.util.TextUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManifestManager
implements ManifestManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultManifestManager.class);
    public static final String MANIFEST_KEY = "com.comalatech.publishing.manifest";
    private final ContentPropertyManager contentPropertyManager;
    private final AttachmentManager attachmentManager;
    private XStreamManagerCompat xStreamManagerCompat;

    public DefaultManifestManager(ContentPropertyManager contentPropertyManager, AttachmentManager attachmentManager) {
        this.contentPropertyManager = contentPropertyManager;
        this.attachmentManager = attachmentManager;
    }

    @Override
    public PublishManifest getManifest(ContentEntityObject ceo) {
        if (ceo == null) {
            return null;
        }
        String raw = this.contentPropertyManager.getTextProperty(ceo, MANIFEST_KEY);
        if (!TextUtils.stringSet((String)raw)) {
            return null;
        }
        raw = this.upgradeTo1point3(raw);
        if (this.xStreamManagerCompat == null) {
            this.initXStreamManagerCompat();
        }
        PublishManifest manifest = (PublishManifest)this.xStreamManagerCompat.fromXML(raw);
        if (log.isDebugEnabled()) {
            log.debug(manifest.toString());
        }
        manifest.setCurrentDestinationVersion(ceo.getVersion());
        return manifest;
    }

    private String upgradeTo1point3(String raw) {
        raw = raw.replaceAll("com.comalatech.confluence.publishing.model.PublishManifest-AttachmentManifest", "AttachmentManifest");
        raw = raw.replaceAll("<outer-class reference=\"../../..\"/>", "");
        return raw;
    }

    private PublishManifest createManifest(AbstractPage source, AbstractPage destination) throws PublishingException {
        PublishManifest manifest = new PublishManifest(source, destination);
        List attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)source);
        AttachmentManifest[] attachmentsManifests = new AttachmentManifest[attachments.size()];
        int i = 0;
        for (Attachment attachment : attachments) {
            Attachment destinationAttachment = this.attachmentManager.getAttachment((ContentEntityObject)destination, attachment.getFileName());
            if (destinationAttachment == null) {
                throw new PublishingException("There is no attachment named " + attachment.getFileName() + " in " + destination.getSpaceKey() + ":" + destination);
            }
            attachmentsManifests[i] = manifest.createAttachmentManifest(attachment.getFileName(), attachment.getVersion(), destinationAttachment.getVersion());
            ++i;
        }
        manifest.setAttachmentsManifests(attachmentsManifests);
        return manifest;
    }

    @Override
    public void setManifest(AbstractPage source, AbstractPage destination) throws PublishingException {
        PublishManifest manifest = this.createManifest(source, destination);
        if (log.isDebugEnabled()) {
            log.debug(manifest.toString());
        }
        if (this.xStreamManagerCompat == null) {
            this.initXStreamManagerCompat();
        }
        this.contentPropertyManager.setTextProperty((ContentEntityObject)destination, MANIFEST_KEY, this.xStreamManagerCompat.toXML((Object)manifest));
    }

    private void initXStreamManagerCompat() {
        this.xStreamManagerCompat = PluginContainerManager.getComponent("xStreamManagerCompat", XStreamManagerCompat.class);
        if (this.xStreamManagerCompat != null) {
            this.xStreamManagerCompat.alias("Manifest", PublishManifest.class);
            this.xStreamManagerCompat.alias("AttachmentManifest", AttachmentManifest.class);
        } else {
            log.error("Could not load XStream Manager Compat.");
        }
    }
}

