/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing;

import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import com.comalatech.confluence.publishing.LabelPublisher;
import java.util.ArrayList;
import java.util.List;

public class DefaultLabelPublisher
implements LabelPublisher {
    private final LabelManager labelManager;
    private final InternalPublishingConfigurationManager publishingConfigurationManager;

    public DefaultLabelPublisher(LabelManager labelManager, InternalPublishingConfigurationManager publishingConfigurationManager) {
        this.labelManager = labelManager;
        this.publishingConfigurationManager = publishingConfigurationManager;
    }

    @Override
    public boolean mustUpdateLabels(ContentEntityObject source, ContentEntityObject destination, boolean doExactLabelSync) {
        return this.mustUpdateLabels((AbstractLabelableEntityObject)source, (AbstractLabelableEntityObject)destination, doExactLabelSync);
    }

    @Override
    public boolean mustUpdateLabels(AbstractLabelableEntityObject source, AbstractLabelableEntityObject destination, boolean doExactLabelSync) {
        List sourceLabels = source.getLabels();
        if (destination == null) {
            return sourceLabels.size() != 0;
        }
        List destinationLabels = destination.getLabels();
        if (doExactLabelSync) {
            List<Label> notPersonalDestinationLabels;
            List<Label> notPersonalSourceLabels = this.getNotPersonalLabels(sourceLabels);
            List<Label> changed = this.notIdentical(notPersonalSourceLabels, notPersonalDestinationLabels = this.getNotPersonalLabels(destinationLabels));
            return changed.size() > 0;
        }
        for (Object sourceLabel : sourceLabels) {
            Label label = (Label)sourceLabel;
            if (label.getNamespace().equals((Object)Namespace.PERSONAL) || label.getName().equals(this.publishingConfigurationManager.getPublishingLabel()) || destinationLabels.contains(label)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean copyLabels(ContentEntityObject source, ContentEntityObject destination, boolean doExactLabelSync) {
        boolean labelsChanged = false;
        List sourceLabels = source.getLabels();
        if (doExactLabelSync) {
            List<Label> notPersonalSourceLabels = this.getNotPersonalLabels(sourceLabels);
            List<Label> notPersonalDestinationLabels = this.getNotPersonalLabels(destination.getLabels());
            List<Label> toAddInDest = this.onlyInFirstList(notPersonalSourceLabels, notPersonalDestinationLabels);
            List<Label> toDelInDest = this.onlyInFirstList(notPersonalDestinationLabels, notPersonalSourceLabels);
            boolean changed = toAddInDest.size() + toDelInDest.size() > 0;
            this.addLabels(destination, toAddInDest);
            this.deleteLabels(destination, toDelInDest);
            return changed;
        }
        for (Label label : sourceLabels) {
            if (label.getNamespace().equals((Object)Namespace.PERSONAL) || label.getName().equals(this.publishingConfigurationManager.getPublishingLabel())) continue;
            labelsChanged = this.labelManager.addLabel((Labelable)destination, label) != 0 || labelsChanged;
        }
        return labelsChanged;
    }

    private List<Label> getNotPersonalLabels(List sourceLabels) {
        ArrayList<Label> globalSourceLabels = new ArrayList<Label>();
        for (Label label : sourceLabels) {
            if (label.getNamespace().equals((Object)Namespace.PERSONAL) || label.getName().equals(this.publishingConfigurationManager.getPublishingLabel())) continue;
            globalSourceLabels.add(label);
        }
        return globalSourceLabels;
    }

    private List<Label> notIdentical(List<Label> list1, List<Label> list2) {
        ArrayList<Label> result = new ArrayList<Label>();
        result.addAll(this.onlyInFirstList(list1, list2));
        result.addAll(this.onlyInFirstList(list2, list1));
        return result;
    }

    private List<Label> onlyInFirstList(List<Label> list1, List<Label> list2) {
        ArrayList<Label> result = new ArrayList<Label>();
        for (Label entry : list1) {
            boolean isAlsoInOtherList = this.listContainsLabel(list2, entry);
            if (isAlsoInOtherList) continue;
            result.add(entry);
        }
        return result;
    }

    private boolean listContainsLabel(List<Label> list, Label toSearchFor) {
        for (Label entry : list) {
            if (!entry.getName().equals(toSearchFor.getName())) continue;
            return true;
        }
        return false;
    }

    private void deleteLabels(ContentEntityObject destination, List<Label> toDelete) {
        this.labelManager.removeLabels((Labelable)destination, toDelete);
    }

    private void addLabels(ContentEntityObject destination, List<Label> toAdd) {
        for (Label entry : toAdd) {
            this.labelManager.addLabel((Labelable)destination, entry);
        }
    }
}

