/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.publishing;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import com.comalatech.confluence.publishing.AbstractEntityPublisher;
import com.comalatech.confluence.publishing.AttachmentPublisher;
import com.comalatech.confluence.publishing.InternalPublishingConfigurationManager;
import com.comalatech.confluence.publishing.LabelPublisher;
import com.comalatech.confluence.publishing.PublishingException;
import com.comalatech.confluence.publishing.diagrams.DiagramPublicationService;
import com.comalatech.confluence.publishing.model.AbstractPageChange;
import com.comalatech.confluence.publishing.model.AttachmentEntityChange;
import com.comalatech.confluence.publishing.model.AttachmentManifest;
import com.comalatech.confluence.publishing.model.EntityChange;
import com.comalatech.confluence.publishing.model.PublishManifest;
import com.comalatech.confluence.publishing.model.PublishingOption;
import com.comalatech.confluence.publishing.utils.DarkFeatureKeys;
import com.comalatech.confluence.publishing.utils.WorkflowsStateDelegate;
import com.comalatech.workflow.model.AttachmentVersion;
import com.comalatech.workflow.model.State;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultAttachmentPublisher
extends AbstractEntityPublisher
implements AttachmentPublisher,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultAttachmentPublisher.class);
    private final AttachmentManager attachmentManager;
    private final ConfluenceIndexer indexer;
    private final LabelPublisher labelPublisher;
    private final LabelManager labelManager;
    private ApplicationContext context;
    private final DarkFeaturesManager darkFeaturesManager;
    private final InternalPublishingConfigurationManager publishingConfigurationManager;
    private final TransactionalHostContextAccessor transactionalHostContextAccessor;

    public DefaultAttachmentPublisher(AttachmentManager attachmentManager, ConfluenceIndexer indexer, LabelPublisher labelPublisher, LabelManager labelManager, DarkFeaturesManager darkFeaturesManager, InternalPublishingConfigurationManager publishingConfigurationManager, TransactionalHostContextAccessor transactionalHostContextAccessor) {
        this.attachmentManager = attachmentManager;
        this.indexer = indexer;
        this.labelPublisher = labelPublisher;
        this.labelManager = labelManager;
        this.darkFeaturesManager = darkFeaturesManager;
        this.publishingConfigurationManager = publishingConfigurationManager;
        this.transactionalHostContextAccessor = transactionalHostContextAccessor;
        AttachmentEntityChange.setAttachmentManager(attachmentManager);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public void createChangeLists(AbstractPage source, AbstractPage destination, AbstractPageChange pageChange, PublishManifest manifest, Map<PublishingOption, Boolean> publishingOptions) {
        this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRED, TransactionalHostContextAccessor.Permission.READ_ONLY, () -> {
            this.internalCreateChangeLists(source, destination, pageChange, manifest, publishingOptions);
            return null;
        });
    }

    private void internalCreateChangeLists(AbstractPage source, AbstractPage destination, AbstractPageChange pageChange, PublishManifest manifest, Map<PublishingOption, Boolean> publishingOptions) {
        if (manifest == null) {
            this.createNewChanges(pageChange, source, destination, publishingOptions);
            return;
        }
        ArrayList<AttachmentEntityChange> changes = new ArrayList<AttachmentEntityChange>();
        Object[] attachmentsManifests = manifest.getAttachmentsManifests();
        List<Attachment> sourceAttachments = this.getVersionedAttachments(source, publishingOptions);
        int i = 0;
        Object[] attachmentNames = new String[sourceAttachments.size()];
        for (Attachment sourceAttachment : sourceAttachments) {
            attachmentNames[i] = sourceAttachment.getFileName();
            int ix = Arrays.binarySearch(attachmentsManifests, sourceAttachment.getFileName());
            Attachment destinationAttachment = this.attachmentManager.getAttachment((ContentEntityObject)destination, sourceAttachment.getFileName());
            if (destinationAttachment == null) {
                changes.add(pageChange.createAttachmentEntityChange(source, sourceAttachment.getFileName(), sourceAttachment.getVersion(), 1));
            } else if (ix < 0 || sourceAttachment.getVersion() != ((AttachmentManifest)attachmentsManifests[ix]).getVersion() || destinationAttachment.getVersion() != ((AttachmentManifest)attachmentsManifests[ix]).getDestinationVersion() || this.needToUpdateDestinationAttachment(sourceAttachment, destinationAttachment, source)) {
                changes.add(pageChange.createAttachmentEntityChange(source, sourceAttachment.getFileName(), sourceAttachment.getVersion(), 3));
                if (publishingOptions.get((Object)PublishingOption.COPYLABELS).booleanValue() && this.labelPublisher.mustUpdateLabels((ContentEntityObject)sourceAttachment, (ContentEntityObject)destinationAttachment, (boolean)publishingOptions.get((Object)PublishingOption.EXACT_LABL_SYNC))) {
                    changes.add(pageChange.createAttachmentEntityChange(source, sourceAttachment.getFileName(), sourceAttachment.getVersion(), 5));
                }
            } else if (publishingOptions.get((Object)PublishingOption.COPYLABELS).booleanValue() && this.labelPublisher.mustUpdateLabels((ContentEntityObject)sourceAttachment, (ContentEntityObject)destinationAttachment, (boolean)publishingOptions.get((Object)PublishingOption.EXACT_LABL_SYNC))) {
                changes.add(pageChange.createAttachmentEntityChange(source, sourceAttachment.getFileName(), sourceAttachment.getVersion(), 5));
            }
            ++i;
        }
        Arrays.sort(attachmentNames);
        for (i = 0; i < attachmentsManifests.length; ++i) {
            Attachment attachment;
            AttachmentManifest attachmentsManifest = attachmentsManifests[i];
            if (Arrays.binarySearch(attachmentNames, attachmentsManifest.getFileName()) >= 0 || (attachment = this.attachmentManager.getAttachment((ContentEntityObject)destination, attachmentsManifest.getFileName())) == null) continue;
            changes.add(pageChange.createAttachmentEntityChange(destination, attachment.getFileName(), attachment.getVersion(), 2));
        }
        for (Attachment attachment : this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)destination)) {
            if (Arrays.binarySearch(attachmentsManifests, attachment.getFileName()) >= 0 || Arrays.binarySearch(attachmentNames, attachment.getFileName()) >= 0) continue;
            changes.add(pageChange.createAttachmentEntityChange(destination, attachment.getFileName(), attachment.getVersion(), 2));
        }
        pageChange.setAttachmentChanges(changes);
    }

    private List<Attachment> getVersionedAttachments(AbstractPage source, Map<PublishingOption, Boolean> spacePublishingOptions) {
        WorkflowsStateDelegate workflowsStateDelegate = new WorkflowsStateDelegate(this.context);
        State publishedState = workflowsStateDelegate.obtainWorkflowsState(source);
        if (publishedState == null || !spacePublishingOptions.get((Object)PublishingOption.PUBLISH_AWP_FINAL_STATE).booleanValue()) {
            return this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)source);
        }
        List approvedAttachmentVersions = publishedState.getAttachmentVersions();
        ArrayList<Attachment> approvedAttachments = new ArrayList<Attachment>();
        block0: for (AttachmentVersion approvedAttachmentVersion : approvedAttachmentVersions) {
            Attachment theLatestAttachment = this.attachmentManager.getAttachment(Long.valueOf(approvedAttachmentVersion.getAttachmentId()).longValue());
            if (theLatestAttachment == null) continue;
            List allPageAttachmentVersions = this.attachmentManager.getAllVersions(theLatestAttachment);
            for (Attachment versionedAttachment : allPageAttachmentVersions) {
                if (versionedAttachment.getVersion() != approvedAttachmentVersion.getVersion()) continue;
                approvedAttachments.add(versionedAttachment);
                continue block0;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Approved Attachments " + approvedAttachments);
        }
        return approvedAttachments;
    }

    private void createNewChanges(AbstractPageChange pageChangeSet, AbstractPage source, AbstractPage destination, Map<PublishingOption, Boolean> spacePublishingOptions) {
        Set<String> destinationAttachments = this.getPageAttachmentNames(destination);
        ArrayList<AttachmentEntityChange> changes = new ArrayList<AttachmentEntityChange>();
        for (Attachment o : this.getVersionedAttachments(source, spacePublishingOptions)) {
            Attachment attachment = o;
            if (destinationAttachments.contains(attachment.getFileName())) {
                destinationAttachments.remove(attachment.getFileName());
            }
            AttachmentEntityChange change = pageChangeSet.createAttachmentEntityChange(source, attachment.getFileName(), attachment.getVersion(), 1);
            changes.add(change);
        }
        for (String destinationAttachment : destinationAttachments) {
            AttachmentEntityChange change = pageChangeSet.createAttachmentEntityChange(destination, destinationAttachment, 0, 2);
            changes.add(change);
        }
        pageChangeSet.setAttachmentChanges(changes);
    }

    private Set<String> getPageAttachmentNames(AbstractPage page) {
        HashSet<String> filenames = new HashSet<String>();
        if (page == null) {
            return filenames;
        }
        for (Object o : this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page)) {
            Attachment attachment = (Attachment)o;
            filenames.add(attachment.getFileName());
        }
        return filenames;
    }

    @Override
    public void publish(AbstractPageChange pageChange, String sourceSpaceKey, String destinationSpaceKey, Date publishingDate, DiagramPublicationService diagramProcessor) throws PublishingException {
        AbstractPage destination = (AbstractPage)pageChange.getDestEntity();
        List<EntityChange> entityChanges = pageChange.getAttachmentChanges().getChanges();
        for (EntityChange change : entityChanges) {
            Attachment attachment = (Attachment)change.getEntity(null);
            if (change.isDelete()) {
                log.debug("deleting attachment:" + attachment.toString());
                this.removeAttachment(attachment);
                continue;
            }
            if (change.isUpdateLabels()) {
                log.debug("updating attachment:" + attachment.toString());
                this.updateAttachmentLabels(attachment, destination, pageChange.isOption(PublishingOption.EXACT_LABL_SYNC));
                continue;
            }
            if (!pageChange.getSpacePublishingOptions().get((Object)PublishingOption.USE_PUBLISHING_DATE).booleanValue()) {
                publishingDate = null;
            }
            log.debug("copying attachment:" + attachment.toString());
            this.copyAttachment(destination, attachment, pageChange.isOption(PublishingOption.EXACT_LABL_SYNC), publishingDate, diagramProcessor);
        }
    }

    private void updateAttachmentLabels(Attachment sourceAttachment, AbstractPage destination, boolean exactCopy) {
        Attachment destAttachment = this.attachmentManager.getAttachment((ContentEntityObject)destination, sourceAttachment.getFileName());
        List existingDestLabels = destAttachment.getLabellings();
        List sourceLabels = sourceAttachment.getLabellings();
        if (exactCopy) {
            List removeLabels = ListUtils.subtract((List)existingDestLabels, (List)sourceLabels);
            for (Labelling labelling : removeLabels) {
                this.labelManager.removeLabel((Labelable)destAttachment, labelling.getLabel());
            }
        }
        List newLabels = ListUtils.subtract((List)sourceLabels, (List)existingDestLabels);
        for (Labelling labelling : newLabels) {
            Label srcLabel = labelling.getLabel();
            this.labelManager.addLabel((Labelable)destAttachment, srcLabel);
        }
    }

    private void copyAttachment(AbstractPage destination, Attachment attachment, boolean exactLabelCopy, Date publishingDate, DiagramPublicationService diagramPublicationService) throws PublishingException {
        InputStream data;
        log.debug("copyAttachment : " + attachment.toString());
        Attachment attachmentCopy = this.attachmentManager.getAttachment((ContentEntityObject)destination, attachment.getFileName());
        Attachment previousAttachment = null;
        if (attachmentCopy != null) {
            previousAttachment = (Attachment)attachmentCopy.clone();
        } else {
            attachmentCopy = new Attachment();
        }
        attachmentCopy.setMediaType(attachment.getMediaType());
        attachmentCopy.setFileName(attachment.getFileName());
        attachmentCopy.setVersionComment(attachment.getVersionComment());
        attachmentCopy.setFileSize(attachment.getFileSize());
        attachmentCopy.setContainer((ContentEntityObject)destination);
        Optional<ByteArrayOutputStream> processedAttachment = diagramPublicationService.updateLinksWhenIsADiagramMacro(destination, attachment);
        if (processedAttachment.isPresent()) {
            log.debug("copyAttachment : is a processed attachment" + processedAttachment.get());
            int attachmentSize = processedAttachment.get().toByteArray().length;
            data = new ByteArrayInputStream(processedAttachment.get().toByteArray());
            attachmentCopy.setFileSize((long)attachmentSize);
        } else {
            data = this.attachmentManager.getAttachmentData(attachment);
        }
        if (data == null) {
            throw new PublishingException("Error saving attachment, attachment does not exist: " + attachment.getFileName() + ", page '" + destination.getTitle() + "'");
        }
        try {
            if (previousAttachment == null) {
                this.copyEntityCreatedMetaData((ConfluenceEntityObject)attachment, (ConfluenceEntityObject)attachmentCopy, publishingDate);
                destination.addAttachment(attachmentCopy);
            }
            this.copyEntityUpdatedMetadata((ConfluenceEntityObject)attachment, (ConfluenceEntityObject)attachmentCopy, publishingDate);
            this.attachmentManager.saveAttachment(attachmentCopy, previousAttachment, data);
            this.updateAttachmentLabels(attachment, destination, exactLabelCopy);
            if (previousAttachment == null) {
                this.indexer.index((Searchable)attachment);
            }
        }
        catch (Exception e) {
            log.error("Unexpected Error", (Throwable)e);
            if (previousAttachment != null) {
                log.debug("copyAttachment : comparison for data changes: new:" + attachment + " [" + data + "], previous:" + previousAttachment + " [" + this.attachmentManager.getAttachmentData(previousAttachment) + "]");
            }
            throw new PublishingException("Error: exception saving attachment: " + attachment.getFileName() + ", page '" + destination.getTitle() + "', Exception:" + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)data);
        }
    }

    private void removeAttachment(Attachment attachment) {
        this.attachmentManager.removeAttachmentFromServer(attachment);
    }

    boolean needToUpdateDestinationAttachment(Attachment original, Attachment compared, AbstractPage source) {
        Map<PublishingOption, Boolean> spacePublishingOptions = this.publishingConfigurationManager.getSpacePublishingOptions(source.getLatestVersion().getSpace());
        if (!spacePublishingOptions.isEmpty() && spacePublishingOptions.get((Object)PublishingOption.IGNORE_MANIFEST).booleanValue()) {
            return true;
        }
        if (this.isDrawIoWithLinksUpdateFeatureEnabled(original, compared)) {
            return false;
        }
        return !this.areAttachmentEquals(original, compared);
    }

    private boolean areAttachmentEquals(Attachment original, Attachment compared) {
        return original.getFileSize() == compared.getFileSize() && original.getNameForComparison().equals(compared.getNameForComparison()) && original.isHidden() == compared.isHidden() && original.getMediaType().equals(compared.getMediaType()) && this.haveSameCreationDate(original, compared);
    }

    private boolean haveSameCreationDate(Attachment original, Attachment compared) {
        Date comparedCreationDate = compared.getCreationDate();
        Date originalCreationDate = original.getCreationDate();
        return originalCreationDate.equals(comparedCreationDate) || originalCreationDate.before(comparedCreationDate);
    }

    private boolean isDrawIoWithLinksUpdateFeatureEnabled(Attachment original, Attachment compared) {
        return original.getContentTypeObject().equals((Object)compared.getContentTypeObject()) && original.getMediaType().equalsIgnoreCase("application/vnd.jgraph.mxfile") && this.darkFeaturesManager.getDarkFeatures().isFeatureEnabled(DarkFeatureKeys.DIAGRAMS_LINKS_UPDATE.toString());
    }
}

