/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function (CW, $) {
    CW.toInit(function () {
        var qs = CW.queryString();
        if (qs.spaceKey) {
            var $spaceadmin = $('#cas-spaceadmin');

            var iframe = new CW.iframe({
                id: 'cas-spaceadmin-iframe',
                url: '/approvals/spaceadmin/' + qs.spaceKey,
                height: '100%',
                scrolling: 'auto'
            });
            $spaceadmin.html(iframe.render());

            var workflowPicker = new CW.Dialog({
                id: 'cw-addWorkflowDialog',
                width: 800,
                height: 550,
                path: '/workflow/' + CW.getParam('spaceKey') + '/add',
                query: {
                    spaceName: CW.getParam('spaceName')
                }
            });
            if (qs.addSpaceWorkflow && qs.addSpaceWorkflow === 'true') {
                workflowPicker.show();
            }

            // Select Workflow
            CW.connect("workflowAdd", function(workflow) {
                this.show(workflow ? ({ workflow: workflow }) : null);
            }, workflowPicker);
            // Workflow Applied
            CW.connect("workflowAdded", function(workflow) {
                this.send("workflowAdded", workflow);
            }, iframe);
        } else {
            console.warn('[CAS] missing required SpaceKey');
        }

        CW.licenseIsValid();
    });
});
