/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.user;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;

public class WorkflowAuthenticatedUserThreadLocal {
    private static final ThreadLocal<Boolean> inExpiryJob = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public static void setInExpiryJob(boolean setInExpiry) {
        if (setInExpiry) {
            inExpiryJob.set(true);
        } else {
            inExpiryJob.remove();
        }
    }

    public static ConfluenceUser get() {
        WorkflowUserAccessor workflowUserAccessor = PluginContainerManager.getComponent(WorkflowUserAccessor.class);
        Boolean expiryJob = inExpiryJob.get();
        if (expiryJob.booleanValue()) {
            return workflowUserAccessor.getWorkflowsUser();
        }
        return AuthenticatedUserThreadLocal.get();
    }

    public static Boolean isInExpiryJob() {
        return inExpiryJob.get();
    }

    public static String getUsername() {
        if (WorkflowAuthenticatedUserThreadLocal.get() == null) {
            return null;
        }
        return WorkflowAuthenticatedUserThreadLocal.get().getName();
    }
}

