/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;

public class HasApprovalCondition
extends Condition {
    private String[] approvalNames;
    private boolean current;

    public HasApprovalCondition(boolean not, String approvalNames, Boolean current) {
        super(not);
        this.approvalNames = MiscUtils.splitAndTrim(approvalNames);
        this.current = current != null ? current : true;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        for (String approvalName : this.approvalNames) {
            ApprovalCheck approvalCheck = this.getApprovalManager().getLastApprovalByName(valueStore, approvalName, this.current);
            if (approvalCheck == null || !approvalCheck.isApproved()) continue;
            return true;
        }
        return false;
    }

    public String[] getApprovalNames() {
        return this.approvalNames;
    }

    private String getApprovalsNamesList() {
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (int i = 0; i < this.approvalNames.length; ++i) {
            String approvalName = this.approvalNames[i];
            sb.append(separator).append("_").append(approvalName).append("_");
            separator = i < this.approvalNames.length - 2 ? ", " : " or ";
        }
        return sb.toString();
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        macro.addParameter("hasapproval", (Object)((this.not ? "!" : "") + MiscUtils.stringListToCommaSeparatedList(this.approvalNames, ",")));
    }

    @Override
    public String toString(ValueStore valueStore) {
        StringBuilder sb = new StringBuilder();
        if (this.not) {
            sb.append("does not have");
        } else {
            sb.append("has");
        }
        sb.append(" ").append(this.getApprovalsNamesList()).append(" approval");
        return sb.toString();
    }
}

