/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.dao.sax;

import com.atlassian.core.util.XMLUtils;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.dao.DaoHelper;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DueDateConverterHelper {
    private static final String USER_QNAME = "user";
    private static final String DATE_QNAME = "date";
    public static final String DUEDATE_RECORD_CURRENT_QNAME = "currentDueDateRecord";
    public static final String DUEDATE_RECORD_HISTORIES_QNAME = "dueDateHistory";
    public static final String DUEDATE_RECORD_HISTORY_QNAME = "dueDateRecord";
    public static final String DUEDATE_RECORD_DUEDATE_QNAME = "duedate";
    public static final String DUEDATE_RECORD_EXPIRY_TRIGGERED_QNAME = "expiryTriggered";
    private static final String TAB4 = "    ";

    public static void appendDueDateRecord(StringBuilder sb, String indent, DueDateRecord dueDateRecord, String xmlName, Map<String, String> userNamesCache) {
        if (dueDateRecord != null) {
            sb.append(indent).append("<").append(xmlName).append(" ");
            if (dueDateRecord.getPerformer() != null) {
                sb.append(" ").append(USER_QNAME).append("=\"").append(XMLUtils.escape((String)DaoHelper.getUserNameOrKey(dueDateRecord.getPerformer(), userNamesCache))).append("\"");
            }
            if (dueDateRecord.getDate() != null) {
                sb.append(" ").append(DATE_QNAME).append("=\"").append(TimerUtils.getFormatter().format(dueDateRecord.getDate())).append("\"");
            }
            sb.append(">\n");
            if (dueDateRecord.getDueDate() != null) {
                DueDateConverterHelper.append(sb, indent + TAB4, DUEDATE_RECORD_DUEDATE_QNAME, TimerUtils.getFormatter().format(dueDateRecord.getDueDate()));
            } else {
                DueDateConverterHelper.append(sb, indent + TAB4, DUEDATE_RECORD_DUEDATE_QNAME, "");
            }
            if (dueDateRecord.isExpiryTriggered()) {
                DueDateConverterHelper.append(sb, indent + TAB4, DUEDATE_RECORD_EXPIRY_TRIGGERED_QNAME, Boolean.toString(dueDateRecord.isExpiryTriggered()));
            }
            sb.append(indent).append("</").append(xmlName).append(">\n");
        }
    }

    public static void appendDueDateHistoryRecords(StringBuilder sb, String indent, List<DueDateRecord> dueDateRecords, Map<String, String> userNamesCache) {
        if (dueDateRecords != null) {
            sb.append(indent).append("<").append(DUEDATE_RECORD_HISTORIES_QNAME).append(">\n");
            for (DueDateRecord dueDateRecord : dueDateRecords) {
                DueDateConverterHelper.appendDueDateRecord(sb, indent + TAB4, dueDateRecord, DUEDATE_RECORD_HISTORY_QNAME, userNamesCache);
            }
            sb.append(indent).append("</").append(DUEDATE_RECORD_HISTORIES_QNAME).append(">\n");
        }
    }

    private static StringBuilder append(StringBuilder sb, String indent, String element, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            value = XMLUtils.escape((String)value);
            sb.append(indent).append('<').append(element).append('>').append(value).append("</").append(element).append(">\n");
        }
        return sb;
    }
}

