/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.AnyTypeDao;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.util.pagination.PaginationSupport;
import com.comalatech.confluence.workflowreports.AbstractWorkflowReportCreator;
import com.comalatech.confluence.workflowreports.WorkflowReportService;
import com.comalatech.confluence.workflowreports.model.WorkflowReportOptions;
import com.comalatech.confluence.workflowreports.model.WorkflowReportSortEnum;
import com.comalatech.confluence.workflowreports.search.AssigneeQuery;
import com.comalatech.confluence.workflowreports.search.NamedSort;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.model.ReportSort;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultWorkflowReportService
extends AbstractWorkflowReportCreator
implements WorkflowReportService {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowReportService.class);
    private static final int MAX_ENTRIES = 1000;

    public DefaultWorkflowReportService(@ComponentImport SearchManager searchManager, @ComponentImport AnyTypeDao anyTypeDao) {
        super(searchManager, anyTypeDao);
    }

    @Override
    public Iterator<ContentEntityObject> getContentByState(String spaceKeys, String states, ReportSort sort) throws WorkflowException {
        WorkflowReportOptions options = this.makeOptions(spaceKeys, sort);
        options.setStateNames(states);
        return this.runStatesSearch(options);
    }

    @Override
    public Iterator<ContentEntityObject> getChildrenByState(String ancestorId, String states, ReportSort sort) throws WorkflowException {
        WorkflowReportOptions options = this.makeOptions(null, sort);
        options.setStateNames(states);
        options.setParentId(ancestorId);
        return this.runStatesSearch(options);
    }

    @Override
    public Iterator<ContentEntityObject> getAssignedContent(String spaceKeys, String userName, ReportSort sort) throws WorkflowException {
        WorkflowReportOptions options = this.makeOptions(spaceKeys, sort);
        options.setAssignee(userName);
        return this.runStatesSearch(options);
    }

    private WorkflowReportOptions makeOptions(String spaceKeys, ReportSort sort) {
        WorkflowReportOptions options = new WorkflowReportOptions(spaceKeys, null, WorkflowReportSortEnum.makeSortNoDefault(sort.getSort(), sort.getOrder()), 1000);
        if (options.getSort() == null) {
            options.setCustomSort((SearchSort)new NamedSort(sort.getSort(), WorkflowReportSortEnum.getOrder(sort.getOrder())));
        }
        return options;
    }

    private Iterator<ContentEntityObject> runStatesSearch(WorkflowReportOptions options) throws WorkflowException {
        Collection<SearchQuery> queries = this.makeDefaultQueries(options);
        this.appendStateQuery(options, queries);
        if (options.getAssignee() != null) {
            queries.add(new AssigneeQuery(options.getAssignee()));
        }
        BooleanQuery query = new BooleanQuery(queries, null, null);
        return this.runContentSearch(options, (SearchQuery)query);
    }

    private Iterator<ContentEntityObject> runContentSearch(WorkflowReportOptions options, SearchQuery query) throws WorkflowException {
        PaginationSupport paginationSupport = new PaginationSupport(options.getMaxEntries());
        ISearch search = this.createSearchObject(options, paginationSupport, query);
        try {
            SearchResults results = this.searchManager.search(search);
            return new ContentIterator(results);
        }
        catch (InvalidSearchException e) {
            throw new WorkflowException(e);
        }
    }

    public class ContentIterator
    implements Iterator<ContentEntityObject> {
        Iterator<SearchResult> iterator;
        AbstractPage next;

        public ContentIterator(SearchResults results) {
            this.iterator = results.iterator();
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                SearchResult result = this.iterator.next();
                this.next = (AbstractPage)DefaultWorkflowReportService.this.anyTypeDao.findByHandle(result.getHandle());
                if (!this.next.isLatestVersion() || this.next.isDeleted()) continue;
                return true;
            }
            return false;
        }

        @Override
        public AbstractPage next() {
            if (this.next != null) {
                AbstractPage page = this.next;
                this.next = null;
                return page;
            }
            if (!this.hasNext()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            AbstractPage page = this.next;
            this.next = null;
            return page;
        }

        @Override
        public void remove() {
            throw new RuntimeException("not permitted");
        }
    }
}

