/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.usage.task;

import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.util.CSVBuilder;
import com.comalatech.confluence.util.PackageFileUtil;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.confluence.workflow.usage.download.commands.RestrictionsWorkflowsCSV;
import com.comalatech.confluence.workflow.usage.download.model.RestrictionsWorkflowsCSVData;
import com.comalatech.confluence.workflow.usage.model.RestrictionsContentWorkflowReportEntry;
import com.comalatech.confluence.workflow.usage.service.WorkflowsUsageReportService;
import com.comalatech.confluence.workflow.usage.task.model.Status;
import com.comalatech.confluence.workflow.usage.task.model.WorkflowsUsageTask;
import com.comalatech.confluence.workflow.usage.util.WorkflowsUsagePackageFile;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictionsContentWorkflowReportTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(RestrictionsContentWorkflowReportTask.class);
    private final SpaceManager spaceManager;
    private final WorkflowService workflowService;
    private final WorkflowsUsageReportService workflowsUsageReportService;
    private final ComalaI18nBean comalaI18nBean;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final RestrictionsWorkflowsCSV restrictionsWorkflowsCSV;
    private final WorkflowsUsageTask workflowsUsageTask;

    public RestrictionsContentWorkflowReportTask(SpaceManager spaceManager, WorkflowService workflowService, WorkflowsUsageReportService workflowsUsageReportService, ComalaI18nBean comalaI18nBean, ReadWriteTransactionService readWriteTransactionService, SupportPresenter templateFileLayoutHelper, WorkflowsUsageTask workflowsUsageTask) {
        this.spaceManager = spaceManager;
        this.workflowService = workflowService;
        this.workflowsUsageReportService = workflowsUsageReportService;
        this.comalaI18nBean = comalaI18nBean;
        this.readWriteTransactionService = readWriteTransactionService;
        this.restrictionsWorkflowsCSV = new RestrictionsWorkflowsCSV(templateFileLayoutHelper);
        this.workflowsUsageTask = workflowsUsageTask;
    }

    protected void runInternal() {
        Instant startedAt = Instant.now();
        try {
            PackageFileUtil.deleteFolder(WorkflowsUsagePackageFile.getWorkflowsUsageBasePath("restrictions"));
            if (!this.isReportTaskReadyToStart()) {
                this.updateProcess(false, Status.FAIL);
                this.finishTaskProcess(startedAt);
                return;
            }
            CSVBuilder csv = new CSVBuilder();
            this.readWriteTransactionService.executeInReadWriteTransaction(() -> {
                AtomicLong recordsProcessed = new AtomicLong(0L);
                this.generateHeaders(csv);
                this.progress.setStatus(Status.IN_PROGRESS.getValue());
                List<String> activeSpaceKeys = this.workflowService.getSpacesWithWorkflows(new HashSet<String>(this.spaceManager.getAllSpaceKeys(SpaceStatus.CURRENT)));
                if (!activeSpaceKeys.isEmpty()) {
                    try {
                        List<RestrictionsContentWorkflowReportEntry> restrictionsContentWorkflowsReport = this.workflowsUsageReportService.getRestrictionsContentWorkflowsReport(activeSpaceKeys);
                        if (!restrictionsContentWorkflowsReport.isEmpty()) {
                            restrictionsContentWorkflowsReport.forEach(usageReport -> {
                                this.addUsageReport(csv, (RestrictionsContentWorkflowReportEntry)usageReport);
                                csv.newLine();
                            });
                        }
                    }
                    catch (Exception e) {
                        log.error("RestrictionsContentWorkflowReportTask error: {}", (Object)e.getMessage(), (Object)e);
                        throw new RuntimeException(e);
                    }
                }
                recordsProcessed.incrementAndGet();
                this.progress.setPercentage(recordsProcessed.intValue() * 90 / activeSpaceKeys.size());
                return null;
            });
            this.restrictionsWorkflowsCSV.generateSupportFile(RestrictionsWorkflowsCSVData.builder().csv(csv.get()).build(), PackageFileUtil.generateFolder(WorkflowsUsagePackageFile.getWorkflowsUsageBasePath("restrictions")));
            this.updateProcess(true, Status.SUCCESS);
        }
        catch (Exception ex) {
            this.updateProcess(false, Status.FAIL);
            log.error(ex.getMessage(), (Throwable)ex);
        }
        this.finishTaskProcess(startedAt);
    }

    private void updateProcess(boolean completedSuccessfully, Status updateStatus) {
        this.progress.setCompletedSuccessfully(completedSuccessfully);
        this.progress.setStatus(updateStatus.getValue());
        this.workflowsUsageTask.setStatus(updateStatus);
    }

    private void finishTaskProcess(Instant startedAt) {
        this.progress.setPercentage(100);
        this.workflowsUsageTask.setDuration(TimerUtils.getDuration(startedAt));
        this.workflowsUsageReportService.saveRestrictionsWorkflowsUsageReportTask(this.workflowsUsageTask);
    }

    private void generateHeaders(CSVBuilder csv) {
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.restrictionscontent.report.csvexport.content_id.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.restrictionscontent.report.csvexport.title.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.restrictionscontent.report.csvexport.space_key.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.restrictionscontent.report.csvexport.permission_type.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.restrictionscontent.report.csvexport.user_key.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.restrictionscontent.report.csvexport.username.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.restrictionscontent.report.csvexport.user_mail.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.restrictionscontent.report.csvexport.group_name.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.restrictionscontent.report.csvexport.restriction_type.header"));
        csv.addCell(this.comalaI18nBean.getText("com.comalatech.restrictionscontent.report.csvexport.ancestor_id.header"));
        csv.newLine();
    }

    private void addUsageReport(CSVBuilder csv, RestrictionsContentWorkflowReportEntry reportEntry) {
        csv.addCell(reportEntry.getContentId().toString());
        csv.addCell(reportEntry.getTitle());
        csv.addCell(reportEntry.getSpaceKey());
        csv.addCell(reportEntry.getPermissionType());
        ConfluenceUser user = reportEntry.getUser();
        csv.addCell(Objects.nonNull(user) ? user.getKey().getStringValue() : "");
        csv.addCell(Objects.nonNull(user) ? user.getName() : "");
        csv.addCell(Objects.nonNull(user) ? user.getEmail() : "");
        csv.addCell(Objects.nonNull(reportEntry.getGroupName()) ? reportEntry.getGroupName() : "");
        csv.addCell(reportEntry.isInheritedRestrictions() ? this.comalaI18nBean.getText("com.comalatech.restrictionscontent.report.csvexport.restriction_type.inherited") : this.comalaI18nBean.getText("com.comalatech.restrictionscontent.report.csvexport.restriction_type.explicit"));
        csv.addCell(reportEntry.isInheritedRestrictions() ? reportEntry.getAncestorId().toString() : "");
    }

    private boolean isReportTaskReadyToStart() throws Exception {
        WorkflowsUsageTask storedWorkflowsUsageTask = this.workflowsUsageReportService.getRestrictionsWorkflowUsageReportTask();
        LocalDateTime timeLimit = LocalDateTime.now().plusSeconds(180L);
        while (!Status.IN_PROGRESS.equals((Object)storedWorkflowsUsageTask.getStatus()) && TimerUtils.toEpochMilli(LocalDateTime.now()) <= TimerUtils.toEpochMilli(timeLimit)) {
            storedWorkflowsUsageTask = this.workflowsUsageReportService.getRestrictionsWorkflowUsageReportTask();
            Thread.sleep(2000L);
        }
        this.workflowsUsageTask.setStartedAt(storedWorkflowsUsageTask.getStartedAt());
        return Status.IN_PROGRESS.equals((Object)storedWorkflowsUsageTask.getStatus());
    }

    public String getName() {
        return "Restrictions content workflows report task";
    }
}

