/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.supportconsole.service;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.supportconsole.commands.Debug;
import com.comalatech.confluence.workflow.supportconsole.commands.DocumentActivity;
import com.comalatech.confluence.workflow.supportconsole.commands.GlobalConfiguration;
import com.comalatech.confluence.workflow.supportconsole.commands.PageActivity;
import com.comalatech.confluence.workflow.supportconsole.commands.PageJsonContentProperties;
import com.comalatech.confluence.workflow.supportconsole.commands.PageStatus;
import com.comalatech.confluence.workflow.supportconsole.commands.PageStorageFormat;
import com.comalatech.confluence.workflow.supportconsole.commands.SpaceConfiguration;
import com.comalatech.confluence.workflow.supportconsole.commands.WorkflowsMarkup;
import com.comalatech.confluence.workflow.supportconsole.commands.contract.SupportGeneratorCommand;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.CompressionUtils;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.confluence.workflow.supportconsole.mappers.contract.SupportConsoleReportDataPopulator;
import com.comalatech.confluence.workflow.supportconsole.model.DebugData;
import com.comalatech.confluence.workflow.supportconsole.model.DocumentActivityData;
import com.comalatech.confluence.workflow.supportconsole.model.GlobalConfigurationData;
import com.comalatech.confluence.workflow.supportconsole.model.PageActivityData;
import com.comalatech.confluence.workflow.supportconsole.model.PageJsonContentPropertiesListData;
import com.comalatech.confluence.workflow.supportconsole.model.PageStatusData;
import com.comalatech.confluence.workflow.supportconsole.model.PageStorageFormatData;
import com.comalatech.confluence.workflow.supportconsole.model.SpaceConfigurationData;
import com.comalatech.confluence.workflow.supportconsole.model.WorkflowsDataList;
import com.comalatech.confluence.workflow.supportconsole.model.contract.SupportData;
import com.comalatech.confluence.workflow.supportconsole.service.SupportConsoleService;
import com.comalatech.workflow.WorkflowException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SupportConsoleServiceImpl
implements SupportConsoleService {
    private final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
    private final SupportConsoleReportDataPopulator<WorkflowsDataList, Space> workflowsDataMapper;
    private final SupportConsoleReportDataPopulator<GlobalConfigurationData, Space> globalConfigDataMapper;
    private final SupportConsoleReportDataPopulator<SpaceConfigurationData, Space> spaceConfigDataMapper;
    private final SupportConsoleReportDataPopulator<PageJsonContentPropertiesListData, AbstractPage> jsonContentPropertiesPopulator;
    private final SupportConsoleReportDataPopulator<DebugData, AbstractPage> debugDataPopulator;
    private final SupportConsoleReportDataPopulator<PageStatusData, AbstractPage> pageStatusDataPopulator;
    private final SupportConsoleReportDataPopulator<PageActivityData, AbstractPage> pageActivityDataPopulator;
    private final SupportConsoleReportDataPopulator<DocumentActivityData, AbstractPage> documentActivityDataPopulator;
    private final SupportConsoleReportDataPopulator<PageStorageFormatData, AbstractPage> pageStorageFormatDataPopulator;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final Map<String, String> appKeyName = new HashMap<String, String>(3);
    ArrayList<SupportGeneratorCommand> reports = new ArrayList();

    public SupportConsoleServiceImpl(@Qualifier(value="globalConfigDataMapper") SupportConsoleReportDataPopulator<GlobalConfigurationData, Space> globalDataMapper, @Qualifier(value="spaceConfigDataMapper") SupportConsoleReportDataPopulator<SpaceConfigurationData, Space> spaceDataMapper, @Qualifier(value="workflowsDataPopulator") SupportConsoleReportDataPopulator<WorkflowsDataList, Space> workflowsDataMapper, @Qualifier(value="jsonContenPropertiesDataPopulator") SupportConsoleReportDataPopulator<PageJsonContentPropertiesListData, AbstractPage> jsonContentPropertiesPopulator, SupportPresenter templateFileLayoutHelper, @Qualifier(value="debugDataPopulator") SupportConsoleReportDataPopulator<DebugData, AbstractPage> debugDataPopulator, @Qualifier(value="pageStatusDataPopulator") SupportConsoleReportDataPopulator<PageStatusData, AbstractPage> pageStatusDataPopulator, @Qualifier(value="pageActivityDataPopulator") SupportConsoleReportDataPopulator<PageActivityData, AbstractPage> pageActivityDataPopulator, @Qualifier(value="documentActivityDataPopulator") SupportConsoleReportDataPopulator<DocumentActivityData, AbstractPage> documentActivityDataPopulator, @Qualifier(value="pageStorageFormatDataPopulator") SupportConsoleReportDataPopulator<PageStorageFormatData, AbstractPage> pageStorageFormatDataPopulator, WorkflowsFeatureManager workflowsFeatureManager) {
        this.workflowsDataMapper = workflowsDataMapper;
        this.globalConfigDataMapper = globalDataMapper;
        this.spaceConfigDataMapper = spaceDataMapper;
        this.jsonContentPropertiesPopulator = jsonContentPropertiesPopulator;
        this.debugDataPopulator = debugDataPopulator;
        this.pageStatusDataPopulator = pageStatusDataPopulator;
        this.pageActivityDataPopulator = pageActivityDataPopulator;
        this.documentActivityDataPopulator = documentActivityDataPopulator;
        this.pageStorageFormatDataPopulator = pageStorageFormatDataPopulator;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.appKeyName.put("com.comalatech.workflow", "COMALA_DOCUMENT_MANAGEMENT");
        this.appKeyName.put("com.comalatech.cloud.approvals", "COMALA_DOCUMENT_CONTROL");
        this.appKeyName.put("com.comalatech.workflow.approvals", "COMALA_DOCUMENT_APPROVAL");
        this.reports.add(new GlobalConfiguration(templateFileLayoutHelper));
        this.reports.add(new WorkflowsMarkup(templateFileLayoutHelper));
        this.reports.add(new PageJsonContentProperties(templateFileLayoutHelper));
        this.reports.add(new Debug(templateFileLayoutHelper));
        this.reports.add(new PageStatus(templateFileLayoutHelper));
        this.reports.add(new PageActivity(templateFileLayoutHelper));
        this.reports.add(new DocumentActivity(templateFileLayoutHelper));
        this.reports.add(new SpaceConfiguration(templateFileLayoutHelper));
        this.reports.add(new PageStorageFormat(templateFileLayoutHelper));
    }

    @Override
    public Path getSupportFile(Space space, AbstractPage page, boolean hasStorageFormat) throws IOException, WorkflowException {
        String folderName = this.generateFolderName(space.getKey());
        Path basePath = this.generateBaseFolder(folderName);
        this.generateDataForSpace(space, basePath);
        this.generateDataForPage(page, basePath, hasStorageFormat);
        Path zipPath = this.generateZipPath(basePath.getParent(), folderName);
        CompressionUtils.compressToZip(basePath, zipPath);
        return zipPath;
    }

    private String generateFolderName(String spaceKey) {
        return String.format("%s_%s_support_%s", this.appKeyName.get(this.workflowsFeatureManager.getPluginKey()), spaceKey, this.FORMATTER.format(LocalDateTime.now()));
    }

    private void generateDataForSpace(Space space, Path basePath) throws WorkflowException {
        SupportData populateGlobalData = this.globalConfigDataMapper.populateForTarget(null);
        SupportData populateSpaceData = this.spaceConfigDataMapper.populateForTarget(space);
        SupportData workflowsData = this.workflowsDataMapper.populateForTarget(space);
        List<SupportData> data = Arrays.asList(populateGlobalData, workflowsData, populateSpaceData);
        data.forEach(reportData -> this.reports.forEach(command -> command.generateSupportFile((SupportData)reportData, basePath)));
    }

    private void generateDataForPage(AbstractPage page, Path basePath, boolean hasStorageFormat) throws IOException, WorkflowException {
        if (page != null) {
            Path pageSupportReportsPath = Paths.get(basePath.toString(), "PAGE_" + page.getId());
            Path supportFileBaseDirectory = Files.createDirectories(pageSupportReportsPath, new FileAttribute[0]);
            SupportData pageJsonContentProperties = this.jsonContentPropertiesPopulator.populateForTarget(page);
            SupportData debugInfo = this.debugDataPopulator.populateForTarget(page);
            SupportData statusInfo = this.pageStatusDataPopulator.populateForTarget(page);
            SupportData pageActivityInfo = this.pageActivityDataPopulator.populateForTarget(page);
            SupportData documentActivityInfo = this.documentActivityDataPopulator.populateForTarget(page);
            ArrayList<SupportData> data = new ArrayList<SupportData>(Arrays.asList(pageJsonContentProperties, debugInfo, statusInfo, pageActivityInfo, documentActivityInfo));
            if (hasStorageFormat) {
                SupportData storageFormatInfo = this.pageStorageFormatDataPopulator.populateForTarget(page);
                data.add(storageFormatInfo);
            }
            data.forEach(reportData -> this.reports.forEach(command -> command.generateSupportFile((SupportData)reportData, supportFileBaseDirectory)));
        }
    }

    private Path generateZipPath(Path temporaryFolder, String name) throws IOException {
        Path zipFilePath = Paths.get(temporaryFolder.toString(), name + ".zip");
        return Files.createFile(zipFilePath, new FileAttribute[0]);
    }

    private Path generateBaseFolder(String name) throws IOException {
        Path basePath = Files.createTempDirectory("supportConsole", new FileAttribute[0]);
        Path temp = basePath.getParent();
        Path tempFolder = Paths.get(temp.toString(), name);
        return Files.move(basePath, tempFolder, new CopyOption[0]);
    }
}

