/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.Group;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowPagePermissionSetter;
import com.comalatech.confluence.workflow.filters.DeferredContentPermissionFilter;
import com.comalatech.confluence.workflow.macros.actions.AbstractActionMacro;
import com.comalatech.confluence.workflow.model.ValueReference;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPermissionMacro
extends AbstractActionMacro {
    private static final Logger log = LoggerFactory.getLogger(AbstractPermissionMacro.class);
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_USER = "user";
    private static final String PARAM_GROUP = "group";
    private static final String PARAM_USERGROUP = "usergroup";
    private UsersListResolver usersListResolver;
    private WorkflowPagePermissionSetter workflowPagePermissionSetter;

    public abstract boolean mustProvideUserOrGroup();

    public abstract void doAction(List<ContentPermission> var1, String var2, ContentEntityObject var3);

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        block23: {
            String type = (String)parameters.get(PARAM_TYPE);
            if (!StringUtils.isNotBlank((CharSequence)type)) {
                throw new MacroException("Permission type not defined (Edit or View)");
            }
            if (type.equalsIgnoreCase("Edit")) {
                type = "Edit";
            } else if (type.equalsIgnoreCase("View")) {
                type = "View";
            } else {
                throw new MacroException("Invalid permission type " + type + ". Permission type should be either Edit or View)");
            }
            String username = (String)parameters.get(PARAM_USER);
            String groupname = (String)parameters.get(PARAM_USERGROUP);
            if (!StringUtils.isNotBlank((CharSequence)groupname)) {
                groupname = (String)parameters.get(PARAM_GROUP);
            }
            if (this.mustProvideUserOrGroup() && !StringUtils.isNotBlank((CharSequence)username) && !StringUtils.isNotBlank((CharSequence)groupname)) {
                throw new MacroException("Either user or group must be defined");
            }
            AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
            ValueStore renderContextValueStore = (ValueStore)renderContext.getParam((Object)"valueStore");
            ValueStore valueStore = renderContextValueStore != null ? this.valueStoreManager.createValueStore(page, renderContextValueStore.getPropertiesMap()) : this.valueStoreManager.createValueStore(page);
            try {
                if (this.inExecuteMode(renderContext)) {
                    ArrayList<ContentPermission> contentPermissions = new ArrayList<ContentPermission>();
                    if (StringUtils.isNotBlank((CharSequence)username)) {
                        ConfluenceUser[] users = this.usersListResolver.getValueAsUsers(valueStore, valueStore.getPage(), username, true, true);
                        for (ConfluenceUser user : users) {
                            contentPermissions.add(ContentPermission.createUserPermission((String)type, (ConfluenceUser)user));
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)groupname)) {
                        List<Group> groups = this.usersListResolver.getValueAsGroups(valueStore, groupname);
                        for (Group group : groups) {
                            contentPermissions.add(ContentPermission.createGroupPermission((String)type, (String)group.getName()));
                        }
                    }
                    if ((StringUtils.isNotBlank((CharSequence)username) || StringUtils.isNotBlank((CharSequence)groupname)) && contentPermissions.isEmpty() && this.getName().equals("remove-permission")) {
                        throw new WorkflowException("There was a problem with the macro " + this.getName() + ", some user/group does not correspond with any actual user/group. " + (String)(StringUtils.isNotBlank((CharSequence)username) ? "User/s:[" + username + "]. " : "") + (String)(StringUtils.isNotBlank((CharSequence)groupname) ? "Group/s:[" + groupname + "]. " : "") + "If using Active Directory with this macro, ensure the right case is used in the user's names.");
                    }
                    try {
                        this.doAction(contentPermissions, type, (ContentEntityObject)page);
                        break block23;
                    }
                    catch (Exception e) {
                        throw new WorkflowException("There was a problem with the macro " + this.getName() + " for some user. " + (String)(StringUtils.isNotBlank((CharSequence)username) ? "User/s:[" + username + "] " : "") + (String)(StringUtils.isNotBlank((CharSequence)groupname) ? "Group/s:[" + groupname + "] " : "") + "If using Active Directory with this macro, ensure the right case is used in the user's names. " + e.getMessage());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)username)) {
                    if (!ValueReference.isValueReference(username)) {
                        this.usersListResolver.getValueAsUsers(valueStore, valueStore.getPage(), username);
                    }
                } else if (StringUtils.isNotBlank((CharSequence)groupname) && !ValueReference.isValueReference(groupname)) {
                    this.usersListResolver.getValueAsGroups(valueStore, groupname);
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.error("Error on page " + page.getId() + ": " + e.getMessage(), (Throwable)e);
                }
                if (this.inExecuteMode(renderContext)) {
                    this.logMessage(renderContext, e);
                }
                throw new MacroException(e.getMessage());
            }
        }
        return "";
    }

    protected void setPermissions(List<ContentPermission> contentPermissions, ContentEntityObject ceo) {
        if (this.isDeferAddition()) {
            DeferredContentPermissionFilter.addContentPermissionChanges(contentPermissions, ceo);
        } else {
            this.workflowPagePermissionSetter.setContentPermissions(contentPermissions, ceo);
        }
    }

    protected void addPermission(ContentPermission contentPermission, ContentEntityObject ceo) {
        if (this.isDeferAddition()) {
            DeferredContentPermissionFilter.addContentPermissionAddition(contentPermission, ceo);
        } else {
            this.workflowPagePermissionSetter.addContentPermission(contentPermission, ceo);
        }
    }

    private boolean isDeferAddition() {
        if (ActionContext.getContext() == null || ActionContext.getContext().getContextMap() == null) {
            return false;
        }
        String name = ActionContext.getContext().getActionName();
        return name != null && (name.contains("docreatepage") || name.contains("docopypage") || name.contains("doeditpage"));
    }

    protected void removePermission(ContentPermission contentPermission, ContentEntityObject ceo) {
        this.workflowPagePermissionSetter.removePermission(contentPermission, ceo);
    }

    protected void removePermissions(String type, ContentEntityObject ceo) {
        this.workflowPagePermissionSetter.removePermissions(type, ceo);
    }

    @Override
    protected abstract String getName();

    @Override
    public void setUsersListResolver(UsersListResolver usersListResolver) {
        this.usersListResolver = usersListResolver;
    }

    public void setWorkflowPagePermissionSetter(WorkflowPagePermissionSetter workflowPagePermissionSetter) {
        this.workflowPagePermissionSetter = workflowPagePermissionSetter;
    }
}

