/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.documentReport;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.api.model.content.HistoryConf9Compatibility;
import com.comalatech.confluence.api.model.search.SearchConf9Compatibility;
import com.comalatech.confluence.dataextractor.model.UserContentPropertyModel;
import com.comalatech.confluence.workflow.documentReport.DocumentReportBuilder;
import com.comalatech.confluence.workflow.restv2.model.documentreport.DocumentReport;
import com.comalatech.confluence.workflow.restv2.model.documentreport.WorkflowsReportData;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.DocumentReportJsonPropertyMapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.TasksMapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.UsersMapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.WorkflowsMapper;
import com.comalatech.confluence.workflow.user.WorkflowUserAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskActionsReportBuilder
implements DocumentReportBuilder {
    private static final Logger log = LoggerFactory.getLogger(TaskActionsReportBuilder.class);
    private final List<DocumentReportJsonPropertyMapper> mapperList = new ArrayList<DocumentReportJsonPropertyMapper>();
    private final WorkflowUserAccessor workflowUserAccessor;

    public TaskActionsReportBuilder(@ComponentImport UserAccessor userAccessor, WorkflowUserAccessor workflowUserAccessor) {
        this.mapperList.add(new WorkflowsMapper());
        this.mapperList.add(new UsersMapper(userAccessor));
        this.mapperList.add(new TasksMapper(userAccessor));
        this.workflowUserAccessor = workflowUserAccessor;
    }

    @Override
    public DocumentReport build(SearchPageResponse<SearchResult> searchResults) {
        DocumentReport documentReport = new DocumentReport();
        try {
            this.setPaginationMetadata(searchResults, documentReport);
            for (SearchResult result : searchResults) {
                WorkflowsReportData workflowsReportData = new WorkflowsReportData();
                Content contentEntity = (Content)result.getEntity();
                EnrichableMap properties = (EnrichableMap)contentEntity.getMetadata().get("properties");
                this.extractMetadataProperties((EnrichableMap<String, JsonContentProperty>)properties, workflowsReportData);
                documentReport.getWorkflowsReportList().add(workflowsReportData);
                this.updateContentData(result, contentEntity, workflowsReportData);
                this.updateUserData(workflowsReportData);
            }
        }
        catch (Exception ex) {
            log.warn("Could not be able to parse report data from CQL response {} ", searchResults, (Object)ex);
        }
        return documentReport;
    }

    private void extractMetadataProperties(EnrichableMap<String, JsonContentProperty> properties, WorkflowsReportData workflowsReportData) {
        for (Map.Entry propertyNamePropertyDataEntry : properties.entrySet()) {
            String key = (String)propertyNamePropertyDataEntry.getKey();
            String json = ((JsonContentProperty)propertyNamePropertyDataEntry.getValue()).getValue().getValue();
            this.applyMapper(key, json, workflowsReportData);
        }
    }

    private void updateContentData(SearchResult result, Content contentEntity, WorkflowsReportData workflowsReportData) {
        workflowsReportData.getContentData().iconCssClass = result.getIconCssClass();
        workflowsReportData.getContentData().title = result.getTitle();
        workflowsReportData.getContentData().url = result.getUrl();
        workflowsReportData.getContentData().updated = SearchConf9Compatibility.getLastModifiedAt(result);
        workflowsReportData.getContentData().id = contentEntity.getId().asLong();
        workflowsReportData.getContentData().type = contentEntity.getType().getType();
        Person lastUpdatedBy = ((Version)contentEntity.getHistory().getLastUpdatedRef().get()).getBy();
        workflowsReportData.getContentData().lastUpdatedBy = this.getUserData(lastUpdatedBy);
        workflowsReportData.getContentData().created = HistoryConf9Compatibility.getCreatedAt(contentEntity.getHistory());
        Person createdBy = contentEntity.getHistory().getCreatedBy();
        workflowsReportData.getContentData().createdBy = this.getUserData(createdBy);
        try {
            workflowsReportData.getContentData().spaceKey = contentEntity.getSpace() != null ? contentEntity.getSpace().getKey() : null;
            workflowsReportData.getContentData().spaceTitle = contentEntity.getSpace() != null ? contentEntity.getSpace().getName() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateUserData(WorkflowsReportData workflowsReportData) {
        if (!"com.comalatech.workflow".equals(workflowsReportData.getCurrentStateStartedBy())) {
            return;
        }
        ConfluenceUser user = this.workflowUserAccessor.getAddonUser();
        workflowsReportData.setCurrentStateStartedBy(user.getName());
        workflowsReportData.getCurrentStateStartedByInfo().displayName = user.getFullName();
        workflowsReportData.getCurrentStateStartedByInfo().profilePicture.path = this.workflowUserAccessor.getAddonUserAvatarPath();
        workflowsReportData.getCurrentStateStartedByInfo().userName = user.getName();
        workflowsReportData.getCurrentStateStartedByInfo().showAsLink = false;
    }

    private UserContentPropertyModel getUserData(Person person) {
        UserContentPropertyModel userData = new UserContentPropertyModel();
        userData.userName = person.optionalUsername().orElse(null);
        userData.displayName = person.getDisplayName();
        userData.profilePicture = new UserContentPropertyModel.ProfilePictureContentPropertyModel(person.getProfilePicture().getPath());
        person.optionalUserKey().ifPresent(lastUpdatedUserkey -> {
            userData.userKeyProperty = lastUpdatedUserkey.getStringValue();
        });
        userData.showAsLink = userData.userName != null;
        return userData;
    }

    private void setPaginationMetadata(SearchPageResponse<SearchResult> searchResults, DocumentReport documentReport) {
        documentReport.setLimit(searchResults.getPageRequest().getLimit());
        documentReport.setStart(searchResults.getPageRequest().getStart());
        documentReport.setSize(searchResults.size());
        documentReport.setTotalSize(searchResults.totalSize());
    }

    private void applyMapper(String key, String json, WorkflowsReportData data) {
        this.mapperList.forEach(documentRepoMapper -> documentRepoMapper.map(key, json, data));
    }
}

