/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.listener;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.documentActivity.upgrade.events.SpacePreCheckedEvent;
import com.comalatech.confluence.documentActivity.upgrade.events.SpaceUpgradedEvent;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.analytics.DispatcherAnalyticsManager;
import com.comalatech.confluence.workflow.analytics.catalog.BandanaKeysCatalog;

public class DocActivityUpgradeListener
extends WorkflowsListener {
    private DispatcherAnalyticsManager dispatcherAnalyticsManager;
    private BandanaManager bandanaManager;

    public DocActivityUpgradeListener(@ComponentImport EventPublisher eventPublisher, DispatcherAnalyticsManager dispatcherAnalyticsManager, @ComponentImport BandanaManager bandanaManager) {
        super(eventPublisher);
        this.dispatcherAnalyticsManager = dispatcherAnalyticsManager;
        this.bandanaManager = bandanaManager;
    }

    @EventListener
    public void onSpaceUpgraded(SpaceUpgradedEvent event) {
        this.dispatcherAnalyticsManager.setTimestampAnalyticsEntry(BandanaKeysCatalog.LATEST_SPACE_UPGRADED_KEY);
        Long counter = (Long)this.dispatcherAnalyticsManager.getAnalyticsEntry(BandanaKeysCatalog.SPACES_UPGRADED_COUNTER_KEY);
        counter = counter == null ? Long.valueOf(1L) : Long.valueOf(counter + 1L);
        this.dispatcherAnalyticsManager.setAnalyticsEntry(BandanaKeysCatalog.SPACES_UPGRADED_COUNTER_KEY, counter);
    }

    @EventListener
    public void onSpacePreChecked(SpacePreCheckedEvent event) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(event.getSpaceKey()), BandanaKeysCatalog.DOC_ACTIVITY_ENTRIES_COUNTER_KEY, (Object)event.getDocActivities());
    }
}

