/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.MigrationEntity;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.WorkflowMarkups;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.spaceworflow.CloudMarkup;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.spaceworflow.SpaceWorkflowMarkups;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.spaceworflow.WorkflowMigrationEntity;
import com.comalatech.confluence.cloud.migration.usecases.MigrationLabel;
import com.comalatech.confluence.cloud.migration.usecases.WorkflowMigrationHelper;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudMappingsData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.CloudPopulationData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.SpaceMigrationProcessor;
import com.comalatech.confluence.translator.domain.WorkflowTranslator;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.workflow.WorkflowParameterManager;
import com.comalatech.workflow.model.WorkflowParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="spaceWorkflowMigrationProcessor")
public class SpaceWorkflowMigrationProcessor
extends WorkflowMigrationHelper
implements SpaceMigrationProcessor {
    private static final Logger log = LoggerFactory.getLogger(SpaceWorkflowMigrationProcessor.class);
    private static final String SPACE_WORKFLOW_MIGRATION_VERSION = "1";
    private final SystemInformationService systemInformationService;
    private final WorkflowService workflowService;
    private final WorkflowParameterManager workflowParameterManager;

    public SpaceWorkflowMigrationProcessor(@ComponentImport SystemInformationService systemInformationService, WorkflowService workflowService, WorkflowMarkupManager workflowMarkupManager, WorkflowTranslator workflowTranslator, @ComponentImport UserAccessor userAccessor, CloudMappingsData cloudMappingsData, @Qualifier(value="cloudWorkflowUserIdPopulationUseCase") CloudPopulationData<String> userPopulationData, @Qualifier(value="cloudWorkflowGroupIdPopulationUseCase") CloudPopulationData<String> groupPopulationData, WorkflowParameterManager workflowParameterManager) {
        super(userAccessor, cloudMappingsData, workflowMarkupManager, workflowTranslator, userPopulationData, groupPopulationData);
        this.systemInformationService = systemInformationService;
        this.workflowService = workflowService;
        this.workflowParameterManager = workflowParameterManager;
    }

    @Override
    public Migration process(AppCloudMigrationGateway gateway, List<String> spaceKeys, String transferId) throws Exception {
        this.setExecutionDetails(gateway, transferId, WorkflowMigrationHelper.ProcessMode.MIGRATION);
        return this._process(spaceKeys);
    }

    @Override
    public Migration debug(List<String> spaceKeys) throws Exception {
        this.setExecutionDetails(null, null, WorkflowMigrationHelper.ProcessMode.DEBUG);
        return this._process(spaceKeys);
    }

    @Override
    public Migration debug(AbstractPage content) throws Exception {
        List<com.comalatech.workflow.model.Workflow> workflowList = this.workflowService.getWorkflows(content.getSpaceKey());
        if (workflowList.isEmpty()) {
            return null;
        }
        return this.debug(Collections.singletonList(content.getSpaceKey()));
    }

    private Migration _process(List<String> spaceKeys) {
        Migration cloudMigration = new Migration();
        spaceKeys.forEach(spaceKey -> {
            List<com.comalatech.workflow.model.Workflow> workflowList = this.workflowService.getWorkflows((String)spaceKey);
            if (!workflowList.isEmpty()) {
                cloudMigration.migrationEntities.add(this.generateMigrationEntities((String)spaceKey, workflowList));
            }
        });
        cloudMigration.totalNumberOfMigrationItems = cloudMigration.migrationEntities.size();
        cloudMigration.migrationPeerSEN = this.systemInformationService.getConfluenceInfo().getSupportEntitlementNumber();
        cloudMigration.version = SPACE_WORKFLOW_MIGRATION_VERSION;
        cloudMigration.label = MigrationLabel.SPACE_WORKFLOW.getLabel();
        return cloudMigration;
    }

    private MigrationEntity generateMigrationEntities(String spaceKey, List<com.comalatech.workflow.model.Workflow> workflowList) {
        WorkflowMigrationEntity migrationEntity = new WorkflowMigrationEntity();
        migrationEntity.setSpaceKey(spaceKey);
        boolean hasLinkedWorkflows = workflowList.stream().anyMatch(workflow -> ((Workflow)workflow).getHandle().contains("linked"));
        ArrayList<WorkflowMarkups> workflowMarkupsList = new ArrayList<WorkflowMarkups>();
        List<WorkflowParameter> workflowParameters = this.workflowParameterManager.getSpaceWorkflowsParameters(spaceKey);
        workflowList.forEach(workflow -> {
            boolean isLinked = ((Workflow)workflow).getHandle().contains("linked");
            if (hasLinkedWorkflows && !isLinked) {
                String originalName = workflow.getName();
                ((Workflow)workflow).setName("~ " + originalName);
                WorkflowMarkups markup = this.generateMigrationWorkflowMarkups((com.comalatech.workflow.model.Workflow)workflow, workflowParameters);
                workflowMarkupsList.add(markup);
                ((Workflow)workflow).setName(originalName);
            } else {
                workflowMarkupsList.add(this.generateMigrationWorkflowMarkups((com.comalatech.workflow.model.Workflow)workflow, workflowParameters));
            }
        });
        migrationEntity.setWorkflows(workflowMarkupsList);
        return migrationEntity;
    }

    private WorkflowMarkups generateMigrationWorkflowMarkups(com.comalatech.workflow.model.Workflow workflow, List<WorkflowParameter> workflowParameters) {
        return ((SpaceWorkflowMarkups.SpaceWorkflowMarkupsBuilder)((SpaceWorkflowMarkups.SpaceWorkflowMarkupsBuilder)((SpaceWorkflowMarkups.SpaceWorkflowMarkupsBuilder)((SpaceWorkflowMarkups.SpaceWorkflowMarkupsBuilder)SpaceWorkflowMarkups.builder().cloudMarkup(CloudMarkup.builder().parameters(this.getUpdatedWorkflowParameters(workflow, workflowParameters)).workflow(this.getUpdatedMarkup(workflow)).build())).serverMarkup(workflow.getWorkflowMarkup())).isActive(workflow.getStateNames() != null && !workflow.getStateNames().isEmpty() && workflow.isActive())).isLinked(((Workflow)workflow).getHandle().contains("linked"))).build();
    }

    private Map<String, String> getUpdatedWorkflowParameters(com.comalatech.workflow.model.Workflow workflow, List<WorkflowParameter> workflowParameters) {
        List<WorkflowParameter> updatedWorkflowParameters = this._getUpdatedWorkflowParameters(workflow, workflowParameters);
        return this.getMappedParameters(updatedWorkflowParameters);
    }

    private List<WorkflowParameter> _getUpdatedWorkflowParameters(com.comalatech.workflow.model.Workflow workflow, List<WorkflowParameter> workflowParameters) {
        Map<String, String> workflowParameterList = workflow.getWorkflowParameters().stream().collect(Collectors.toMap(WorkflowParameter::getName, WorkflowParameter::getValue));
        return workflowParameters.stream().filter(workflowParameter -> workflowParameterList.containsKey(workflowParameter.getName()) && !((String)workflowParameterList.get(workflowParameter.getName())).equals(workflowParameter.getValue())).collect(Collectors.toList());
    }
}

