/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.pageactivity;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.comalatech.confluence.util.CSVBuilder;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.model.ActivityReportEntry;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvConfig;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvEntryProcessorLegacy;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvProcessor;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="pageActivityCsvService")
public class PageActivityCsvServiceImpl
implements PageActivityCsvService<ActivityReportEntry> {
    private static final Logger log = LoggerFactory.getLogger(PageActivityCsvServiceImpl.class);
    private final PageActivityCsvProcessor legacyProcessor;

    public PageActivityCsvServiceImpl(@ComponentImport LocaleManager localeManager, @ComponentImport PageManager pageManager, @ComponentImport I18nResolver i18nResolver) {
        ReportDateFormatter dateFormatter = new ReportDateFormatter(localeManager);
        this.legacyProcessor = new PageActivityCsvEntryProcessorLegacy(pageManager, dateFormatter, i18nResolver);
    }

    @Override
    public String getPageActivityFileContent(List<ActivityReportEntry> entries, AbstractPage page, PageActivityCsvConfig pageActivityCsvConfig) {
        this.legacyProcessor.setPageActivityCsvConfig(pageActivityCsvConfig);
        if (entries.isEmpty()) {
            return "";
        }
        CSVBuilder csv = new CSVBuilder();
        this.legacyProcessor.generateHeaders(csv);
        for (ActivityReportEntry entry : entries) {
            this.legacyProcessor.processEntry(csv, page, entry);
        }
        return csv.get();
    }
}

