/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.usage.service;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.api.model.content.VersionConf9Compatibility;
import com.comalatech.confluence.translator.domain.CloudTranslation;
import com.comalatech.confluence.util.cql.CQLExpansionParser;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.accesor.ContentRestrictionWorkflowRecordAccessor;
import com.comalatech.confluence.workflow.accesor.entity.ContentRestrictionWorkflowRecord;
import com.comalatech.confluence.workflow.model.PageWorkflowInstance;
import com.comalatech.confluence.workflow.model.SpaceWorkflowInstance;
import com.comalatech.confluence.workflow.pageworkflows.PageWorkflowsService;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.spaceworkflows.SpaceWorkflowsService;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.CompressionUtils;
import com.comalatech.confluence.workflow.usage.accessor.WorkflowsUsageReportAccessor;
import com.comalatech.confluence.workflow.usage.accessor.model.PageWorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.accessor.model.RestrictionsWorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.accessor.model.SpaceWorkflowReportTaskRecord;
import com.comalatech.confluence.workflow.usage.model.PageWorkflowReportEntry;
import com.comalatech.confluence.workflow.usage.model.RestrictionsContentWorkflowReportEntry;
import com.comalatech.confluence.workflow.usage.model.SpaceWorkflowReportEntry;
import com.comalatech.confluence.workflow.usage.service.WorkflowsUsageReportService;
import com.comalatech.confluence.workflow.usage.service.mapper.WorkflowsUsageTaskMapper;
import com.comalatech.confluence.workflow.usage.task.model.WorkflowsUsageTask;
import com.comalatech.confluence.workflow.usage.util.WorkflowsUsagePackageFile;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultWorkflowsUsageReportService
implements WorkflowsUsageReportService {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowsUsageReportService.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
    private final WorkflowsUsageReportAccessor workflowsUsageReportAccessor;
    private final WorkflowsUsageTaskMapper workflowsUsageTaskMapper;
    private final PageWorkflowsService pageWorkflowsService;
    private final SpaceWorkflowsService spaceWorkflowsService;
    private final CQLSearchService cqlSearchService;
    private final WorkflowMarkupManager workflowMarkupManager;
    private final ContentRestrictionWorkflowRecordAccessor contentRestrictionWorkflowRecordAccessor;
    private static final String CQL_LAST_PAGE_UPDATE = "space='%s' and (type=page OR type=blogpost) order by lastModified desc";
    private static final String CQL_TOTAL_PAGES = "space='%s' and (type=page OR type=blogpost)";

    public DefaultWorkflowsUsageReportService(WorkflowsUsageReportAccessor workflowsUsageReportAccessor, @ComponentImport LongRunningTaskManager longRunningTaskManager, PageWorkflowsService pageWorkflowsService, SpaceWorkflowsService spaceWorkflowsService, CQLSearchService cqlSearchService, WorkflowMarkupManager workflowMarkupManager, ContentRestrictionWorkflowRecordAccessor contentRestrictionWorkflowRecordAccessor) {
        this.workflowsUsageReportAccessor = workflowsUsageReportAccessor;
        this.workflowsUsageTaskMapper = new WorkflowsUsageTaskMapper(longRunningTaskManager);
        this.pageWorkflowsService = pageWorkflowsService;
        this.spaceWorkflowsService = spaceWorkflowsService;
        this.cqlSearchService = cqlSearchService;
        this.workflowMarkupManager = workflowMarkupManager;
        this.contentRestrictionWorkflowRecordAccessor = contentRestrictionWorkflowRecordAccessor;
    }

    @Override
    public List<SpaceWorkflowReportEntry> getSpaceWorkflowsReport(Space space) {
        ArrayList<SpaceWorkflowReportEntry> reportEntries = new ArrayList<SpaceWorkflowReportEntry>();
        List<SpaceWorkflowInstance> spaceWorkflowInstances = this.spaceWorkflowsService.getSpaceWorkflowsBySpace(space);
        if (spaceWorkflowInstances.isEmpty()) {
            return reportEntries;
        }
        for (SpaceWorkflowInstance spaceWorkflowInstance : spaceWorkflowInstances) {
            SpaceWorkflowReportEntry reportEntry = SpaceWorkflowReportEntry.builder().spaceWorkflowInstance(spaceWorkflowInstance).build();
            long totalPagesInSpace = this.getTotalPages(space.getKey());
            reportEntry.setSpacePageCount(totalPagesInSpace);
            Date lastPageUpdate = this.getLastPageUpdate(space.getKey());
            if (lastPageUpdate != null) {
                reportEntry.setLastPageUpdateInSpace(lastPageUpdate);
            }
            if (!spaceWorkflowInstance.isActive()) {
                reportEntry.setWorkflowPageCount(0L);
            } else if (spaceWorkflowInstance.getLabels() != null && !spaceWorkflowInstance.getLabels().isEmpty()) {
                reportEntry.setWorkflowPageCount(this.getTotalPagesWithLabel(space.getKey(), spaceWorkflowInstance.getLabels(), spaceWorkflowInstance.isInvertLabels()));
            } else {
                reportEntry.setWorkflowPageCount(totalPagesInSpace);
            }
            reportEntry.setCloudJSONOversized(this.isCloudJSONOversized(spaceWorkflowInstance));
            reportEntries.add(reportEntry);
        }
        return reportEntries;
    }

    @Override
    public List<PageWorkflowReportEntry> getActivePageWorkflowReportsBySpace(Space space) throws WorkflowException {
        List<PageWorkflowInstance> pageWorkflowInstances = this.pageWorkflowsService.getPageWorkflowsBySpace(space);
        return pageWorkflowInstances.stream().filter(PageWorkflowInstance::isActive).map(PageWorkflowReportEntry::new).collect(Collectors.toList());
    }

    @Override
    public WorkflowsUsageTask getPageWorkflowsUsageReportTask() {
        PageWorkflowReportTaskRecord pageWorkflowReportTaskRecord = this.workflowsUsageReportAccessor.getPageWorkflowsReportTaskRecord();
        return this.workflowsUsageTaskMapper.fromPageWorkflowsRecordToModel(pageWorkflowReportTaskRecord);
    }

    @Override
    public void savePageWorkflowsUsageReportTask(WorkflowsUsageTask workflowsUsageTask) {
        PageWorkflowReportTaskRecord pageWorkflowReportTaskRecord = this.workflowsUsageTaskMapper.fromModelToPageWorkflowsRecord(workflowsUsageTask);
        this.workflowsUsageReportAccessor.savePageWorkflowsReportTaskRecord(pageWorkflowReportTaskRecord);
    }

    @Override
    public WorkflowsUsageTask getSpaceWorkflowsUsageReportTask() {
        SpaceWorkflowReportTaskRecord spaceWorkflowReportTaskRecord = this.workflowsUsageReportAccessor.getSpaceWorkflowsReportTaskRecord();
        return this.workflowsUsageTaskMapper.fromSpaceWorkflowsRecordToModel(spaceWorkflowReportTaskRecord);
    }

    @Override
    public void saveSpaceWorkflowsUsageReportTask(WorkflowsUsageTask workflowsUsageTask) {
        SpaceWorkflowReportTaskRecord spaceWorkflowReportTaskRecord = this.workflowsUsageTaskMapper.fromModelToSpaceWorkflowsRecord(workflowsUsageTask);
        this.workflowsUsageReportAccessor.saveSpaceWorkflowsReportTaskRecord(spaceWorkflowReportTaskRecord);
    }

    @Override
    public Path getCsvFile(String type) throws IOException {
        Path zipPath = WorkflowsUsagePackageFile.generateFile(WorkflowsUsagePackageFile.getWorkflowsUsageZipPath(), String.format("%s_WORKFLOWS_USAGE_REPORT", type.toUpperCase()) + "_" + FORMATTER.format(LocalDateTime.now()) + ".zip");
        CompressionUtils.compressToZip(WorkflowsUsagePackageFile.getWorkflowsUsageBasePath(type), zipPath);
        return zipPath;
    }

    @Override
    public WorkflowsUsageTask getRestrictionsWorkflowUsageReportTask() {
        RestrictionsWorkflowReportTaskRecord restrictionsWorkflowsReportTaskRecord = this.workflowsUsageReportAccessor.getRestrictionsWorkflowsReportTaskRecord();
        return this.workflowsUsageTaskMapper.fromRestrictionsWorkflowsRecordToModel(restrictionsWorkflowsReportTaskRecord);
    }

    @Override
    public void saveRestrictionsWorkflowsUsageReportTask(WorkflowsUsageTask workflowsUsageTask) {
        RestrictionsWorkflowReportTaskRecord pageWorkflowReportTaskRecord = this.workflowsUsageTaskMapper.fromModelToRestrictionsWorkflowsRecord(workflowsUsageTask);
        this.workflowsUsageReportAccessor.saveRestrictionsWorkflowsReportTaskRecord(pageWorkflowReportTaskRecord);
    }

    @Override
    public List<RestrictionsContentWorkflowReportEntry> getRestrictionsContentWorkflowsReport(List<String> spaceKeys) {
        List<ContentRestrictionWorkflowRecord> restrictionsContentWorkflowReportEntries = this.contentRestrictionWorkflowRecordAccessor.findAllContentRestrictionSpaceWorkflows(spaceKeys);
        restrictionsContentWorkflowReportEntries.addAll(this.contentRestrictionWorkflowRecordAccessor.findAllContentInheritedRestrictionSpaceWorkflows(spaceKeys));
        return restrictionsContentWorkflowReportEntries.stream().map(RestrictionsContentWorkflowReportEntry::map).collect(Collectors.toList());
    }

    private Date getLastPageUpdate(String spaceKey) {
        String cql = String.format(CQL_LAST_PAGE_UPDATE, spaceKey);
        PageResponse results = this.cqlSearchService.searchContent(cql, (PageRequest)new SimplePageRequest(0, 1), CQLExpansionParser.parse(StringUtils.join(Collections.singletonList("version"), (String)",")));
        if (!results.getResults().isEmpty()) {
            Content content = (Content)results.getResults().get(0);
            return VersionConf9Compatibility.getWhen(content.getVersion());
        }
        return null;
    }

    private Long getTotalPagesWithLabel(String spaceKey, List<Label> labels, boolean invertLabels) {
        String cql = this.buildCqlWithLabels(spaceKey, labels, invertLabels);
        return this.cqlSearchService.countContent(cql);
    }

    private String buildCqlWithLabels(String spaceKey, List<Label> labels, boolean invertLabels) {
        String joinedLabels = labels.stream().map(label -> String.format("'%s'", label.getName())).collect(Collectors.joining(","));
        if (!invertLabels) {
            return String.format("space='%s' and label in (%s)", spaceKey, joinedLabels);
        }
        return String.format("space='%s' and label not in (%s)", spaceKey, joinedLabels);
    }

    private Long getTotalPages(String spaceKey) {
        String cql = String.format(CQL_TOTAL_PAGES, spaceKey);
        return this.cqlSearchService.countContent(cql);
    }

    private boolean isCloudJSONOversized(SpaceWorkflowInstance spaceWorkflowInstance) {
        try {
            int sizeInBytes;
            Workflow workflow = this.workflowMarkupManager.parseFromWikiMarkup(spaceWorkflowInstance.getMarkup());
            CloudTranslation cloudTranslation = this.workflowMarkupManager.getCloudTranslation(workflow);
            String jsonWorkflow = new JSONObject(cloudTranslation.getWorkflow()).toString();
            Optional<String> hasErrorsCloudJson = this.workflowMarkupManager.validateJsonMarkup(new JSONObject(cloudTranslation.getWorkflow()).toString(), "/workflows/cloud-schema-workflow.json");
            if (hasErrorsCloudJson.isEmpty() && (sizeInBytes = jsonWorkflow.getBytes(StandardCharsets.UTF_8).length) >= 30720) {
                return true;
            }
        }
        catch (WorkflowException e) {
            log.error("Error checking cloud json markup size limit", (Throwable)e);
        }
        return false;
    }
}

