/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

public class Instructions {
    private String title;
    private String body;
    private Style style;

    public Instructions(String title, String body, Style style) {
        this.title = title;
        this.body = body;
        this.style = style == null ? Style.DEFAULT : style;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public Style getStyle() {
        return this.style;
    }

    public static enum Style {
        GENERIC("generic"),
        ERROR("error"),
        WARNING("warning"),
        SUCCESS("success"),
        INFO("info"),
        TIP("success"),
        NOTE("info"),
        HINT("hint");

        public static Style DEFAULT;
        private String styleClass;

        private Style(String styleClass) {
            this.styleClass = styleClass;
        }

        public static Style parse(String name) {
            for (Style style : Style.values()) {
                if (!style.name().equalsIgnoreCase(name)) continue;
                return style;
            }
            return null;
        }

        public String toString() {
            return this.styleClass;
        }

        static {
            DEFAULT = INFO;
        }
    }
}

