/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions.metadata;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataUtils {
    private static final Logger log = LoggerFactory.getLogger(MetadataUtils.class);
    private static final String DOCUMENT_VERSIONING_PATTERN = "\\d+|[^d]";
    private static final String IS_NUMERIC_PATTERN = "-?\\d+(\\.\\d+)?";
    private static final String DIGIT_PATTERN = "\\d";

    public static String incrementMetadataVersion(String increment, String version) {
        if (!MetadataUtils.hasDigit(version)) {
            return version;
        }
        Pattern pattern = Pattern.compile(DOCUMENT_VERSIONING_PATTERN);
        Matcher versionTokens = pattern.matcher(version);
        if (increment == null) {
            increment = version.replaceAll("\\d+", "0");
            increment = increment.replaceAll("0([^0]*)$", "1$1");
        }
        Matcher increments = pattern.matcher(increment);
        if (versionTokens.groupCount() != increments.groupCount()) {
            log.info("increment and metadata version format mismatch");
            return version;
        }
        StringBuffer newVersion = new StringBuffer("");
        boolean reset = false;
        while (versionTokens.find() && increments.find()) {
            String versionValue = versionTokens.group();
            if (MetadataUtils.isNumeric(versionValue)) {
                String incrementValue = increments.group();
                if (!MetadataUtils.isNumeric(incrementValue)) {
                    log.info("increment value is not a number");
                    return version;
                }
                if (reset) {
                    versionValue = "0";
                }
                newVersion.append(Integer.valueOf(versionValue) + Integer.valueOf(incrementValue));
                reset = reset || Integer.valueOf(incrementValue) > 0;
                continue;
            }
            newVersion.append(versionValue);
        }
        return newVersion.toString();
    }

    public static boolean isNumeric(String strNum) {
        Pattern pattern = Pattern.compile(IS_NUMERIC_PATTERN);
        if (strNum == null) {
            return false;
        }
        return pattern.matcher(strNum).matches();
    }

    public static boolean hasDigit(String strNum) {
        Pattern pattern = Pattern.compile(DIGIT_PATTERN);
        if (strNum == null) {
            return false;
        }
        return pattern.matcher(strNum).find();
    }
}

