/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.accesor.PageWorkflowsAccessor;
import com.comalatech.confluence.workflow.model.WorkflowParameter;
import com.comalatech.confluence.workflow.parser.WorkflowParser;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.template.LinkedTemplateManager;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultWorkflowService
implements WorkflowService {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowService.class);
    public static final String SPACE_WORKFLOW_ID = "spaceworkflow-";
    public static final String SPACE_WORKFLOW_TEMPLATE_ID = "spaceworkflowtemplate-";
    public static final String LINKED_GLOBAL_TEMPLATE_ID = "linkedglobaltemplate-";
    public static final String GLOBAL_TEMPLATE_ID = "globaltemplate-";
    private final WorkflowContainerManager workflowContainerManager;
    private final LinkedTemplateManager linkedTemplateManager;
    private final WorkflowParser workflowParser;
    private final WorkflowTemplateManager workflowTemplateManager;
    private final SpaceManager spaceManager;
    private final AdhocWorkflowManager adhocWorkflowManager;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final ComalaI18nBean comalaI18nBean;
    private final PageWorkflowsAccessor pageWorkflowsAccessor;

    public DefaultWorkflowService(WorkflowContainerManager workflowContainerManager, LinkedTemplateManager linkedTemplateManager, WorkflowParser workflowParser, @Qualifier(value="workflowTemplateManager") WorkflowTemplateManager workflowTemplateManager, @ComponentImport SpaceManager spaceManager, AdhocWorkflowManager adhocWorkflowManager, WorkflowsFeatureManager workflowsFeatureManager, ComalaI18nBean comalaI18nBean, PageWorkflowsAccessor pageWorkflowsAccessor) {
        this.workflowContainerManager = workflowContainerManager;
        this.linkedTemplateManager = linkedTemplateManager;
        this.workflowParser = workflowParser;
        this.workflowTemplateManager = workflowTemplateManager;
        this.spaceManager = spaceManager;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.comalaI18nBean = comalaI18nBean;
        this.pageWorkflowsAccessor = pageWorkflowsAccessor;
    }

    @Override
    public List<com.comalatech.workflow.model.Workflow> getWorkflows(String spaceKey) {
        List<com.comalatech.workflow.model.Workflow> linkedWorkflows = this.linkedTemplateManager.getLinkedTemplates(spaceKey);
        for (com.comalatech.workflow.model.Workflow workflow : linkedWorkflows) {
            ((Workflow)workflow).setHandle(DefaultWorkflowService.createHandle(Workflow.WorkflowType.LINKED_SPACE, workflow));
            ((Workflow)workflow).setType(Workflow.WorkflowType.LINKED_SPACE);
            ((Workflow)workflow).setActive(this.workflowContainerManager.isGlobalWorkflowTemplateActive(spaceKey, workflow.getName()));
        }
        List<com.comalatech.workflow.model.Workflow> workflows = linkedWorkflows.stream().sorted(Comparator.comparing(com.comalatech.workflow.model.Workflow::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        List<Workflow> spaceWorkflows = this.workflowContainerManager.getAllProductionWorkflows(spaceKey);
        for (Workflow workflow : spaceWorkflows) {
            workflow.setHandle(DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE, workflow));
            workflow.setType(Workflow.WorkflowType.SPACE);
        }
        List sortedLstSpaceWorkflow = spaceWorkflows.stream().sorted(Comparator.comparing(com.comalatech.workflow.model.Workflow::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        workflows.addAll(sortedLstSpaceWorkflow);
        return workflows;
    }

    @Override
    public com.comalatech.workflow.model.Workflow getWorkflow(String spaceKey, String workflowHandle) throws WorkflowException {
        return this.getWorkflowTemplate(spaceKey, workflowHandle);
    }

    @Override
    public String getGlobalWorkflowMarkup(String workflowId) {
        return this.workflowContainerManager.getWorkflowMarkup(this.getNameFromHandle(null, workflowId));
    }

    @Override
    public List<com.comalatech.workflow.model.Workflow> getAvailableWorkflowsTemplates(String spaceKey) {
        ArrayList<com.comalatech.workflow.model.Workflow> workflows = new ArrayList<com.comalatech.workflow.model.Workflow>();
        List<Workflow> globalTemplates = this.workflowContainerManager.getWorkflowTemplates(null);
        List<String> linkedWorkflowNames = this.linkedTemplateManager.getLinkedTemplateNames(spaceKey);
        for (Workflow workflow : globalTemplates) {
            if (linkedWorkflowNames.contains(workflow.getName()) || !workflow.isActive()) continue;
            workflow.setHandle(DefaultWorkflowService.createHandle(Workflow.WorkflowType.GLOBALE_TEMPLATE, workflow));
            workflow.setType(Workflow.WorkflowType.GLOBALE_TEMPLATE);
            workflow.setActive(this.workflowContainerManager.isGlobalWorkflowTemplateActive(spaceKey, workflow.getName()));
            workflows.add(workflow);
        }
        return workflows;
    }

    @Override
    public List<com.comalatech.workflow.model.Workflow> getPageWorkflowTemplates(String spaceKey) {
        ArrayList<com.comalatech.workflow.model.Workflow> templates = new ArrayList<com.comalatech.workflow.model.Workflow>();
        for (com.comalatech.workflow.model.Workflow template : this.workflowTemplateManager.getWorkflowTemplates(this.spaceManager.getSpace(spaceKey))) {
            Workflow spaceTemplate = (Workflow)template;
            spaceTemplate.setHandle(DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE_TEMPLATE, spaceTemplate));
            spaceTemplate.setType(Workflow.WorkflowType.SPACE_TEMPLATE);
            templates.add(spaceTemplate);
        }
        for (com.comalatech.workflow.model.Workflow template : this.workflowTemplateManager.getWorkflowTemplates()) {
            if (!template.isActive()) continue;
            Workflow globalTemplate = (Workflow)template;
            globalTemplate.setHandle(DefaultWorkflowService.createHandle(Workflow.WorkflowType.GLOBALE_TEMPLATE, template));
            globalTemplate.setType(Workflow.WorkflowType.GLOBALE_TEMPLATE);
            globalTemplate.setActive(this.workflowContainerManager.isGlobalWorkflowTemplateActive(spaceKey, template.getName()));
            templates.add(globalTemplate);
        }
        return templates;
    }

    @Override
    public void activateWorkflow(String spaceKey, String workflowId) throws WorkflowException {
        String workflowName = this.getNameFromHandle(spaceKey, workflowId);
        Workflow.WorkflowType type = DefaultWorkflowService.getWorkflowTypeFromHandle(workflowId);
        if (type != null && StringUtils.isNotBlank((CharSequence)workflowName)) {
            switch (type) {
                case GLOBALE_TEMPLATE: {
                    Workflow workflow = this.workflowParser.parseWorkflow(this.adhocWorkflowManager.getWorkflowTemplateBody(null, workflowName));
                    if (workflow != null && StringUtils.isNotBlank((CharSequence)workflow.getErrorMessage())) {
                        throw new WorkflowUserException(workflow.getErrorMessage());
                    }
                    this.linkedTemplateManager.addTemplateLink(spaceKey, workflowName);
                    break;
                }
                case SPACE: {
                    Workflow workflow = this.workflowContainerManager.getProductionWorkflow(spaceKey, workflowName);
                    if (workflow != null && StringUtils.isNotBlank((CharSequence)workflow.getErrorMessage())) {
                        throw new WorkflowUserException(workflow.getErrorMessage());
                    }
                    this.workflowContainerManager.setActiveProductionWorkflow(spaceKey, workflow, true);
                }
            }
        }
    }

    @Override
    public void deactivateWorkflow(String spaceKey, String workflowId) {
        String workflowName = this.getNameFromHandle(spaceKey, workflowId);
        Workflow.WorkflowType type = DefaultWorkflowService.getWorkflowTypeFromHandle(workflowId);
        if (type != null && StringUtils.isNotBlank((CharSequence)workflowName)) {
            switch (type) {
                case GLOBALE_TEMPLATE: 
                case LINKED_SPACE: {
                    this.linkedTemplateManager.removeTemplateLink(spaceKey, workflowName);
                    break;
                }
                case SPACE: {
                    try {
                        Workflow workflow = this.workflowContainerManager.getProductionWorkflow(spaceKey, workflowName);
                        this.workflowContainerManager.setActiveProductionWorkflow(spaceKey, workflow, false);
                        break;
                    }
                    catch (WorkflowException e) {
                        log.error("Error trying to load space workflow  {} : {}", new Object[]{spaceKey, workflowName, e});
                    }
                }
            }
        }
    }

    @Override
    public void hideWorkflowTemplate(String spaceKey, String workflowId) {
        this.toggleWorkflow(spaceKey, workflowId, false);
    }

    @Override
    public void showWorkflowTemplate(String spaceKey, String workflowId) {
        this.toggleWorkflow(spaceKey, workflowId, true);
    }

    private void toggleWorkflow(String spaceKey, String workflowId, boolean show) {
        String workflowName = this.getNameFromHandle(spaceKey, workflowId);
        Workflow.WorkflowType type = DefaultWorkflowService.getWorkflowTypeFromHandle(workflowId);
        if (type != null && StringUtils.isNotBlank((CharSequence)workflowName)) {
            if (type.equals((Object)Workflow.WorkflowType.GLOBALE_TEMPLATE)) {
                if (StringUtils.isNotBlank((CharSequence)spaceKey)) {
                    this.workflowContainerManager.setGlobalWorkflowActive(spaceKey, workflowName, show);
                }
            } else if (type.equals((Object)Workflow.WorkflowType.SPACE_TEMPLATE)) {
                try {
                    Workflow workflow = this.workflowContainerManager.getWorkflowTemplate(spaceKey, workflowName);
                    workflow.setActive(show);
                    this.workflowContainerManager.saveWorkflowTemplate(spaceKey, workflow, false, null);
                }
                catch (WorkflowException e) {
                    log.error("Error trying to change status of space template: {}", (Object)workflowName, (Object)e);
                }
            }
        }
    }

    @Override
    public com.comalatech.workflow.model.Workflow addSpaceWorkflow(String spaceKey, String workflowMarkup) throws WorkflowException {
        if (StringUtils.isNotBlank((CharSequence)workflowMarkup)) {
            Workflow workflow = this.workflowParser.parseWorkflow(workflowMarkup);
            workflow.validateWorkflow();
            if (StringUtils.isNotBlank((CharSequence)workflow.getErrorMessage())) {
                throw new WorkflowUserException("comalatech.awp.designer.error.markup", workflow.getErrorMessage());
            }
            if (!StringUtils.isNotBlank((CharSequence)workflow.getName())) {
                throw new WorkflowUserException("comalatech.awp.designer.error.workflow.name.empty");
            }
            Workflow existingWorkflow = this.workflowContainerManager.getProductionWorkflow(spaceKey, workflow.getName());
            if (existingWorkflow != null) {
                throw new WorkflowException(this.comalaI18nBean.getText("cw.spaceadmin.addWorkflowAlreadyExist"));
            }
            String workflowId = DefaultWorkflowService.createHandle(Workflow.WorkflowType.SPACE, workflow);
            this.workflowContainerManager.saveProductionWorkflow(spaceKey, workflow, null);
            workflow.setType(Workflow.WorkflowType.SPACE);
            workflow.setKey(workflowId);
            return workflow;
        }
        return null;
    }

    @Override
    public com.comalatech.workflow.model.Workflow addGlobalWorkflow(String workflowMarkup) throws WorkflowException {
        if (!StringUtils.isNotBlank((CharSequence)workflowMarkup)) {
            return null;
        }
        Workflow workflow = this.workflowParser.parseWorkflow(workflowMarkup);
        workflow.validateWorkflow();
        if (StringUtils.isNotBlank((CharSequence)workflow.getErrorMessage())) {
            throw new WorkflowUserException("comalatech.awp.designer.error.markup", workflow.getErrorMessage());
        }
        if (!StringUtils.isNotBlank((CharSequence)workflow.getName())) {
            throw new WorkflowUserException("comalatech.awp.designer.error.workflow.name.empty");
        }
        String workflowId = DefaultWorkflowService.createHandle(Workflow.WorkflowType.GLOBALE_TEMPLATE, workflow);
        Workflow existingWorkflow = this.workflowContainerManager.getWorkflowTemplate(null, workflow.getName());
        if (existingWorkflow != null) {
            throw new WorkflowException(this.comalaI18nBean.getText("cw.spaceadmin.addWorkflowAlreadyExist"));
        }
        this.saveWorkflow(null, workflow.getName(), Workflow.WorkflowType.GLOBALE_TEMPLATE, workflow, false);
        workflow.setType(Workflow.WorkflowType.GLOBALE_TEMPLATE);
        workflow.setKey(workflowId);
        return workflow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public com.comalatech.workflow.model.Workflow updateWorkflow(String spaceKey, String workflowHandle, String name, String description, String label, String markup, boolean performWorkflowBackup, boolean addhandle, boolean canEditGlobalTemplate) throws com.comalatech.workflow.WorkflowException {
        Workflow workflow = this.getWorkflowTemplate(spaceKey, workflowHandle);
        if (workflow == null) {
            throw new WorkflowException("Could not find workflow, spacekey: " + spaceKey + " with handle: " + workflowHandle);
        }
        String workflowName = workflow.getName();
        Workflow.WorkflowType type = workflow.getType();
        if (type == null || workflowName == null) return workflow;
        if (type.equals((Object)Workflow.WorkflowType.GLOBALE_TEMPLATE)) {
            if (!canEditGlobalTemplate) throw new WorkflowException("Global template can not be edited for the space: " + spaceKey + " with the handle: " + workflowHandle);
            if (!(workflow = this.saveWorkflow(spaceKey, name, description, label, markup, performWorkflowBackup, workflow, workflowName, type)).getName().equals(workflowName)) {
                List<String> linkedSpaceKeys = this.linkedTemplateManager.getLinkedSpaces(workflowName);
                for (String linkedSpaceKey : linkedSpaceKeys) {
                    this.linkedTemplateManager.removeTemplateLink(linkedSpaceKey, workflowName);
                    this.linkedTemplateManager.addTemplateLink(linkedSpaceKey, workflow.getName());
                }
            }
        } else {
            workflow = this.saveWorkflow(spaceKey, name, description, label, markup, performWorkflowBackup, workflow, workflowName, type);
        }
        workflow.setType(type);
        if (!addhandle) return workflow;
        workflow.setKey(DefaultWorkflowService.createHandle(type, workflow));
        return workflow;
    }

    private Workflow saveWorkflow(String spaceKey, String name, String description, String label, String markup, boolean performWorkflowBackup, Workflow workflow, String workflowName, Workflow.WorkflowType type) throws WorkflowException {
        if (StringUtils.isNotBlank((CharSequence)markup) && !workflow.getWorkflowMarkup().equals(markup)) {
            workflow = this.workflowParser.parseWorkflow(markup);
            workflow.validateWorkflow();
            if (!StringUtils.isNotBlank((CharSequence)workflow.getName())) {
                workflow.setName(workflowName);
            }
            this.saveWorkflow(spaceKey, workflowName, type, workflow, performWorkflowBackup);
        } else {
            if (null != name) {
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    workflow.setName(name);
                } else {
                    throw new WorkflowUserException("comalatech.awp.designer.error.workflow.name.empty");
                }
            }
            if (description != null) {
                workflow.setDescription(description);
            }
            if (label != null) {
                workflow.setLabels(StringUtils.isNotBlank((CharSequence)label) ? Collections.singletonList(LabelParser.parse((String)label).toLabel()) : Collections.emptyList());
            }
            this.saveWorkflow(spaceKey, workflowName, type, workflow, performWorkflowBackup);
        }
        return workflow;
    }

    @Override
    public com.comalatech.workflow.model.Workflow updateWorkflow(String spaceKey, String workflowHandle, String name, String description, String label, String markup, boolean canEditGlobalTemplate) throws com.comalatech.workflow.WorkflowException {
        return this.updateWorkflow(spaceKey, workflowHandle, name, description, label, markup, false, false, canEditGlobalTemplate);
    }

    @Override
    public com.comalatech.workflow.model.Workflow restoreWorkflowBackup(@Nullable String spaceKey, String workflowHandle) throws WorkflowException {
        return this.workflowContainerManager.restoreWorkflowBackup(spaceKey, this.getNameFromHandle(spaceKey, workflowHandle));
    }

    private Workflow getWorkflowTemplate(String spaceKey, String workflowHandle) throws WorkflowException {
        Workflow.WorkflowType type = DefaultWorkflowService.getWorkflowTypeFromHandle(workflowHandle);
        String workflowName = this.getNameFromHandle(spaceKey, workflowHandle);
        Workflow workflow = null;
        if (workflowName != null && type != null) {
            switch (type) {
                case SPACE: {
                    workflow = this.workflowContainerManager.getProductionWorkflow(spaceKey, workflowName);
                    workflow.setType(Workflow.WorkflowType.SPACE);
                    break;
                }
                case SPACE_TEMPLATE: {
                    workflow = this.workflowContainerManager.getWorkflowTemplate(spaceKey, workflowName);
                    workflow.setType(Workflow.WorkflowType.SPACE_TEMPLATE);
                    break;
                }
                case GLOBALE_TEMPLATE: {
                    workflow = this.workflowContainerManager.getWorkflowTemplate(null, workflowName);
                    workflow.setType(Workflow.WorkflowType.GLOBALE_TEMPLATE);
                    break;
                }
            }
        }
        return workflow;
    }

    private void saveWorkflow(String spaceKey, String workflowName, Workflow.WorkflowType type, Workflow workflow, boolean performWorkflowBackup) throws WorkflowException {
        if (!workflow.getName().equals(workflowName) && this.getWorkflow(spaceKey, DefaultWorkflowService.createHandle(type, workflow)) != null) {
            throw new WorkflowException(this.comalaI18nBean.getText("cw.spaceadmin.saveNameConflict"));
        }
        if (StringUtils.isNotBlank((CharSequence)workflow.getErrorMessage())) {
            throw new WorkflowUserException("comalatech.awp.designer.error.markup", workflow.getErrorMessage());
        }
        switch (type) {
            case SPACE: {
                if (performWorkflowBackup) {
                    this.workflowContainerManager.createProductionWorkflowBackup(spaceKey, workflowName, workflow.getName());
                }
                this.workflowContainerManager.saveProductionWorkflow(spaceKey, workflow, workflowName);
                break;
            }
            case SPACE_TEMPLATE: {
                if (performWorkflowBackup) {
                    this.workflowContainerManager.createWorkflowTemplateBackup(spaceKey, workflowName, workflow.getName());
                }
                this.workflowContainerManager.saveWorkflowTemplate(spaceKey, workflow, false, workflowName);
                break;
            }
            case GLOBALE_TEMPLATE: {
                if (performWorkflowBackup) {
                    this.workflowContainerManager.createWorkflowTemplateBackup(spaceKey, workflowName, workflow.getName());
                }
                this.workflowContainerManager.saveWorkflowTemplate(null, workflow, false, workflowName);
            }
        }
    }

    @Override
    public void copyWorkflowToSpace(String spaceKey, String workflowId, boolean active) throws WorkflowException {
        String workflowName = this.getNameFromHandle(spaceKey, workflowId);
        Workflow.WorkflowType type = DefaultWorkflowService.getWorkflowTypeFromHandle(workflowId);
        if (type != null && StringUtils.isNotBlank((CharSequence)workflowName)) {
            switch (type) {
                case GLOBALE_TEMPLATE: 
                case LINKED_SPACE: {
                    Workflow template = this.workflowContainerManager.getWorkflowTemplate(null, workflowName);
                    if (this.workflowsFeatureManager.isWorkflowsLiteApp()) {
                        template = this.getRecreatedWorkflowTemplateWithNonEditableParameters(template);
                    }
                    this.workflowContainerManager.promoteProductionWorkflow(spaceKey, template);
                    if (active) break;
                    Workflow workflow = this.workflowContainerManager.getProductionWorkflow(spaceKey, workflowName);
                    this.workflowContainerManager.setActiveProductionWorkflow(spaceKey, workflow, active);
                    break;
                }
                case SPACE: {
                    Workflow workflow = this.workflowContainerManager.getProductionWorkflow(spaceKey, workflowName);
                    this.workflowContainerManager.copyProductionWorkflow(spaceKey, workflow);
                    if (active) break;
                    this.workflowContainerManager.setActiveProductionWorkflow(spaceKey, workflow, active);
                }
            }
        }
    }

    private Workflow getRecreatedWorkflowTemplateWithNonEditableParameters(Workflow template) throws WorkflowException {
        return new Workflow(template.getParameters(), template.getOrderedElementList().stream().map(workflowElement -> {
            if (workflowElement instanceof WorkflowParameter) {
                WorkflowParameter workflowParameter = (WorkflowParameter)workflowElement;
                return new WorkflowParameter(workflowParameter.getName(), workflowParameter.getDescription(), workflowParameter.getType(), workflowParameter.getValue(), workflowParameter.getOptionsList(), false);
            }
            return workflowElement;
        }).collect(Collectors.toList()), template.getProperties());
    }

    @Override
    public com.comalatech.workflow.model.Workflow deleteWorkflow(String spaceKey, String workflowId) {
        String workflowName = this.getNameFromHandle(spaceKey, workflowId);
        Workflow.WorkflowType type = DefaultWorkflowService.getWorkflowTypeFromHandle(workflowId);
        Workflow workflow = null;
        if (type != null && workflowName != null) {
            try {
                workflow = this.getWorkflowTemplate(spaceKey, workflowId);
                switch (type) {
                    case SPACE: {
                        this.workflowContainerManager.removeProductionWorkflow(spaceKey, workflowName);
                        break;
                    }
                    case SPACE_TEMPLATE: {
                        this.workflowTemplateManager.removeWorkflowTemplate(this.spaceManager.getSpace(spaceKey), workflowName);
                        break;
                    }
                }
                workflow.setType(type);
            }
            catch (WorkflowException e) {
                log.error("Error trying to delete workflow, spaceKey: {} handle: {}  name: {}", new Object[]{spaceKey, workflowId, workflowName, e});
            }
        }
        return workflow;
    }

    @Override
    public String getNameFromHandle(String spaceKey, String workflowId) {
        if (workflowId.startsWith(SPACE_WORKFLOW_ID)) {
            return this.getNameFromHandle(spaceKey, SPACE_WORKFLOW_ID, workflowId);
        }
        if (workflowId.startsWith(GLOBAL_TEMPLATE_ID)) {
            return this.getNameFromHandle(spaceKey, GLOBAL_TEMPLATE_ID, workflowId);
        }
        if (workflowId.startsWith(LINKED_GLOBAL_TEMPLATE_ID)) {
            return this.getNameFromHandle(spaceKey, LINKED_GLOBAL_TEMPLATE_ID, workflowId);
        }
        if (workflowId.startsWith(SPACE_WORKFLOW_TEMPLATE_ID)) {
            return this.getNameFromHandle(spaceKey, SPACE_WORKFLOW_TEMPLATE_ID, workflowId);
        }
        return null;
    }

    @Override
    public List<com.comalatech.workflow.model.Workflow> filterOnlyValidWorkflows(List<com.comalatech.workflow.model.Workflow> workflows) {
        return workflows.stream().filter(workflow -> {
            if (StringUtils.isNotBlank((CharSequence)workflow.getErrorMessage())) {
                log.warn("Workflow '{}' is not valid and has been filtered out from result list", (Object)workflow.getName());
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    protected String getNameFromHandle(String spaceKey, String prefix, String workflowId) {
        if (workflowId.length() > prefix.length()) {
            String workflowNameHashCode = workflowId.substring(prefix.length());
            switch (prefix) {
                case "linkedglobaltemplate-": {
                    List<com.comalatech.workflow.model.Workflow> linkedTemplates = this.linkedTemplateManager.getLinkedTemplates(spaceKey);
                    for (com.comalatech.workflow.model.Workflow linkedTemplate : linkedTemplates) {
                        if (!workflowNameHashCode.equals("" + linkedTemplate.getName().hashCode())) continue;
                        return linkedTemplate.getName();
                    }
                    break;
                }
                case "spaceworkflow-": {
                    List<Workflow> spaceWorkflows = this.workflowContainerManager.getAllProductionWorkflows(spaceKey);
                    for (com.comalatech.workflow.model.Workflow workflow : spaceWorkflows) {
                        if (!workflowNameHashCode.equals("" + workflow.getName().hashCode())) continue;
                        return workflow.getName();
                    }
                    break;
                }
                case "globaltemplate-": {
                    List<Workflow> globalTemplates = this.workflowContainerManager.getWorkflowTemplates(null);
                    for (com.comalatech.workflow.model.Workflow workflow : globalTemplates) {
                        if (!workflowNameHashCode.equals("" + workflow.getName().hashCode())) continue;
                        return workflow.getName();
                    }
                    break;
                }
                case "spaceworkflowtemplate-": {
                    List<com.comalatech.workflow.model.Workflow> globalTemplates = this.workflowTemplateManager.getWorkflowTemplates(this.spaceManager.getSpace(spaceKey));
                    for (com.comalatech.workflow.model.Workflow workflow : globalTemplates) {
                        if (!workflowNameHashCode.equals("" + workflow.getName().hashCode())) continue;
                        return workflow.getName();
                    }
                    break;
                }
            }
        }
        return null;
    }

    public static String createHandle(Workflow.WorkflowType type, com.comalatech.workflow.model.Workflow workflow) {
        return DefaultWorkflowService.getHandlePrefixFromType(type) + workflow.getName().hashCode();
    }

    protected static Workflow.WorkflowType getWorkflowTypeFromHandle(String workflowId) {
        if (workflowId.startsWith(SPACE_WORKFLOW_ID)) {
            return Workflow.WorkflowType.SPACE;
        }
        if (workflowId.startsWith(GLOBAL_TEMPLATE_ID)) {
            return Workflow.WorkflowType.GLOBALE_TEMPLATE;
        }
        if (workflowId.startsWith(LINKED_GLOBAL_TEMPLATE_ID)) {
            return Workflow.WorkflowType.LINKED_SPACE;
        }
        if (workflowId.startsWith(SPACE_WORKFLOW_TEMPLATE_ID)) {
            return Workflow.WorkflowType.SPACE_TEMPLATE;
        }
        return null;
    }

    protected static String getHandlePrefixFromType(Workflow.WorkflowType type) {
        if (Workflow.WorkflowType.SPACE.equals((Object)type)) {
            return SPACE_WORKFLOW_ID;
        }
        if (Workflow.WorkflowType.GLOBALE_TEMPLATE.equals((Object)type)) {
            return GLOBAL_TEMPLATE_ID;
        }
        if (Workflow.WorkflowType.LINKED_SPACE.equals((Object)type)) {
            return LINKED_GLOBAL_TEMPLATE_ID;
        }
        if (Workflow.WorkflowType.SPACE_TEMPLATE.equals((Object)type)) {
            return SPACE_WORKFLOW_TEMPLATE_ID;
        }
        return "";
    }

    @Override
    public boolean hasPageWorkflows(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return false;
        }
        List<String> keys = this.workflowsFeatureManager.getPageWorkflowPropertyKeys();
        return this.pageWorkflowsAccessor.hasPageWorkflows(space.getId(), keys);
    }

    @Override
    public List<String> getSpacesWithWorkflows(Set<String> spaceKeys) {
        return spaceKeys.stream().filter(spaceKey -> {
            List<com.comalatech.workflow.model.Workflow> workflows = this.getWorkflows((String)spaceKey);
            if (workflows != null && !workflows.isEmpty()) {
                return true;
            }
            if (this.hasPageWorkflows((String)spaceKey)) {
                return true;
            }
            log.warn("Space {} does not use Comala Document Management", spaceKey);
            return false;
        }).collect(Collectors.toList());
    }
}

