/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.translator.domain;

import com.comalatech.confluence.translator.domain.ActionMapper;
import com.comalatech.confluence.translator.domain.CloudTranslation;
import com.comalatech.confluence.translator.domain.TriggerMacro;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ServerWorkflow {
    private static final String STATE = "state";
    private static final String APPROVAL = "approval";
    private static final String STATES = "states";
    private static final String UNSUPPORTED_ELEMENTS = "unsupportedElements";
    private static final String UNSUPPORTED_PARAMETERS = "unsupportedParameters";
    private static final String UNSUPPORTED_TRIGGERS = "unsupportedTriggers";
    private static final String UNSUPPORTED_STATES = "unsupportedStates";
    private static final String CONTENT_TYPES = "contentTypes";
    private static final String DISPLAY_PROGRESS_TRACKER = "displayProgressTracker";
    private static final String ID = "id";
    private static final String CUSTOM = "custom";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String COLOUR = "colour";
    private static final String FINAL = "final";
    private static final String DUE_DATE = "dueDate";
    private static final String TRANSITIONS = "transitions";
    private static final String APPROVALS = "approvals";
    private static final String SUBMIT = "submit";
    private static final String SELECT = "select";
    private static final String WORKFLOW = "workflow";
    private static final String LABEL = "label";
    private static final String LABELS = "labels";
    private static final String STICKY_LABELS = "stickyLabels";
    private static final String TRIGGERS = "triggers";
    private static final String NAMES = "stateNames";
    private static final String INVERT_LABELS = "invertLabels";
    private static final String EXCLUDED_LABELS = "excludedLabels";
    private static final String WORKFLOW_PARAMETER = "workflowparameter";
    private static final String PARAMETERS = "parameters";
    private static final String EDITABLE = "editable";
    private static final String TYPE = "type";
    private static final String LIST = "list";
    private static final String OPTIONS = "options";
    private static final String VALUE = "value";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String SCOPE = "scope";
    private static final String SCOPE_VALUE_WORKFLOW = "workflow";
    private static final String SCOPE_VALUE_PAGE = "page";
    private static final String APPROVE_LABEL = "approveLabel";
    private static final String REJECT_LABEL = "rejectLabel";
    private static final String MINIMUM = "minimum";
    private static final String CREDENTIALS = "credentials";
    private static final String ASSIGNABLE = "assignable";
    private static final String USERS = "users";
    private static final String GROUPS = "groups";
    private static final String SELECTED_APPROVER = "selectedApprover";
    private static final String SELECTED_APPROVERS = "selectedApprovers";
    private static final String USER_PASSWORD = "user+password";
    private static final String PREASSIGNED_USERS = "preassignedUsers";
    private static final String ITEMS = "items";
    private static final String PREASSIGNED_GROUPS = "preassignedGroups";
    private static final String CONDITIONS = "conditions";
    private static final String PAGE_APPROVAL_ASSIGNED = "pageapprovalassigned";
    private static final String STATE_CHANGED = "statechanged";
    private static final String APPROVAL_UNASSIGNED = "approvalunassigned";
    private static final String PAGE_APPROVED = "pageapproved";
    private static final String STATE_EXPIRED = "stateexpired";
    private static final String PAGE_REJECTED = "pagerejected";
    private static final String SET_STATE = "set-state";
    private static final String PUBLISH_PAGE = "publish-page";
    private static final String APPROVE_PAGE = "approve-page";
    private static final String REJECT_PAGE = "reject-page";
    private static final String SET_STATE_EXPIRY = "set-state-expiry";
    private static final String SET_MESSAGE = "set-message";
    private static final String SEND_EMAIL = "send-email";
    private static final String REMOVE_RESTRICTIONS = "remove-restriction";
    private static final String SET_LABEL = "set-label";
    private static final String REMOVE_LABEL = "remove-label";
    private static final String ADD_RESTRICTION = "add-restriction";
    private static final String SET_RESTRICTION = "set-restrictions";
    private static final Set<String> ROOT_ELEMENTS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("active", "blobTriggers", "key"));
    private static final Set<String> APPROVAL_PARAMETERS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("visibleContentTypes", "conditions"));
    private static final Set<String> WORKFLOW_UNSUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("adminUsers", "updateStatus", "hasLabel"));
    private static final Set<String> WORKFLOW_UNSUPPORTED_SPECIAL_PARAMETERS = new HashSet<String>(Arrays.asList("contentTypes", "displayProgressTracker"));
    private static final Set<String> ROOT_SUPPORTED_ELEMENTS = new HashSet<String>(Arrays.asList("name", "description", "labels", "invertLabels", "stickyLabels", "states", "parameters", "triggers"));
    private static final Set<String> STATE_SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("name", "description", "colour", "final", "dueDate", "transitions", "approvals"));
    private static final Set<String> APPROVAL_SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("name", "approveLabel", "rejectLabel", "minimum", "credentials", "assignable", "users", "groups", "selectedApprover", "selectedApprovers", "preassignedUsers", "preassignedGroups"));
    private static final Set<String> TRIGGER_SUPPORTED_EVENTS = new HashSet<String>(Arrays.asList("pageapprovalassigned", "statechanged", "approvalunassigned", "pageapproved", "stateexpired", "pagerejected"));
    private static final Set<String> TRIGGER_SUPPORTED_MACROS = new HashSet<String>(Arrays.asList("set-state", "publish-page", "approve-page", "reject-page", "set-state-expiry", "set-message", "send-email", "remove-restriction", "set-label", "remove-label", "add-restriction", "set-restrictions"));
    static final Map<String, String> CLOUD_TRIGGER_SUPPORTED_ACTIONS = Map.ofEntries(Map.entry("set-state", "change-state"), Map.entry("publish-page", "publish-page"), Map.entry("approve-page", "approve"), Map.entry("reject-page", "reject"), Map.entry("set-state-expiry", "set-expiration"), Map.entry("set-message", "set-message"), Map.entry("send-email", "send-email"), Map.entry("remove-restriction", "remove-restrictions"), Map.entry("set-label", "add-labels"), Map.entry("remove-label", "remove-labels"), Map.entry("add-restriction", "add-restrictions"), Map.entry("set-restrictions", "set-restrictions"));
    private static final Map<String, String> CLOUD_TRIGGER_SUPPORTED_EVENTS = Map.ofEntries(Map.entry("approval-assigned", "on-assign"), Map.entry("state-changed", "on-change-state"), Map.entry("approval-unassigned", "on-unassign"), Map.entry("approval-approved", "on-approve"), Map.entry("state-expired", "on-expire"), Map.entry("approval-rejected", "on-reject"));
    private static final Map<String, String> UNSUPPORTED_KEYS_DICTIONARY = Map.ofEntries(Map.entry("pageFooter", "pagefooter"), Map.entry("instructions", "workflow-instructions"), Map.entry("readAck", "read-ack"), Map.entry("triggers", "trigger"), Map.entry("changeDueDate", "changeduedate"), Map.entry("hideFromPath", "hidefrompath"), Map.entry("contentTypes", "content"), Map.entry("hideSelection", "hideselection"), Map.entry("displayProgressTracker", "progresstracker"), Map.entry("versionsCompleted", "versionscompleted"), Map.entry("pageHeader", "pageheader"), Map.entry("hasLabel", "haslabel"), Map.entry("tasks", "task"), Map.entry("adminUsers", "adminusers"), Map.entry("updateStatus", "updatestatus"), Map.entry("rememberAssignees", "rememberassignees"), Map.entry("allowedAssignGroups", "allowedassigngroups"), Map.entry("allowedAssignUsers", "allowedassignusers"));
    private final Map<String, Object> workflow;

    public CloudTranslation toCloud() {
        Set<Object> unsupportedParameters = this.getUnsupportedParameters();
        Set<Object> rootUnsupportedElements = this.getRootUnsupportedElements();
        HashSet<Object> unsupportedTriggers = this.getUnsupportedTriggers();
        ConcurrentHashMap.KeySetView unsupportedTriggerMacros = ConcurrentHashMap.newKeySet();
        Set<Object> unsupportedMacroParameters = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView unsupportedStates = ConcurrentHashMap.newKeySet();
        LinkedHashMap<String, Object> cloudWorkflow = new LinkedHashMap<String, Object>();
        cloudWorkflow.put(ID, CUSTOM);
        ServerWorkflow.addName(this.workflow, cloudWorkflow);
        ServerWorkflow.addDescription(this.workflow, cloudWorkflow);
        ServerWorkflow.addLabels(this.workflow, cloudWorkflow);
        ServerWorkflow.addStickyLabels(this.workflow, cloudWorkflow);
        ServerWorkflow.addInvertLabel(this.workflow, cloudWorkflow);
        cloudWorkflow.put(PARAMETERS, this.getCloudParameters(unsupportedParameters));
        List<Map<String, Object>> cloudStates = this.getCloudStates(unsupportedParameters);
        List<String> stateNames = cloudStates.stream().map(stateMap -> (String)stateMap.get(NAME)).filter(Objects::nonNull).collect(Collectors.toList());
        cloudWorkflow.put(STATES, cloudStates);
        List<Map<String, Object>> cloudTriggers = this.getCloudTriggers(stateNames, unsupportedTriggerMacros, unsupportedMacroParameters, unsupportedStates);
        if (!cloudTriggers.isEmpty()) {
            cloudWorkflow.put(TRIGGERS, cloudTriggers);
        }
        CloudTranslation cloudTranslation = CloudTranslation.builder().workflow(cloudWorkflow).messages(new HashMap<String, Set<Object>>()).build();
        if (!rootUnsupportedElements.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(rootUnsupportedElements);
            cloudTranslation.addErrors(UNSUPPORTED_ELEMENTS, rootUnsupportedElements);
        }
        if (!unsupportedParameters.isEmpty()) {
            cloudTranslation.addErrors(UNSUPPORTED_PARAMETERS, unsupportedParameters);
        }
        if (!unsupportedTriggerMacros.isEmpty()) {
            unsupportedTriggers.add(Collections.singletonMap("macros", unsupportedTriggerMacros));
        }
        unsupportedMacroParameters.removeIf(map -> map instanceof Map && ((Map)map).isEmpty());
        if (!unsupportedMacroParameters.isEmpty()) {
            unsupportedMacroParameters = this.filterMacroParameters(unsupportedMacroParameters);
            unsupportedTriggers.add(Collections.singletonMap("macroParameters", unsupportedMacroParameters));
        }
        if (!unsupportedTriggers.isEmpty()) {
            cloudTranslation.addErrors(UNSUPPORTED_TRIGGERS, unsupportedTriggers);
        }
        if (!unsupportedStates.isEmpty()) {
            cloudTranslation.addErrors(UNSUPPORTED_STATES, unsupportedStates);
        }
        return cloudTranslation;
    }

    private Set<Object> filterMacroParameters(Set<Object> unsupportedMacroParameters) {
        return unsupportedMacroParameters.stream().filter(LinkedHashMap.class::isInstance).map(obj -> (LinkedHashMap)obj).flatMap(map -> map.entrySet().stream()).collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (list1, list2) -> {
            list1.addAll(list2);
            return list1.stream().distinct().collect(Collectors.toList());
        }, LinkedHashMap::new), mergedMap -> {
            HashSet<LinkedHashMap> newSet = new HashSet<LinkedHashMap>();
            newSet.add((LinkedHashMap)mergedMap);
            return newSet;
        }));
    }

    private List<Map<String, Object>> getCloudParameters(Set<Object> unsupportedParameters) {
        Collection parameters = (Collection)this.workflow.get(PARAMETERS);
        if (parameters == null) {
            return Collections.emptyList();
        }
        return parameters.parallelStream().map(e -> (Map)e).map(parameter -> {
            Boolean editable;
            String options;
            HashMap<String, Object> cloudParameter = new HashMap<String, Object>();
            ServerWorkflow.addName(parameter, cloudParameter);
            ServerWorkflow.addDescription(parameter, cloudParameter);
            String type = (String)parameter.get(TYPE);
            if (null != type) {
                cloudParameter.put(TYPE, OPTIONS.equals(type) ? LIST : type);
            }
            cloudParameter.put(LABEL, parameter.get(NAME));
            String value = (String)parameter.get(VALUE);
            if (null != value) {
                cloudParameter.put(DEFAULT_VALUE, value);
            }
            if (null != (options = (String)parameter.get(OPTIONS))) {
                cloudParameter.put(OPTIONS, options);
            }
            if (null != (editable = (Boolean)parameter.get(EDITABLE)) && editable.booleanValue()) {
                cloudParameter.put(SCOPE, SCOPE_VALUE_PAGE);
            } else {
                cloudParameter.put(SCOPE, "workflow");
            }
            return cloudParameter;
        }).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getCloudTriggers(List<String> stateNames, Set<Object> unsupportedTriggerMacros, Set<Object> unsupportedMacroParameters, Set<Object> unsupportedStates) {
        Collection triggers = (Collection)this.workflow.get(TRIGGERS);
        if (triggers == null) {
            return new ArrayList<Map<String, Object>>();
        }
        return triggers.stream().map(e -> (Map)e).map(trigger -> {
            Object actionsObj = trigger.get("actions");
            String actions = actionsObj == null ? "" : actionsObj.toString();
            Map cloudTrigger = Collections.synchronizedMap(new LinkedHashMap());
            Map event = (Map)trigger.get("event");
            CLOUD_TRIGGER_SUPPORTED_EVENTS.keySet().forEach(key -> {
                if (event.get(NAME).toString().equals(key)) {
                    cloudTrigger.put("event", CLOUD_TRIGGER_SUPPORTED_EVENTS.get(key));
                    List conditions = (List)trigger.get(CONDITIONS);
                    ArrayList<Map<String, String>> cloudConditions = new ArrayList<Map<String, String>>();
                    if (event.get(TYPE).equals(STATE)) {
                        if (stateNames.contains(event.get(STATE).toString())) {
                            cloudConditions.add(Collections.singletonMap(STATE, event.get(STATE).toString()));
                        } else {
                            unsupportedStates.add(event.get(STATE).toString());
                        }
                    } else if (conditions != null) {
                        Map firstCondition = (Map)conditions.get(0);
                        for (Map condition : conditions) {
                            if (!cloudConditions.isEmpty() || !condition.get(TYPE).equals(STATE)) continue;
                            if (stateNames.contains(condition.get(VALUE).toString())) {
                                HashMap<String, String> cloudCondition = new HashMap<String, String>();
                                cloudCondition.put(firstCondition.get(TYPE).toString(), firstCondition.get(VALUE).toString());
                                cloudConditions.add(cloudCondition);
                                continue;
                            }
                            unsupportedStates.add(condition.get(VALUE).toString());
                        }
                    }
                    if (!cloudConditions.isEmpty()) {
                        cloudTrigger.put(CONDITIONS, cloudConditions);
                    }
                    List<Map<String, Object>> cloudActions = this.getCloudTriggerActions(actions);
                    cloudActions.removeIf(map -> {
                        String stateValue;
                        if ("change-state".equals(map.get("action")) && ((stateValue = map.get(STATE).toString()) == null || !stateNames.contains(stateValue))) {
                            if (stateValue != null) {
                                unsupportedStates.add(stateValue);
                            }
                            return true;
                        }
                        return false;
                    });
                    cloudTrigger.put("actions", cloudActions);
                    unsupportedMacroParameters.addAll(this.getActionsUnsupportedParameters(actions));
                    unsupportedTriggerMacros.addAll(this.getUnsupportedTriggerMacros(actions));
                }
            });
            return cloudTrigger.isEmpty() ? null : cloudTrigger;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private HashSet<Object> getUnsupportedTriggers() {
        HashSet<Object> unsupportedTriggers = new HashSet<Object>();
        Set<Object> triggersUnsupportedEvents = Collections.synchronizedSet(new HashSet());
        Set<Object> triggersUnsupportedConditions = Collections.synchronizedSet(new HashSet());
        String markupTriggers = (String)this.workflow.get("blobTriggers");
        if (markupTriggers != null) {
            String triggerEvents = "trigger:([^|}]+)\\|";
            Pattern eventPattern = Pattern.compile(triggerEvents);
            Matcher eventMatcher = eventPattern.matcher(markupTriggers);
            while (eventMatcher.find()) {
                if (eventMatcher.group(1) == null || TRIGGER_SUPPORTED_EVENTS.contains(eventMatcher.group(1))) continue;
                triggersUnsupportedEvents.add(eventMatcher.group(1));
            }
            String triggerConditions = "(?<=\\{trigger[^}]*\\|)([^|=]+)(?==)";
            Pattern conditionPattern = Pattern.compile(triggerConditions);
            Matcher conditionMatcher = conditionPattern.matcher(markupTriggers);
            while (conditionMatcher.find()) {
                if (conditionMatcher.group(1) == null || conditionMatcher.group(1).equals(STATE)) continue;
                triggersUnsupportedConditions.add(conditionMatcher.group(1));
            }
        }
        if (!triggersUnsupportedEvents.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(triggersUnsupportedEvents);
            unsupportedTriggers.add(Collections.singletonMap("events", triggersUnsupportedEvents));
        }
        if (!triggersUnsupportedConditions.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(triggersUnsupportedConditions);
            unsupportedTriggers.add(Collections.singletonMap(CONDITIONS, triggersUnsupportedConditions));
        }
        return unsupportedTriggers;
    }

    private List<Map<String, Object>> getCloudTriggerActions(String macros) {
        return this.parseTriggerMacroOrParams(macros, true);
    }

    private List<Map<String, Object>> getActionsUnsupportedParameters(String macros) {
        return this.parseTriggerMacroOrParams(macros, false);
    }

    private List<Map<String, Object>> parseTriggerMacroOrParams(String macros, boolean isParsingMacro) {
        if (macros == null) {
            return new ArrayList<Map<String, Object>>();
        }
        List<TriggerMacro> supportedMacros = this.parseTriggerMacro(macros, true);
        return supportedMacros.stream().map(macro -> this.getAction((TriggerMacro)macro, isParsingMacro)).collect(Collectors.toList());
    }

    private Set<Object> getUnsupportedTriggerMacros(String macros) {
        List<TriggerMacro> supportedMacros = this.parseTriggerMacro(macros, false);
        return supportedMacros.stream().map(TriggerMacro::getName).collect(Collectors.toSet());
    }

    private List<TriggerMacro> parseTriggerMacro(String macros, boolean isSupported) {
        String MACRO_REGEX = "\\{([a-zA-Z-]+):?[^{}]*?\\}(.*?)\\{\\1\\}|\\{([^{}]+)\\}";
        String MACRO_NAME_REGEX = "\\{([^:}]+)";
        Pattern macroPattern = Pattern.compile("\\{([a-zA-Z-]+):?[^{}]*?\\}(.*?)\\{\\1\\}|\\{([^{}]+)\\}", 32);
        Pattern macroNamePattern = Pattern.compile("\\{([^:}]+)");
        Matcher macroMatcher = macroPattern.matcher(macros);
        ArrayList<TriggerMacro> triggerMacros = new ArrayList<TriggerMacro>();
        while (macroMatcher.find()) {
            String body;
            List<String> parameters;
            String macro = macroMatcher.group(0);
            Matcher nameMatcher = macroNamePattern.matcher(macro);
            if (!nameMatcher.find()) continue;
            String macroName = nameMatcher.group(1);
            if (isSupported) {
                if (!TRIGGER_SUPPORTED_MACROS.contains(macroName)) continue;
                parameters = this.extractParameters(macro);
                body = this.extractBody(macro);
                triggerMacros.add(TriggerMacro.builder().name(macroName).parameters(parameters).body(body).build());
                continue;
            }
            if (TRIGGER_SUPPORTED_MACROS.contains(macroName)) continue;
            parameters = this.extractParameters(macro);
            body = this.extractBody(macro);
            triggerMacros.add(TriggerMacro.builder().name(macroName).parameters(parameters).body(body).build());
        }
        return triggerMacros;
    }

    private List<String> extractParameters(String macro) {
        String MACRO_PARAM_REGEX = "(?<=:)([^|}]+(?:\\|[^|}]+)*)";
        Pattern macroParamPattern = Pattern.compile("(?<=:)([^|}]+(?:\\|[^|}]+)*)");
        Matcher paramMatcher = macroParamPattern.matcher(macro);
        if (paramMatcher.find()) {
            return List.of(paramMatcher.group(1).split("\\|"));
        }
        return Collections.emptyList();
    }

    private String extractBody(String macro) {
        String MACRO_BODY_REGEX = "\\{[^\\}]+\\}(.*?)\\{[^\\}]+\\}";
        Pattern macroBodyPattern = Pattern.compile("\\{[^\\}]+\\}(.*?)\\{[^\\}]+\\}", 32);
        Matcher bodyMatcher = macroBodyPattern.matcher(macro);
        return bodyMatcher.find() ? bodyMatcher.group(1).trim() : "";
    }

    private Map<String, Object> getAction(TriggerMacro macro, boolean isParsingMacro) {
        switch (macro.getName()) {
            case "set-state": {
                return ActionMapper.getChangeStateAction(macro, isParsingMacro);
            }
            case "publish-page": 
            case "remove-restriction": {
                return ActionMapper.getGenericAction(macro, isParsingMacro);
            }
            case "approve-page": 
            case "reject-page": {
                return ActionMapper.getApprovalAction(macro, isParsingMacro);
            }
            case "set-state-expiry": {
                return ActionMapper.getExpirationAction(macro, isParsingMacro);
            }
            case "set-message": {
                return ActionMapper.getSetMessageAction(macro, isParsingMacro);
            }
            case "send-email": {
                return ActionMapper.getSendEmailAction(macro, isParsingMacro);
            }
            case "set-label": 
            case "remove-label": {
                return ActionMapper.getLabelsAction(macro, isParsingMacro);
            }
            case "add-restriction": 
            case "set-restrictions": {
                return ActionMapper.getRestrictionsAction(macro, isParsingMacro);
            }
        }
        throw new IllegalArgumentException("Unsupported action: " + macro.getName());
    }

    private List<Map<String, Object>> getCloudStates(Set<Object> unsupportedParameters) {
        Set<Object> statesUnsupportedParameters = Collections.synchronizedSet(new HashSet());
        Set<Object> approvalsUnsupportedParameters = Collections.synchronizedSet(new HashSet());
        Collection states = (Collection)this.workflow.get(STATES);
        if (states == null || states.isEmpty()) {
            HashMap<String, String> state2 = new HashMap<String, String>();
            state2.put(NAME, "No state workflow");
            return Collections.singletonList(state2);
        }
        List<Map<String, Object>> cloudStates = states.parallelStream().map(e -> (Map)e).map(state -> {
            Object approvals;
            Object transitions;
            String dueDate;
            statesUnsupportedParameters.addAll(state.keySet().parallelStream().filter(e -> !STATE_SUPPORTED_PARAMETERS.contains(e)).collect(Collectors.toSet()));
            HashMap<String, Object> cloudState = new HashMap<String, Object>();
            ServerWorkflow.addName(state, cloudState);
            ServerWorkflow.addDescription(state, cloudState);
            cloudState.put(COLOUR, state.get(COLOUR));
            Boolean isFinal = (Boolean)state.get(FINAL);
            if (null != isFinal) {
                cloudState.put(FINAL, isFinal);
            }
            if (null != (dueDate = (String)state.get(DUE_DATE))) {
                cloudState.put(DUE_DATE, dueDate);
            }
            if (null != (transitions = state.get(TRANSITIONS))) {
                Map<String, Object> cloudTransitions = this.combineTransitions((List)transitions);
                if (cloudTransitions.containsKey(SUBMIT)) {
                    cloudTransitions.put(SELECT, cloudTransitions.get(SUBMIT));
                    cloudTransitions.remove(SUBMIT);
                    cloudState.put(TRANSITIONS, cloudTransitions);
                } else {
                    cloudState.put(TRANSITIONS, cloudTransitions);
                }
            }
            if (null != (approvals = state.get(APPROVALS))) {
                List<Map<String, Object>> cloudApprovals = ServerWorkflow.getCloudApprovals(approvalsUnsupportedParameters, (Collection)approvals);
                cloudState.put(APPROVALS, cloudApprovals);
            }
            return cloudState;
        }).collect(Collectors.toList());
        if (!statesUnsupportedParameters.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(statesUnsupportedParameters);
            unsupportedParameters.add(Collections.singletonMap(STATE, statesUnsupportedParameters));
        }
        if (!approvalsUnsupportedParameters.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(approvalsUnsupportedParameters);
            unsupportedParameters.add(Collections.singletonMap(APPROVAL, approvalsUnsupportedParameters));
        }
        return cloudStates;
    }

    private Map<String, Object> combineTransitions(List<Map<String, Object>> list) {
        Set selectNames = list.stream().map(map -> map.get(SELECT)).filter(Map.class::isInstance).map(value -> (Map)value).map(selectMap -> selectMap.get(NAMES)).filter(List.class::isInstance).flatMap(names -> ((List)names).stream()).map(Object::toString).collect(Collectors.toSet());
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!selectNames.isEmpty()) {
            result.put(SELECT, new ArrayList(selectNames));
        }
        list.stream().filter(map -> !map.containsKey(SELECT)).forEach(result::putAll);
        return result;
    }

    private static List<Map<String, Object>> getCloudApprovals(Set<Object> approvalsUnsupportedParameters, Collection<?> approvals) {
        return approvals.parallelStream().map(e -> (Map)e).map(approval -> {
            Boolean assignable;
            String credentials;
            String minimum;
            String rejectLabel;
            String approveLabel;
            HashMap<String, Object> cloudApproval = new HashMap<String, Object>();
            approvalsUnsupportedParameters.addAll(approval.entrySet().parallelStream().filter(entry -> !APPROVAL_SUPPORTED_PARAMETERS.contains(entry.getKey())).filter(entry -> !APPROVAL_PARAMETERS_TO_BE_IGNORED.contains(entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toSet()));
            ServerWorkflow.addName(approval, cloudApproval);
            List conditions = (List)approval.get(CONDITIONS);
            if (null != conditions) {
                approvalsUnsupportedParameters.addAll(conditions.parallelStream().map(e -> (Map)e).map(e -> e.get(TYPE)).collect(Collectors.toSet()));
            }
            if (null != (approveLabel = (String)approval.get(APPROVE_LABEL))) {
                cloudApproval.put(APPROVE_LABEL, approveLabel);
            }
            if (null != (rejectLabel = (String)approval.get(REJECT_LABEL))) {
                cloudApproval.put(REJECT_LABEL, rejectLabel);
            }
            if (null != (minimum = (String)approval.get(MINIMUM)) && !"1".equals(minimum)) {
                cloudApproval.put(MINIMUM, minimum);
            }
            if (null != (credentials = (String)approval.get(CREDENTIALS))) {
                cloudApproval.put(CREDENTIALS, USER_PASSWORD);
            }
            if (null != (assignable = (Boolean)approval.get(ASSIGNABLE)) && assignable.booleanValue()) {
                cloudApproval.put(ASSIGNABLE, true);
            }
            ServerWorkflow.addPreassignedUsers(approval, cloudApproval);
            ServerWorkflow.addPreassignedGroups(approval, cloudApproval);
            return cloudApproval;
        }).collect(Collectors.toList());
    }

    private Set<Object> getRootUnsupportedElements() {
        return this.workflow.keySet().parallelStream().filter(e -> !ROOT_SUPPORTED_ELEMENTS.contains(e)).filter(e -> !ROOT_ELEMENTS_TO_BE_IGNORED.contains(e)).filter(e -> !WORKFLOW_UNSUPPORTED_PARAMETERS.contains(e)).filter(e -> !WORKFLOW_UNSUPPORTED_SPECIAL_PARAMETERS.contains(e)).collect(Collectors.toSet());
    }

    private Set<Object> getUnsupportedParameters() {
        Set<Object> unsupportedParametersKeys = this.workflow.entrySet().parallelStream().filter(ServerWorkflow::isUnsupportedParameter).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!this.workflow.containsKey(DISPLAY_PROGRESS_TRACKER)) {
            unsupportedParametersKeys.add(DISPLAY_PROGRESS_TRACKER);
        }
        HashSet<Object> unsupportedParameters = new HashSet<Object>();
        if (!unsupportedParametersKeys.isEmpty()) {
            ServerWorkflow.convertKeysToMarkupStyle(unsupportedParametersKeys);
            unsupportedParameters.add(Collections.singletonMap("workflow", unsupportedParametersKeys));
        }
        return unsupportedParameters;
    }

    private static boolean isUnsupportedParameter(Map.Entry<String, Object> entry) {
        return CONTENT_TYPES.equals(entry.getKey()) && ((List)entry.getValue()).size() != 2 || WORKFLOW_UNSUPPORTED_PARAMETERS.contains(entry.getKey());
    }

    private static void convertKeysToMarkupStyle(Set<Object> unsupported) {
        UNSUPPORTED_KEYS_DICTIONARY.keySet().parallelStream().forEach(key -> {
            if (unsupported.contains(key)) {
                unsupported.remove(key);
                unsupported.add(UNSUPPORTED_KEYS_DICTIONARY.get(key));
            }
        });
    }

    private static void addName(Map<String, Object> source, Map<String, Object> target) {
        target.put(NAME, source.get(NAME));
    }

    private static void addDescription(Map<String, Object> source, Map<String, Object> target) {
        String description = (String)source.get(DESCRIPTION);
        if (null != description) {
            target.put(DESCRIPTION, description);
        }
    }

    private static void addLabels(Map<String, Object> source, Map<String, Object> target) {
        List labels = (List)source.get(LABELS);
        if (null != labels && !labels.isEmpty()) {
            target.put(LABELS, labels);
        }
    }

    private static void addStickyLabels(Map<String, Object> source, Map<String, Object> target) {
        List labels = (List)source.get(STICKY_LABELS);
        if (null != labels && !labels.isEmpty()) {
            target.put(STICKY_LABELS, labels);
        }
    }

    private static void addInvertLabel(Map<String, Object> source, Map<String, Object> target) {
        Boolean invertLabels = (Boolean)source.get(INVERT_LABELS);
        if (null != invertLabels) {
            target.put(EXCLUDED_LABELS, invertLabels);
        }
    }

    private static void addPreassignedUsers(Map<String, Object> source, Map<String, Object> target) {
        Map selectedApprovers;
        Map selectedApprover;
        Map users;
        HashMap preassignedUsersMap = new HashMap();
        HashSet usersSet = new HashSet();
        Map preassignedUsers = (Map)source.get(PREASSIGNED_USERS);
        if (null != preassignedUsers) {
            usersSet.addAll(((List)preassignedUsers.get(ITEMS)).stream().map(String::trim).collect(Collectors.toList()));
        }
        if (null != (users = (Map)source.get(USERS))) {
            usersSet.addAll(((List)users.get(ITEMS)).stream().map(String::trim).collect(Collectors.toList()));
        }
        if (null != (selectedApprover = (Map)source.get(SELECTED_APPROVER))) {
            usersSet.addAll(((List)selectedApprover.get(ITEMS)).stream().map(String::trim).collect(Collectors.toList()));
        }
        if (null != (selectedApprovers = (Map)source.get(SELECTED_APPROVERS))) {
            usersSet.addAll(((List)selectedApprovers.get(ITEMS)).stream().map(String::trim).collect(Collectors.toList()));
        }
        if (!usersSet.isEmpty()) {
            preassignedUsersMap.put(ITEMS, usersSet);
            target.put(PREASSIGNED_USERS, preassignedUsersMap);
        }
    }

    private static void addPreassignedGroups(Map<String, Object> source, Map<String, Object> target) {
        Map groups;
        HashMap preassignedGroupsMap = new HashMap();
        HashSet groupsSet = new HashSet();
        Map preassignedGroups = (Map)source.get(PREASSIGNED_GROUPS);
        if (null != preassignedGroups) {
            groupsSet.addAll(((List)preassignedGroups.get(ITEMS)).stream().map(String::trim).collect(Collectors.toList()));
        }
        if (null != (groups = (Map)source.get(GROUPS))) {
            groupsSet.addAll(((List)groups.get(ITEMS)).stream().map(String::trim).collect(Collectors.toList()));
        }
        if (!groupsSet.isEmpty()) {
            preassignedGroupsMap.put(ITEMS, groupsSet);
            target.put(PREASSIGNED_GROUPS, preassignedGroupsMap);
        }
    }

    ServerWorkflow(Map<String, Object> workflow) {
        this.workflow = workflow;
    }

    public static ServerWorkflowBuilder builder() {
        return new ServerWorkflowBuilder();
    }

    public static class ServerWorkflowBuilder {
        private Map<String, Object> workflow;

        ServerWorkflowBuilder() {
        }

        public ServerWorkflowBuilder workflow(Map<String, Object> workflow) {
            this.workflow = workflow;
            return this;
        }

        public ServerWorkflow build() {
            return new ServerWorkflow(this.workflow);
        }

        public String toString() {
            return "ServerWorkflow.ServerWorkflowBuilder(workflow=" + this.workflow + ")";
        }
    }
}

