/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.tasks.model;

import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.tasks.model.TaskAttribute;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonCreator;

public class PageTasks {
    private List<PageTask> tasks;
    private List<PageTask> deletedTasks;

    public PageTasks() {
        this.tasks = new ArrayList<PageTask>();
        this.deletedTasks = new ArrayList<PageTask>();
    }

    public PageTasks(List<PageTask> tasks, List<PageTask> deletedTasks) {
        this.tasks = tasks;
        this.deletedTasks = deletedTasks;
    }

    @com.fasterxml.jackson.annotation.JsonCreator
    @JsonCreator
    public PageTasks(@JsonProperty(value="deletedTasks") @org.codehaus.jackson.annotate.JsonProperty(value="deletedTasks") List<PageTask> deletedTasks) {
        this.deletedTasks = deletedTasks;
    }

    @JsonGetter(value="tasks")
    public List<PageTask> getTasks() {
        return this.tasks;
    }

    public List<PageTask> get() {
        return this.tasks;
    }

    public List<PageTask> getActiveTasks() {
        ArrayList<PageTask> activeTasks = new ArrayList<PageTask>();
        for (PageTask task : this.tasks) {
            if (task.isCompleted()) continue;
            activeTasks.add(task);
        }
        return activeTasks;
    }

    public List<PageTask> getCompletedTasks() {
        ArrayList<PageTask> completedTasks = new ArrayList<PageTask>();
        for (PageTask task : this.tasks) {
            if (!task.isCompleted()) continue;
            completedTasks.add(task);
        }
        return completedTasks;
    }

    @JsonGetter(value="deletedTasks")
    public List<PageTask> getDeletedTasks() {
        return this.deletedTasks;
    }

    public void setDeletedTasks(List<PageTask> deletedTasks) {
        this.deletedTasks = deletedTasks;
    }

    public PageTask getById(int taskId) {
        for (PageTask task : this.tasks) {
            if (task.getId() != taskId) continue;
            return task;
        }
        return null;
    }

    public PageTask getByName(String name) {
        for (PageTask task : this.tasks) {
            if (!task.getName().equals(name)) continue;
            return task;
        }
        return null;
    }

    public void add(PageTask task) {
        if (task.getId() == 0) {
            if (this.tasks.size() > 0) {
                task.setId(this.tasks.get(this.tasks.size() - 1).getId() + 1);
            } else {
                task.setId(1);
            }
        }
        this.tasks.add(task);
    }

    public void addDeletedTask(PageTask task) {
        this.deletedTasks.add(task);
    }

    public void addWithoutSettingId(PageTask task) {
        this.tasks.add(task);
    }

    public void update(PageTask task) {
        PageTask pageTask = this.getById(task.getId());
        if (pageTask != null) {
            pageTask.setCompletions(task.getCompletions());
            pageTask.setAssignments(task.getAssignments());
            pageTask.setName(task.getName());
            pageTask.setComment(task.getComment());
            pageTask.setCurrentDueDate(task.getCurrentDueDate());
            pageTask.setDueDateHistory(task.getDueDateHistory());
        }
    }

    public void remove(int taskId) {
        Iterator<PageTask> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getId() != taskId) continue;
            iterator.remove();
            break;
        }
    }

    private Set<TaskAttribute> getActiveAttributes() {
        HashSet<TaskAttribute> set = new HashSet<TaskAttribute>();
        set.add(TaskAttribute.TASK);
        for (PageTask task : this.tasks) {
            Assignment assignment = task.getCurrentAssignment();
            if (assignment == null) continue;
            if (assignment.hasAssignees()) {
                set.add(TaskAttribute.ASSIGNEE);
            }
            if (assignment.getDueDate() == null) continue;
            set.add(TaskAttribute.DUEDATE);
        }
        return set;
    }

    public int size() {
        return this.tasks.size();
    }

    public Stats getStats() {
        Stats stats = new Stats();
        for (PageTask task : this.tasks) {
            ++stats.total;
            if (task.isCompleted()) {
                ++stats.completed;
                continue;
            }
            ++stats.open;
        }
        return stats;
    }

    public boolean hasPendingTasks() {
        for (PageTask task : this.tasks) {
            if (task.isCompleted()) continue;
            return true;
        }
        return false;
    }

    public boolean isCompleted() {
        return this.tasks.stream().allMatch(PageTask::isCompleted);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageTasks pageTasks = (PageTasks)o;
        if (!Objects.equals(this.tasks, pageTasks.tasks)) {
            return false;
        }
        return Objects.equals(this.deletedTasks, pageTasks.deletedTasks);
    }

    public void addInvolvedUsers(Set<String> userNames) {
        for (PageTask task : this.tasks) {
            for (Assignment assignment : task.getAssignments()) {
                if (!StringUtils.isNotBlank((CharSequence)assignment.getAssignee())) continue;
                userNames.add(assignment.getAssignee());
            }
        }
    }

    public int hashCode() {
        return this.tasks != null ? this.tasks.hashCode() : 0;
    }

    public String toString() {
        return "Tasks: " + this.tasks.toString() + "    Deleted Tasks: " + this.deletedTasks.toString();
    }

    public static class Stats {
        int total = 0;
        int open = 0;
        int completed = 0;

        public int getTotal() {
            return this.total;
        }

        public int getOpen() {
            return this.open;
        }

        public int getCompleted() {
            return this.completed;
        }
    }
}

