/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.listener;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.ConfluenceSpaceContainerV1;
import com.atlassian.migration.app.ContainerType;
import com.atlassian.migration.app.PaginatedContainers;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.usecases.contracts.ContentMigrationProcessor;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivityMigrationData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.Presenter;
import com.comalatech.confluence.cloud.migration.usecases.contracts.SpaceMigrationProcessor;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.license.ComalaDocumentAppManager;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.workflow.model.Workflow;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class WorkflowsCloudMigrationListener
implements DiscoverableListener {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsCloudMigrationListener.class);
    private final PluginLicenseManager licenseManager;
    private final Presenter<File> fileJsonPresenter;
    private final Presenter<String> jsonPresenter;
    private final SpaceMigrationProcessor spaceMigrationProcessor;
    private final List<ContentMigrationProcessor> contentMigrationProcessor;
    private final ObjectMapper objectMapper;
    private final ComalaDocumentAppManager comalaDocumentAppManager;
    private final WorkflowService workflowService;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final GeneratePageActivityMigrationData pageActivityGeneratorUseCase;
    private static final int SPACE_CONTAINERS_BATCH = 50;

    public WorkflowsCloudMigrationListener(@ComponentImport PluginLicenseManager pluginLicenseManager, @Qualifier(value="fileJsonPresenter") Presenter<File> fileJsonPresenter, @Qualifier(value="jsonPresenter") Presenter<String> jsonPresenter, ComalaDocumentAppManager comalaDocumentAppManager, SpaceMigrationProcessor spaceMigrationProcessor, List<ContentMigrationProcessor> contentMigrationProcessor, WorkflowService workflowService, ReadWriteTransactionService readWriteTransactionService, GeneratePageActivityMigrationData pageActivityGeneratorUseCase) {
        this.licenseManager = pluginLicenseManager;
        this.fileJsonPresenter = fileJsonPresenter;
        this.spaceMigrationProcessor = spaceMigrationProcessor;
        this.contentMigrationProcessor = contentMigrationProcessor;
        this.jsonPresenter = jsonPresenter;
        this.comalaDocumentAppManager = comalaDocumentAppManager;
        this.workflowService = workflowService;
        this.readWriteTransactionService = readWriteTransactionService;
        this.pageActivityGeneratorUseCase = pageActivityGeneratorUseCase;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public void onStartAppMigration(AppCloudMigrationGateway gateway, String transferId, MigrationDetailsV1 migrationDetails) {
        try {
            log.warn("Migration context summary: {}. Migration process could take a while processing the spaces.", (Object)this.objectMapper.writeValueAsString(migrationDetails));
            PaginatedContainers paginatedSiteContainers = gateway.getPaginatedContainers(transferId, ContainerType.ConfluenceSpace, 50);
            LinkedHashSet<String> spaceKeyList = new LinkedHashSet<String>();
            while (paginatedSiteContainers.next()) {
                spaceKeyList.addAll(WorkflowsCloudMigrationListener.getSpaceKeys(paginatedSiteContainers));
            }
            List spacesWithWorkflows = this.readWriteTransactionService.executeInReadWriteTransaction(() -> this.workflowService.getSpacesWithWorkflows(spaceKeyList));
            HashMap<AbstractPage, LinkedHashMap<PageState, List<Activity>>> pageActivities = new HashMap<AbstractPage, LinkedHashMap<PageState, List<Activity>>>(this.pageActivityGeneratorUseCase.getActivities(spacesWithWorkflows));
            ArrayList<Migration> migrations = new ArrayList<Migration>();
            migrations.add(this.spaceMigrationProcessor.process(gateway, spacesWithWorkflows, transferId, migrationDetails));
            migrations.addAll(this.contentMigrationProcessor.stream().map(generator -> {
                try {
                    return generator.process(gateway, pageActivities, transferId, migrationDetails);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList()));
            migrations.forEach(migration -> {
                File jsonFile = this.fileJsonPresenter.present(migration);
                try {
                    log.info("Sending {} bytes of data for transferId {} and label {} ", new Object[]{jsonFile.length(), transferId, migration.label});
                    this.sendActivitiesToMigrationService(gateway, transferId, jsonFile, migration.label + "-" + this.comalaDocumentAppManager.getVersionNumber());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            log.error("Error during the migration process", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getCloudAppKey() {
        return this.licenseManager.getPluginKey();
    }

    @Override
    public String getServerAppKey() {
        return this.licenseManager.getPluginKey();
    }

    @Override
    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_PRODUCT, AccessScope.MIGRATION_TRACING_IDENTITY).collect(Collectors.toCollection(HashSet::new));
    }

    private List<String> findSpacesWithWorkflows(Set<String> spaceKeyList) {
        ArrayList<String> spacesWithWorkflow = new ArrayList<String>();
        spaceKeyList.forEach(spaceKey -> {
            List<Workflow> workflows = this.workflowService.getWorkflows((String)spaceKey);
            if (workflows != null && !workflows.isEmpty()) {
                spacesWithWorkflow.add((String)spaceKey);
            } else if (this.workflowService.hasPageWorkflows((String)spaceKey)) {
                spacesWithWorkflow.add((String)spaceKey);
            } else {
                log.warn("Space {} does not use Comala Document Management", spaceKey);
            }
        });
        return spacesWithWorkflow;
    }

    private static List<String> getSpaceKeys(PaginatedContainers paginatedSiteContainers) {
        return paginatedSiteContainers.getContainers().stream().filter(ConfluenceSpaceContainerV1.class::isInstance).map(container -> ((ConfluenceSpaceContainerV1)container).getKey()).collect(Collectors.toList());
    }

    private void sendActivitiesToMigrationService(AppCloudMigrationGateway gateway, String transferId, File jsonActivities, String label) throws IOException {
        try (OutputStream atlassianMigrationDataStream = gateway.createAppData(transferId, label);
             InputStream activitiesDataStream = Files.newInputStream(jsonActivities.toPath(), new OpenOption[0]);){
            IOUtils.copy((InputStream)activitiesDataStream, (OutputStream)atlassianMigrationDataStream);
        }
    }
}

