/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function(CW, $) {
    CW.toInit(function () {
        // E-Signatures Setup
        var ESignaturesConfigurationIframe = new CW.iframe({
            id: 'ESignaturesConfigurationIframe',
            url: '/admin/esignatures',
            width: '100%',
            height: '100%'
        });
        $('#cw-esignatures-admin-container').html(ESignaturesConfigurationIframe.render());

        CW.connect("refreshEsignatures", function (value) {
            ESignaturesConfigurationIframe.send('refreshEsignatures', value);
        });

        // Modal: Expiry Date
        CW.connect("otpExpiryModal", function (modalData) {
            var userKey = modalData.userKey;
            var expirationDate = modalData.expirationDate;

            var openModal = new CW.Dialog({
                id: 'cw-modal',
                width: 500,
                height: 530,
                path: '/modal/otpexpiry',
                query: {
                    userKey: userKey,
                    expirationDate: expirationDate,
                    locale: String(CW.getParam('userLocale') || CW.getParam('actionLocale')).substring(0,2),
                    timeZone: CW.getMeta('user-timezone-offset')
                }
            });
            openModal.show();
        });
    });
});
